/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2;

import java.io.IOException;
import java.util.Optional;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.cache.AbstractConnection;
import org.apache.hertzbeat.collector.collect.common.cache.CacheIdentifier;
import org.apache.hertzbeat.collector.collect.common.cache.GlobalConnectionCache;
import org.apache.hertzbeat.collector.collect.ipmi2.cache.IpmiConnect;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiClient;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiConnection;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiHandlerManager;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.IpmiProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class IpmiCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(IpmiCollectImpl.class);
    private final GlobalConnectionCache connectionCommonCache = GlobalConnectionCache.getInstance();
    private final IpmiHandlerManager ipmiHandlerManager = new IpmiHandlerManager();

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getIpmi() == null) {
            throw new IllegalArgumentException("Ipmi collect must has ipmi params");
        }
        IpmiProtocol ipmiProtocol = metrics.getIpmi();
        Assert.hasText((String)ipmiProtocol.getHost(), (String)"Ipmi Protocol host is required.");
        Assert.hasText((String)ipmiProtocol.getPort(), (String)"Ipmi Protocol port is required.");
        Assert.hasText((String)ipmiProtocol.getUsername(), (String)"Ipmi Protocol username is required.");
        Assert.hasText((String)ipmiProtocol.getPassword(), (String)"Ipmi Protocol password is required.");
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        IpmiConnection connection = null;
        try {
            connection = this.getIpmiConnection(metrics.getIpmi());
        }
        catch (Exception e) {
            log.error("Ipmi session create error: {}", (Object)e.getMessage());
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(e.getMessage());
            return;
        }
        try {
            connection.getResource(builder, metrics);
        }
        catch (IOException e) {
            log.error("Get Ipmi {} detail resource error: {}", (Object)metrics.getName(), (Object)e.getMessage());
        }
    }

    public String supportProtocol() {
        return "ipmi";
    }

    private IpmiConnection getIpmiConnection(IpmiProtocol ipmiProtocol) throws Exception {
        IpmiConnect ipmiConnect;
        CacheIdentifier identifier = CacheIdentifier.builder().ip(ipmiProtocol.getHost()).port(ipmiProtocol.getPort()).username(ipmiProtocol.getUsername()).password(ipmiProtocol.getPassword()).build();
        IpmiConnection connection = null;
        Optional cacheOption = this.connectionCommonCache.getCache((Object)identifier, true);
        if (cacheOption.isPresent() && ((connection = (ipmiConnect = (IpmiConnect)((Object)cacheOption.get())).getConnection()) == null || !connection.isActive())) {
            connection = null;
            this.connectionCommonCache.removeCache((Object)identifier);
        }
        if (connection != null) {
            return connection;
        }
        IpmiClient ipmiClient = IpmiClient.create(ipmiProtocol);
        connection = ipmiClient.connect();
        this.connectionCommonCache.addCache((Object)identifier, (AbstractConnection)new IpmiConnect(connection));
        return connection;
    }
}

