/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.HmacMd5128;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.HmacSha196;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.HmacSha256128;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.IpmiIntegrity;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.Md5128;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.None;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum IpmiIntegrityCode implements IpmiCode.Code
{
    NONE(0, None.class),
    HMAC_SHA1_96(1, HmacSha196.class),
    HMAC_MD5_128(2, HmacMd5128.class),
    MD5_128(3, Md5128.class),
    HMAC_SHA256_128(4, HmacSha256128.class);

    private final byte code;
    private final Class<? extends IpmiIntegrity> integrity;

    private IpmiIntegrityCode(int code, Class<? extends IpmiIntegrity> integrity) {
        this.code = ByteConvertUtils.checkCastByte(code);
        this.integrity = integrity;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    public IpmiIntegrity newIpmiIntegrity() {
        if (this.integrity == null) {
            return null;
        }
        try {
            return this.integrity.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

