/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.ScriptProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScriptCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(ScriptCollectImpl.class);
    private static final String CMD = "cmd";
    private static final String BASH = "bash";
    private static final String POWERSHELL = "powershell";
    private static final String CMD_C = "/c";
    private static final String BASH_C = "-c";
    private static final String POWERSHELL_C = "-Command";
    private static final String POWERSHELL_FILE = "-File";
    private static final String PARSE_TYPE_ONE_ROW = "oneRow";
    private static final String PARSE_TYPE_MULTI_ROW = "multiRow";
    private static final String PARSE_TYPE_NETCAT = "netcat";
    private static final String PARSE_TYPE_LOG = "log";

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        Assert.notNull((Object)metrics, (String)"Script collect must has Imap params");
        ScriptProtocol scriptProtocol = metrics.getScript();
        Assert.notNull((Object)scriptProtocol, (String)"Script collect must has Imap params");
        Assert.notNull((Object)scriptProtocol.getCharset(), (String)"Script charset is required");
        Assert.notNull((Object)scriptProtocol.getParseType(), (String)"Script parse type is required");
        Assert.notNull((Object)scriptProtocol.getScriptTool(), (String)"Script tool is required");
        if (!StringUtils.hasText((String)scriptProtocol.getScriptCommand()) && !StringUtils.hasText((String)scriptProtocol.getScriptPath())) {
            throw new IllegalArgumentException("At least one script command or script path is required.");
        }
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        ProcessBuilder processBuilder;
        ScriptProtocol scriptProtocol = metrics.getScript();
        long startTime = System.currentTimeMillis();
        if (StringUtils.hasText((String)scriptProtocol.getScriptCommand())) {
            switch (scriptProtocol.getScriptTool()) {
                case "bash": {
                    processBuilder = new ProcessBuilder(BASH, BASH_C, scriptProtocol.getScriptCommand().trim());
                    break;
                }
                case "cmd": {
                    processBuilder = new ProcessBuilder(CMD, CMD_C, scriptProtocol.getScriptCommand().trim());
                    break;
                }
                case "powershell": {
                    processBuilder = new ProcessBuilder("powershell.exe", POWERSHELL_C, scriptProtocol.getScriptCommand().trim());
                    break;
                }
                default: {
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg("Not support script tool:" + scriptProtocol.getScriptTool());
                    return;
                }
            }
        } else if (StringUtils.hasText((String)scriptProtocol.getScriptPath())) {
            switch (scriptProtocol.getScriptTool()) {
                case "bash": {
                    processBuilder = new ProcessBuilder(BASH, scriptProtocol.getScriptPath().trim());
                    break;
                }
                case "cmd": {
                    processBuilder = new ProcessBuilder(CMD, scriptProtocol.getScriptPath().trim());
                    break;
                }
                case "powershell": {
                    processBuilder = new ProcessBuilder(POWERSHELL, POWERSHELL_FILE, scriptProtocol.getScriptPath().trim());
                    break;
                }
                default: {
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg("Not support script tool:" + scriptProtocol.getScriptTool());
                    return;
                }
            }
        } else {
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("At least one script command or script path is required.");
            return;
        }
        String workDirectory = scriptProtocol.getWorkDirectory();
        if (StringUtils.hasText((String)workDirectory)) {
            processBuilder.directory(new File(workDirectory));
        }
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName(scriptProtocol.getCharset())));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (!StringUtils.hasText((String)line)) continue;
                response.append(line).append("\n");
            }
            process.waitFor();
            Long responseTime = System.currentTimeMillis() - startTime;
            String result = String.valueOf(response);
            if (!StringUtils.hasText((String)result)) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("Script response data is null");
                return;
            }
            switch (scriptProtocol.getParseType()) {
                case "log": {
                    this.parseResponseDataByLog(result, metrics.getAliasFields(), builder, responseTime);
                    break;
                }
                case "netcat": {
                    this.parseResponseDataByNetcat(result, metrics.getAliasFields(), builder, responseTime);
                    break;
                }
                case "oneRow": {
                    this.parseResponseDataByOne(result, metrics.getAliasFields(), builder, responseTime);
                    break;
                }
                case "multiRow": {
                    this.parseResponseDataByMulti(result, metrics.getAliasFields(), builder, responseTime);
                    break;
                }
                default: {
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg("Script collect not support this parse type: " + scriptProtocol.getParseType());
                    break;
                }
            }
        }
        catch (IOException ioException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)ioException);
            log.warn(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("Peer io failed: " + errorMsg);
        }
        catch (InterruptedException interruptedException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)interruptedException);
            log.warn(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("Peer interrupt this script: " + errorMsg);
        }
        catch (Exception exception) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)exception);
            log.warn(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    public String supportProtocol() {
        return "script";
    }

    private void parseResponseDataByLog(String result, List<String> aliasFields, CollectRep.MetricsData.Builder builder, Long responseTime) {
        String[] lines = result.split("\n");
        if (lines.length + 1 < aliasFields.size()) {
            log.error("Response data not enough: {}", (Object)result);
            return;
        }
        for (String line : lines) {
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : aliasFields) {
                if ("responseTime".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(responseTime.toString());
                    continue;
                }
                valueRowBuilder.addColumn(line);
            }
            builder.addValueRow(valueRowBuilder.build());
        }
    }

    private void parseResponseDataByNetcat(String result, List<String> aliasFields, CollectRep.MetricsData.Builder builder, Long responseTime) {
        String[] lines = result.split("\n");
        if (lines.length + 1 < aliasFields.size()) {
            log.error("ssh response data not enough: {}", (Object)result);
            return;
        }
        boolean contains = lines[0].contains("=");
        Map<String, String> mapValue = Arrays.stream(lines).map(item -> {
            if (contains) {
                return item.split("=");
            }
            return item.split("\t");
        }).filter(item -> ((String[])item).length == 2).collect(Collectors.toMap(x -> x[0], x -> x[1]));
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String field : aliasFields) {
            String fieldValue = mapValue.get(field);
            valueRowBuilder.addColumn(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    private void parseResponseDataByOne(String result, List<String> aliasFields, CollectRep.MetricsData.Builder builder, Long responseTime) {
        String[] lines = result.split("\n");
        if (lines.length + 1 < aliasFields.size()) {
            log.error("ssh response data not enough: {}", (Object)result);
            return;
        }
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        int lineIndex = 0;
        for (int aliasIndex = 0; aliasIndex < aliasFields.size(); ++aliasIndex) {
            if ("responseTime".equalsIgnoreCase(aliasFields.get(aliasIndex))) {
                valueRowBuilder.addColumn(responseTime.toString());
                continue;
            }
            if (lineIndex < lines.length) {
                valueRowBuilder.addColumn(lines[lineIndex].trim());
            } else {
                valueRowBuilder.addColumn("&nbsp;");
            }
            ++lineIndex;
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    private void parseResponseDataByMulti(String result, List<String> aliasFields, CollectRep.MetricsData.Builder builder, Long responseTime) {
        int i;
        String[] lines = result.split("\n");
        if (lines.length <= 1) {
            log.error("ssh response data only has header: {}", (Object)result);
            return;
        }
        String[] fields = lines[0].split("\\s+");
        HashMap<String, Integer> fieldMapping = new HashMap<String, Integer>(fields.length);
        for (i = 0; i < fields.length; ++i) {
            fieldMapping.put(fields[i].trim().toLowerCase(), i);
        }
        for (i = 1; i < lines.length; ++i) {
            String[] values = lines[i].split("\\s+");
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : aliasFields) {
                if ("responseTime".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(responseTime.toString());
                    continue;
                }
                Integer index = (Integer)fieldMapping.get(alias.toLowerCase());
                if (index != null && index < values.length) {
                    valueRowBuilder.addColumn(values[index]);
                    continue;
                }
                valueRowBuilder.addColumn("&nbsp;");
            }
            builder.addValueRow(valueRowBuilder.build());
        }
    }
}

