/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Savepoint;
import java.util.concurrent.atomic.AtomicInteger;

public class DmdbSavepoint
implements Savepoint {
    public DmdbSavepoint standby = null;
    private static final String NAME_PREFIX_DEFAULT = "DMDB_SVPT_";
    private static final AtomicInteger SEED = new AtomicInteger(0);
    private int id;
    public String name;
    public boolean released = false;
    private DmdbConnection conn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmdbSavepoint(DmdbConnection dmdbConnection, String string) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            this.conn = dmdbConnection;
            if (StringUtil.isEmpty(string)) {
                this.id = SEED.incrementAndGet();
                this.name = NAME_PREFIX_DEFAULT + this.id;
            } else {
                this.id = -1;
                this.name = string;
            }
            String string2 = "SAVEPOINT \"" + StringUtil.processDoubleQuoteOfName(this.name) + "\"";
            DriverUtil.execute(this.conn, string2);
        }
    }

    @Override
    public int getSavepointId() {
        if (this.id < 0) {
            DBError.ECJDBC_CANNOT_GET_SAVEPOINT_ID.throwz(new Object[0]);
        }
        return this.id;
    }

    @Override
    public String getSavepointName() {
        if (this.id >= 0) {
            DBError.ECJDBC_CANNOT_GET_SAVEPOINT_NAME.throwz(new Object[0]);
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (this.released) {
                return;
            }
            String string = "RELEASE_SAVEPOINT('" + StringUtil.processSingleQuoteOfName(this.name) + "')";
            DriverUtil.execute(this.conn, string);
            this.released = true;
        }
    }
}

