/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.log;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.filter.log.LogWriter$LoggerHolder;
import dm.jdbc.processor.BaseFlusher;
import dm.jdbc.util.StringUtil;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class LogWriter
extends BaseFlusher {
    protected static LinkedBlockingQueue flushQueue = new LinkedBlockingQueue();

    private LogWriter() {
        super("LogFlusher", DmSvcConf.GLOBAL.logDir, "dm_jdbc", DmSvcConf.GLOBAL.logFlushFreq);
        this.start();
    }

    public static LogWriter getInstance() {
        return LogWriter$LoggerHolder.access$0();
    }

    @Override
    protected void doRun() {
        byte[] byArray = null;
        while (this.flushFreq > 0) {
            try {
                byArray = (byte[])flushQueue.poll(DmSvcConf.GLOBAL.logFlushFreq, TimeUnit.SECONDS);
                if (byArray != null) {
                    this.buffer.putBytes(byArray, 0, byArray.length);
                }
                if ((byArray != null || this.buffer.length() <= 0) && this.buffer.length() < 32768) continue;
                this.doFlush(this.buffer);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected void beforeExit() {
        byte[] byArray = null;
        while ((byArray = (byte[])flushQueue.poll()) != null) {
            this.buffer.putBytes(byArray, 0, byArray.length);
            if (this.buffer.length() < DmSvcConf.GLOBAL.logBufferSize) continue;
            this.doFlush(this.buffer);
        }
        if (this.buffer.length() > 0) {
            this.doFlush(this.buffer);
        }
    }

    public synchronized void write(String string) {
        try {
            byte[] byArray = string.getBytes();
            flushQueue.put(byArray);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized void writeLine(String string) {
        try {
            byte[] byArray = (String.valueOf(StringUtil.trimToEmpty(string)) + StringUtil.LINE_SEPARATOR).getBytes();
            flushQueue.put(byArray);
        }
        catch (Exception exception) {}
    }

    public synchronized void writeLines(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (String string : list) {
            this.writeLine(string);
        }
    }

    /* synthetic */ LogWriter(LogWriter logWriter) {
        this();
    }
}

