/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.fn.builders.operation;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.servers.Server;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.fn.RouterOperation;

public class Builder {
    private Class<?> beanClass;
    private String beanMethod;
    private Class<?>[] parameterTypes;
    private String method = "";
    private String[] tags = new String[0];
    private String summary = "";
    private String description = "";
    private RequestBody requestBody = org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().build();
    private ExternalDocumentation externalDocs = org.springdoc.core.fn.builders.externaldocumentation.Builder.externalDocumentationBuilder().build();
    private String operationId = "";
    private Parameter[] parameters = new Parameter[0];
    private ApiResponse[] responses = new ApiResponse[0];
    private boolean deprecated;
    private SecurityRequirement[] security = new SecurityRequirement[0];
    private Server[] servers = new Server[0];
    private Extension[] extensions = new Extension[0];
    private boolean hidden;
    private boolean ignoreJsonView;

    private Builder() {
    }

    public static Builder operationBuilder() {
        return new Builder();
    }

    public Builder method(String method) {
        this.method = method;
        return this;
    }

    public Builder tags(String[] tags) {
        this.tags = tags;
        return this;
    }

    public Builder tag(String tag) {
        this.tags = (String[])ArrayUtils.add((Object[])this.tags, (Object)tag);
        return this;
    }

    public Builder summary(String summary) {
        this.summary = summary;
        return this;
    }

    public Builder description(String description) {
        this.description = description;
        return this;
    }

    public Builder requestBody(org.springdoc.core.fn.builders.requestbody.Builder requestBodyBuilder) {
        this.requestBody = requestBodyBuilder.build();
        return this;
    }

    public Builder externalDocs(org.springdoc.core.fn.builders.externaldocumentation.Builder externalDocumentationBuilder) {
        this.externalDocs = externalDocumentationBuilder.build();
        return this;
    }

    public Builder operationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public Builder parameter(org.springdoc.core.fn.builders.parameter.Builder parameterBuilder) {
        this.parameters = (Parameter[])ArrayUtils.add((Object[])this.parameters, (Object)parameterBuilder.build());
        return this;
    }

    public Builder response(org.springdoc.core.fn.builders.apiresponse.Builder apiResponseBuilder) {
        this.responses = (ApiResponse[])ArrayUtils.add((Object[])this.responses, (Object)apiResponseBuilder.build());
        return this;
    }

    public Builder deprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Builder security(org.springdoc.core.fn.builders.securityrequirement.Builder securityRequirementBuilder) {
        this.security = (SecurityRequirement[])ArrayUtils.add((Object[])this.security, (Object)securityRequirementBuilder.build());
        return this;
    }

    public Builder servers(org.springdoc.core.fn.builders.server.Builder serverBuilder) {
        this.servers = (Server[])ArrayUtils.add((Object[])this.servers, (Object)serverBuilder.build());
        return this;
    }

    public Builder extensions(org.springdoc.core.fn.builders.extension.Builder extensionBuilder) {
        this.extensions = (Extension[])ArrayUtils.add((Object[])this.extensions, (Object)extensionBuilder.build());
        return this;
    }

    public Builder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Builder ignoreJsonView(boolean ignoreJsonView) {
        this.ignoreJsonView = ignoreJsonView;
        return this;
    }

    public Builder beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public Builder beanMethod(String beanMethod) {
        this.beanMethod = beanMethod;
        return this;
    }

    public Builder parameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
        return this;
    }

    public RouterOperation build() {
        Operation operation = new Operation(){

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public String method() {
                return Builder.this.method;
            }

            public String[] tags() {
                return Builder.this.tags;
            }

            public String summary() {
                return Builder.this.summary;
            }

            public String description() {
                return Builder.this.description;
            }

            public RequestBody requestBody() {
                return Builder.this.requestBody;
            }

            public ExternalDocumentation externalDocs() {
                return Builder.this.externalDocs;
            }

            public String operationId() {
                return Builder.this.operationId;
            }

            public Parameter[] parameters() {
                return Builder.this.parameters;
            }

            public ApiResponse[] responses() {
                return Builder.this.responses;
            }

            public boolean deprecated() {
                return Builder.this.deprecated;
            }

            public SecurityRequirement[] security() {
                return Builder.this.security;
            }

            public Server[] servers() {
                return Builder.this.servers;
            }

            public Extension[] extensions() {
                return Builder.this.extensions;
            }

            public boolean hidden() {
                return Builder.this.hidden;
            }

            public boolean ignoreJsonView() {
                return Builder.this.ignoreJsonView;
            }
        };
        if (StringUtils.isEmpty((CharSequence)operation.operationId()) && this.beanClass == null && this.beanMethod == null && this.parameterTypes == null) {
            throw new IllegalStateException("You should either fill, the Operation or at least the bean class and the bean method");
        }
        if (this.beanClass != null && this.beanMethod == null) {
            throw new IllegalStateException("The bean method, should not null");
        }
        if (StringUtils.isEmpty((CharSequence)operation.operationId()) && this.beanClass == null && this.beanMethod == null) {
            throw new IllegalStateException("operationId can not be empty");
        }
        RouterOperation routerOperation = new RouterOperation();
        routerOperation.setBeanClass(this.beanClass);
        routerOperation.setBeanMethod(this.beanMethod);
        routerOperation.setParameterTypes(this.parameterTypes);
        routerOperation.setOperation(operation);
        return routerOperation;
    }
}

