/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Duration;
import com.vesoft.nebula.client.graph.data.BaseDataObject;
import java.util.Objects;

public class DurationWrapper
extends BaseDataObject {
    private final Duration duration;

    public DurationWrapper(Duration duration) {
        this.duration = duration;
    }

    public long getSeconds() {
        return this.duration.seconds;
    }

    public int getMicroseconds() {
        return this.duration.microseconds;
    }

    public int getMonths() {
        return this.duration.months;
    }

    public String getDurationString() {
        return String.format("duration({months:%d, seconds:%d, microseconds:%d})", this.getMonths(), this.getSeconds(), this.getMicroseconds());
    }

    public String toString() {
        long totalSeconds = this.duration.seconds + (long)(this.duration.microseconds / 1000000);
        int remainMicroSeconds = this.duration.microseconds % 1000000;
        String microSends = String.format("%06d", remainMicroSeconds) + "000";
        return String.format("P%dMT%d.%sS", this.duration.months, totalSeconds, microSends);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationWrapper that = (DurationWrapper)o;
        return this.duration.months == that.getMonths() && this.duration.seconds == that.getSeconds() && this.duration.microseconds == that.getMicroseconds();
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }
}

