/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.OrderDirection;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OrderBy
implements TBase,
Serializable,
Cloneable,
Comparable<OrderBy> {
    private static final TStruct STRUCT_DESC = new TStruct("OrderBy");
    private static final TField PROP_FIELD_DESC = new TField("prop", 11, 1);
    private static final TField DIRECTION_FIELD_DESC = new TField("direction", 8, 2);
    public byte[] prop;
    public OrderDirection direction;
    public static final int PROP = 1;
    public static final int DIRECTION = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public OrderBy() {
    }

    public OrderBy(byte[] prop, OrderDirection direction) {
        this();
        this.prop = prop;
        this.direction = direction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public OrderBy(OrderBy other) {
        if (other.isSetProp()) {
            this.prop = TBaseHelper.deepCopy(other.prop);
        }
        if (other.isSetDirection()) {
            this.direction = TBaseHelper.deepCopy(other.direction);
        }
    }

    @Override
    public OrderBy deepCopy() {
        return new OrderBy(this);
    }

    public byte[] getProp() {
        return this.prop;
    }

    public OrderBy setProp(byte[] prop) {
        this.prop = prop;
        return this;
    }

    public void unsetProp() {
        this.prop = null;
    }

    public boolean isSetProp() {
        return this.prop != null;
    }

    public void setPropIsSet(boolean __value) {
        if (!__value) {
            this.prop = null;
        }
    }

    public OrderDirection getDirection() {
        return this.direction;
    }

    public OrderBy setDirection(OrderDirection direction) {
        this.direction = direction;
        return this;
    }

    public void unsetDirection() {
        this.direction = null;
    }

    public boolean isSetDirection() {
        return this.direction != null;
    }

    public void setDirectionIsSet(boolean __value) {
        if (!__value) {
            this.direction = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetProp();
                    break;
                }
                this.setProp((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetDirection();
                    break;
                }
                this.setDirection((OrderDirection)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getProp();
            }
            case 2: {
                return this.getDirection();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof OrderBy)) {
            return false;
        }
        OrderBy that = (OrderBy)_that;
        if (!TBaseHelper.equalsSlow(this.isSetProp(), that.isSetProp(), this.prop, that.prop)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetDirection(), that.isSetDirection(), this.direction, that.direction);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.prop, this.direction});
    }

    @Override
    public int compareTo(OrderBy other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetProp()).compareTo(other.isSetProp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.prop, other.prop);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDirection()).compareTo(other.isSetDirection());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.direction, other.direction);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.prop = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 8) {
                        this.direction = OrderDirection.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.prop != null) {
            oprot.writeFieldBegin(PROP_FIELD_DESC);
            oprot.writeBinary(this.prop);
            oprot.writeFieldEnd();
        }
        if (this.direction != null) {
            oprot.writeFieldBegin(DIRECTION_FIELD_DESC);
            oprot.writeI32(this.direction == null ? 0 : this.direction.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("OrderBy");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("prop");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getProp() == null) {
            sb.append("null");
        } else {
            int __prop_size = Math.min(this.getProp().length, 128);
            for (int i = 0; i < __prop_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getProp()[i]).length() > 1 ? Integer.toHexString(this.getProp()[i]).substring(Integer.toHexString(this.getProp()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getProp()[i]).toUpperCase());
            }
            if (this.getProp().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("direction");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getDirection() == null) {
            sb.append("null");
        } else {
            String direction_name;
            String string = direction_name = this.getDirection() == null ? "null" : this.getDirection().name();
            if (direction_name != null) {
                sb.append(direction_name);
                sb.append(" (");
            }
            sb.append(this.getDirection());
            if (direction_name != null) {
                sb.append(")");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("prop", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("direction", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(OrderBy.class, metaDataMap);
    }

    public static class Builder {
        private byte[] prop;
        private OrderDirection direction;

        public Builder setProp(byte[] prop) {
            this.prop = prop;
            return this;
        }

        public Builder setDirection(OrderDirection direction) {
            this.direction = direction;
            return this;
        }

        public OrderBy build() {
            OrderBy result = new OrderBy();
            result.setProp(this.prop);
            result.setDirection(this.direction);
            return result;
        }
    }
}

