/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.mapper;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseRecordMapper;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.mapper.WrappedMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractRecordMapper
implements ClickHouseRecordMapper,
WrappedMapper {
    protected final Class<?> clazz;

    static final Constructor<?> getDefaultConstructor(Class<?> objClass) {
        Constructor<?> c = null;
        try {
            c = objClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return c;
    }

    static final Method[] getSetterMethods(Class<?> objClass) {
        List<Method> list;
        try {
            Method[] methods = objClass.getMethods();
            int size = methods.length;
            list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                Method m = methods[i];
                if (Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 1 || !m.getName().startsWith("set")) continue;
                list.add(m);
            }
        }
        catch (SecurityException e) {
            list = Collections.emptyList();
        }
        return list.toArray(new Method[0]);
    }

    static final PropertyInfo[] getProperties(Class<?> objClass, List<ClickHouseColumn> columns) {
        Method[] setters = AbstractRecordMapper.getSetterMethods(objClass);
        int len = setters.length;
        int size = columns.size();
        ArrayList<PropertyInfo> list = new ArrayList<PropertyInfo>(Math.min(size, setters.length));
        block0: for (int i = 0; i < size; ++i) {
            String name;
            ClickHouseColumn c = columns.get(i);
            if (c == null || ClickHouseChecker.isNullOrEmpty(name = c.getColumnName())) continue;
            String setter = "set".concat(name);
            String alias = ClickHouseUtils.remove(setter, '_', '-', ' ', '\t', '\r', '\n', '\'', '\"', '`');
            for (int j = 0; j < len; ++j) {
                Method m = setters[j];
                String n = m.getName();
                if (!setter.equalsIgnoreCase(n) && (alias.equals(setter) || !alias.equalsIgnoreCase(n))) continue;
                list.add(new PropertyInfo(i, c, m));
                continue block0;
            }
        }
        return list.toArray(new PropertyInfo[0]);
    }

    static final Object newInstance(Constructor<?> constructor, Object ... args) {
        if (constructor == null) {
            throw new IllegalArgumentException("No constructor available to create instance");
        }
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Failed to instantiate [%s] with args [%s]", constructor.getDeclaringClass().getName(), args, e));
        }
    }

    protected AbstractRecordMapper(Class<?> objClass) {
        this.clazz = objClass;
    }

    protected void check(ClickHouseRecord r, Class<?> objClass) {
        if (r == null) {
            throw new IllegalArgumentException("Non-null record is required");
        }
    }

    @Override
    public ClickHouseRecordMapper get(ClickHouseDataConfig config, List<ClickHouseColumn> columns) {
        return this;
    }

    static final class PropertyInfo {
        final int index;
        final ClickHouseColumn column;
        final Method setter;

        PropertyInfo(int index, ClickHouseColumn column, Method setter) {
            this.index = index;
            this.column = column;
            this.setter = setter;
        }
    }
}

