/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.reactor.v3_1;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategy;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndSupport;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.reactor.v3_1.ContextPropagationOperator;
import io.opentelemetry.instrumentation.reactor.v3_1.ReactorAsyncOperationEndStrategyBuilder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactorAsyncOperationEndStrategy
implements AsyncOperationEndStrategy {
    static final AttributeKey<Boolean> CANCELED_ATTRIBUTE_KEY = AttributeKey.booleanKey((String)"reactor.canceled");
    private final boolean captureExperimentalSpanAttributes;

    public static ReactorAsyncOperationEndStrategy create() {
        return ReactorAsyncOperationEndStrategy.builder().build();
    }

    public static ReactorAsyncOperationEndStrategyBuilder builder() {
        return new ReactorAsyncOperationEndStrategyBuilder();
    }

    ReactorAsyncOperationEndStrategy(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    public boolean supports(Class<?> returnType) {
        return returnType == Publisher.class || returnType == Mono.class || returnType == Flux.class;
    }

    public <REQUEST, RESPONSE> Object end(final Instrumenter<REQUEST, RESPONSE> instrumenter, final Context context, final REQUEST request, Object asyncValue, final Class<RESPONSE> responseType) {
        EndOnFirstNotificationConsumer notificationConsumer = new EndOnFirstNotificationConsumer(context){

            @Override
            protected void end(Object result, Throwable error) {
                instrumenter.end(context, request, AsyncOperationEndSupport.tryToGetResponse((Class)responseType, (Object)result), error);
            }
        };
        if (asyncValue instanceof Mono) {
            Mono mono = (Mono)asyncValue;
            return ContextPropagationOperator.runWithContext(mono, context).doOnError((Consumer)notificationConsumer).doOnSuccess(notificationConsumer::onSuccess).doOnCancel(notificationConsumer::onCancel);
        }
        Flux flux = Flux.from((Publisher)((Publisher)asyncValue));
        return ContextPropagationOperator.runWithContext(flux, context).doOnError((Consumer)notificationConsumer).doOnComplete((Runnable)notificationConsumer).doOnCancel(notificationConsumer::onCancel);
    }

    private abstract class EndOnFirstNotificationConsumer
    extends AtomicBoolean
    implements Runnable,
    Consumer<Throwable> {
        private static final long serialVersionUID = 1L;
        private final Context context;

        protected EndOnFirstNotificationConsumer(Context context) {
            super(false);
            this.context = context;
        }

        public <T> void onSuccess(T result) {
            this.accept(result, null);
        }

        public void onCancel() {
            if (this.compareAndSet(false, true)) {
                if (ReactorAsyncOperationEndStrategy.this.captureExperimentalSpanAttributes) {
                    Span.fromContext((Context)this.context).setAttribute(CANCELED_ATTRIBUTE_KEY, (Object)true);
                }
                this.end(null, null);
            }
        }

        @Override
        public void run() {
            this.accept(null, null);
        }

        @Override
        public void accept(Throwable exception) {
            this.end(null, exception);
        }

        private void accept(Object result, Throwable error) {
            if (this.compareAndSet(false, true)) {
                this.end(result, error);
            }
        }

        protected abstract void end(Object var1, Throwable var2);
    }
}

