/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.cluster.RoundRobin;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.ClientResources;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

class RoundRobinSocketAddressSupplier
implements Supplier<SocketAddress> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RoundRobinSocketAddressSupplier.class);
    private final Supplier<Partitions> partitions;
    private final Function<Collection<RedisClusterNode>, Collection<RedisClusterNode>> sortFunction;
    private final ClientResources clientResources;
    private final RoundRobin<RedisClusterNode> roundRobin;

    public RoundRobinSocketAddressSupplier(Supplier<Partitions> partitions, Function<? extends Collection<RedisClusterNode>, Collection<RedisClusterNode>> sortFunction, ClientResources clientResources) {
        LettuceAssert.notNull(partitions, "Partitions must not be null");
        LettuceAssert.notNull(sortFunction, "Sort-Function must not be null");
        this.partitions = partitions;
        this.roundRobin = new RoundRobin<RedisClusterNode>((l, r) -> l.getUri() == r.getUri() || l.getUri() != null && l.getUri().equals(r.getUri()));
        this.sortFunction = sortFunction;
        this.clientResources = clientResources;
        this.resetRoundRobin(partitions.get());
    }

    @Override
    public SocketAddress get() {
        Partitions partitions = this.partitions.get();
        if (!this.roundRobin.isConsistent(partitions)) {
            this.resetRoundRobin(partitions);
        }
        RedisClusterNode redisClusterNode = this.roundRobin.next();
        return this.getSocketAddress(redisClusterNode);
    }

    protected void resetRoundRobin(Partitions partitions) {
        this.roundRobin.rebuild(this.sortFunction.apply(partitions));
    }

    protected SocketAddress getSocketAddress(RedisClusterNode redisClusterNode) {
        SocketAddress resolvedAddress = this.clientResources.socketAddressResolver().resolve(redisClusterNode.getUri());
        logger.debug("Resolved SocketAddress {} using for Cluster node {}", (Object)resolvedAddress, (Object)redisClusterNode.getNodeId());
        return resolvedAddress;
    }
}

