/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common;

import io.greptime.common.util.Strings;
import java.io.Serializable;

public class Endpoint
implements Serializable {
    private static final long serialVersionUID = -7329681263115546100L;
    private final String addr;
    private final int port;

    public static Endpoint of(String addr, int port) {
        return new Endpoint(addr, port);
    }

    public static Endpoint parse(String s) {
        if (Strings.isNullOrEmpty(s)) {
            return null;
        }
        String[] arr = Strings.split(s, ':');
        if (arr == null || arr.length < 2) {
            return null;
        }
        try {
            int port = Integer.parseInt(arr[1]);
            return Endpoint.of(arr[0], port);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public Endpoint(String addr, int port) {
        this.addr = addr;
        this.port = port;
    }

    public String getAddr() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.addr + ":" + this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.addr == null ? 0 : this.addr.hashCode());
        result = prime * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (this.addr == null ? other.addr != null : !this.addr.equals(other.addr)) {
            return false;
        }
        return this.port == other.port;
    }
}

