/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.keyboard;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sshd.common.util.buffer.Buffer;

public class PromptEntry
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8206049800536373640L;
    private String prompt;
    private boolean echo;

    public PromptEntry() {
    }

    public PromptEntry(String prompt, boolean echo) {
        this.prompt = prompt;
        this.echo = echo;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public <B extends Buffer> B append(B buffer) {
        buffer.putString(this.getPrompt());
        buffer.putBoolean(this.isEcho());
        return buffer;
    }

    public int hashCode() {
        return Objects.hashCode(this.getPrompt()) + (this.isEcho() ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PromptEntry other = (PromptEntry)obj;
        return Objects.equals(this.getPrompt(), other.getPrompt()) && this.isEcho() == other.isEcho();
    }

    public PromptEntry clone() {
        try {
            return (PromptEntry)this.getClass().cast(super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Failed to clone " + this.toString() + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        return this.getPrompt() + "(echo=" + this.isEcho() + ")";
    }
}

