/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.TApplicationException;
import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.protocol.TMessage;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.transport.TFramedTransport;
import com.facebook.thrift.transport.THeaderException;
import com.facebook.thrift.transport.TMemoryInputTransport;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.facebook.thrift.utils.StandardCharsets;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class THeaderTransport
extends TFramedTransport {
    public static final int HEADER_MAGIC_MASK = -65536;
    public static final int HEADER_FLAGS_MASK = 65535;
    public static final int HEADER_MAGIC = 0xFFF0000;
    public static final int HTTP_SERVER_MAGIC = 1347375956;
    public static final int MAX_FRAME_SIZE = 0x3FFFFFFF;
    private int zlibBufferSize = 512;
    public static final int T_BINARY_PROTOCOL = 0;
    public static final int T_JSON_PROTOCOL = 1;
    public static final int T_COMPACT_PROTOCOL = 2;
    private static final int numClientTypes = 4;
    private int protoId = 2;
    private ClientTypes clientType = ClientTypes.HEADERS;
    private int seqId = 0;
    private int flags = 0;
    private final boolean[] supportedClients;
    private final List<Transforms> writeTransforms;
    private List<Integer> readTransforms;
    private final HashMap<String, String> readHeaders;
    private final HashMap<String, String> readPersistentHeaders;
    private final HashMap<String, String> writeHeaders;
    private final HashMap<String, String> writePersistentHeaders;
    private static final String IDENTITY_HEADER = "identity";
    private static final String ID_VERSION_HEADER = "id_version";
    private static final String ID_VERSION = "1";
    private String identity;
    private final byte[] i32buf = new byte[4];
    private final byte[] i16buf = new byte[2];

    public THeaderTransport(TTransport transport) {
        super(transport);
        this.writeTransforms = new ArrayList<Transforms>();
        this.supportedClients = new boolean[4];
        this.supportedClients[ClientTypes.HEADERS.getValue()] = true;
        this.writeHeaders = new HashMap();
        this.writePersistentHeaders = new HashMap();
        this.readHeaders = new HashMap();
        this.readPersistentHeaders = new HashMap();
    }

    public THeaderTransport(TTransport transport, List<ClientTypes> clientTypes) {
        this(transport);
        if (clientTypes != null) {
            for (ClientTypes t : clientTypes) {
                this.supportedClients[t.getValue()] = true;
            }
        }
    }

    public TTransport getUnderlyingTransport() {
        return this.transport_;
    }

    public int getProtocolId() {
        if (this.clientType == ClientTypes.HEADERS) {
            return this.protoId;
        }
        return 0;
    }

    public void setProtocolId(int protoId) {
        this.protoId = protoId;
    }

    public ClientTypes getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientTypes clientType) {
        this.clientType = clientType;
    }

    public void setZlibBufferSize(int sz) {
        this.zlibBufferSize = sz;
    }

    public void addTransform(Transforms transform) {
        this.writeTransforms.add(transform);
    }

    public void setHeader(String key, String value) {
        this.writeHeaders.put(key, value);
    }

    public HashMap<String, String> getWriteHeaders() {
        return this.writeHeaders;
    }

    public void setPersistentHeader(String key, String value) {
        this.writePersistentHeaders.put(key, value);
    }

    public HashMap<String, String> getWritePersistentHeaders() {
        return this.writePersistentHeaders;
    }

    public HashMap<String, String> getReadPersistentHeaders() {
        return this.readPersistentHeaders;
    }

    public HashMap<String, String> getHeaders() {
        return this.readHeaders;
    }

    public void clearHeaders() {
        this.writeHeaders.clear();
    }

    public void clearPersistentHeaders() {
        this.writePersistentHeaders.clear();
    }

    public String getPeerIdentity() {
        if (this.readHeaders.containsKey(IDENTITY_HEADER) && ID_VERSION.equals(this.readHeaders.get(ID_VERSION_HEADER))) {
            return this.readHeaders.get(IDENTITY_HEADER);
        }
        return null;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int got;
        if (this.readBuffer_ != null && (got = this.readBuffer_.read(buf, off, len)) > 0) {
            return got;
        }
        this.readFrame(len);
        return this.readBuffer_.read(buf, off, len);
    }

    public void _resetProtocol() throws TTransportException {
        this.clientType = ClientTypes.HEADERS;
        this.readFrame(0);
    }

    @Override
    protected void readFrame() throws TTransportException {
        throw new TTransportException("You must use readFrame(int reqLen)");
    }

    protected void readFrame(int reqLen) throws TTransportException {
        this.transport_.readAll(this.i32buf, 0, 4);
        int word1 = THeaderTransport.decodeWord(this.i32buf);
        if ((word1 & 0xFFFF0000) == -2147418112) {
            throw new THeaderException("This transport does not support Unframed");
        }
        if (word1 == 1347375956) {
            throw new THeaderException("This transport does not support HTTP");
        }
        if (word1 - 4 > 0x3FFFFFFF) {
            int magic1 = 1634738248;
            int magic2 = 1819045731;
            if (word1 == magic1 || word1 == magic2) {
                throw new TTransportException("The Thrift server received an ASCII request and safely ignored it. In all likelihood, this isn't the reason of your problem (probably a local daemon sending HTTP content to all listening ports).");
            }
            throw new TTransportException("Framed transport frame is too large");
        }
        this.transport_.readAll(this.i32buf, 0, 4);
        int version = THeaderTransport.decodeWord(this.i32buf);
        if ((version & 0xFFFF0000) == -2147418112) {
            this.clientType = ClientTypes.FRAMED_DEPRECATED;
            byte[] buff = new byte[word1];
            System.arraycopy(this.i32buf, 0, buff, 0, 4);
            this.transport_.readAll(buff, 4, word1 - 4);
            this.readBuffer_.reset(buff);
        } else if ((version & 0xFFFF0000) == 0xFFF0000) {
            this.clientType = ClientTypes.HEADERS;
            if (word1 - 4 < 10) {
                throw new TTransportException("Header transport frame is too small");
            }
            byte[] buff = new byte[word1];
            System.arraycopy(this.i32buf, 0, buff, 0, 4);
            this.transport_.readAll(buff, 4, word1 - 4);
            this.flags = version & 0xFFFF;
            this.seqId = THeaderTransport.decodeWord(buff, 4);
            short headerSize = THeaderTransport.decodeShort(buff, 8);
            this.readHeaderFormat(headerSize, buff);
        } else {
            this.clientType = ClientTypes.UNKNOWN;
            throw new THeaderException("Unsupported client type");
        }
    }

    private int readVarint32Buf(ByteBuffer frame) {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = frame.get();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 128) break;
            shift += 7;
        }
        return result;
    }

    private void writeVarint(ByteBuffer out, int n) {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) break;
            out.put((byte)(n | 0x80));
            n >>>= 7;
        }
        out.put((byte)n);
    }

    private void writeString(ByteBuffer out, String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        this.writeVarint(out, bytes.length);
        out.put(ByteBuffer.wrap(bytes));
    }

    private String readString(ByteBuffer in) throws TTransportException {
        int sz = this.readVarint32Buf(in);
        byte[] bytearr = new byte[sz];
        in.get(bytearr, 0, sz);
        return new String(bytearr, 0, sz, StandardCharsets.UTF_8);
    }

    private void readHeaderFormat(int headerSize, byte[] buff) throws TTransportException {
        ByteBuffer frame = ByteBuffer.wrap(buff);
        frame.position(10);
        int endHeader = (headerSize *= 4) + frame.position();
        if (headerSize > frame.remaining()) {
            throw new TTransportException("Header size is larger than frame");
        }
        this.protoId = this.readVarint32Buf(frame);
        int numTransforms = this.readVarint32Buf(frame);
        this.readTransforms = new ArrayList<Integer>(numTransforms);
        if (this.protoId == 1 && this.clientType != ClientTypes.HTTP) {
            throw new TTransportException("Trying to recv JSON encoding over binary");
        }
        int hmacSz = 0;
        for (int i = 0; i < numTransforms; ++i) {
            int transId = this.readVarint32Buf(frame);
            if (transId != Transforms.ZLIB_TRANSFORM.getValue()) {
                if (transId == Transforms.SNAPPY_TRANSFORM.getValue()) {
                    throw new THeaderException("Snappy transform no longer supported");
                }
                if (transId == Transforms.HMAC_TRANSFORM.getValue()) {
                    throw new THeaderException("Hmac transform no longer supported");
                }
                throw new THeaderException("Unknown transform during recv");
            }
            this.readTransforms.add(transId);
        }
        this.readHeaders.clear();
        while (frame.position() < endHeader) {
            String value;
            String key;
            int i;
            int numKeys;
            int infoId = this.readVarint32Buf(frame);
            if (infoId == Infos.INFO_KEYVALUE.getValue()) {
                numKeys = this.readVarint32Buf(frame);
                for (i = 0; i < numKeys; ++i) {
                    key = this.readString(frame);
                    value = this.readString(frame);
                    this.readHeaders.put(key, value);
                }
                continue;
            }
            if (infoId != Infos.INFO_PKEYVALUE.getValue()) break;
            numKeys = this.readVarint32Buf(frame);
            for (i = 0; i < numKeys; ++i) {
                key = this.readString(frame);
                value = this.readString(frame);
                this.readPersistentHeaders.put(key, value);
            }
        }
        this.readHeaders.putAll(this.readPersistentHeaders);
        frame.position(endHeader);
        frame.limit(frame.limit() - hmacSz);
        frame = this.untransform(frame);
        this.readBuffer_.reset(frame.array(), frame.position(), frame.remaining());
    }

    private ByteBuffer untransform(ByteBuffer data) throws TTransportException {
        if (this.readTransforms.contains(Transforms.ZLIB_TRANSFORM.getValue())) {
            try {
                Object output;
                Inflater decompressor = new Inflater();
                decompressor.setInput(((ByteBuffer)data).array(), ((Buffer)data).position(), ((Buffer)data).remaining());
                int length = 0;
                ArrayList<Object> outBytes = new ArrayList<Object>();
                while (!decompressor.finished()) {
                    output = new byte[this.zlibBufferSize];
                    length += decompressor.inflate((byte[])output);
                    outBytes.add(output);
                }
                decompressor.end();
                if (outBytes.size() == 1) {
                    data = ByteBuffer.wrap((byte[])outBytes.get(0));
                } else {
                    output = ByteBuffer.allocate(length);
                    for (byte[] byArray : outBytes) {
                        ((ByteBuffer)output).put(byArray, 0, Math.min(this.zlibBufferSize, length));
                        length -= byArray.length;
                    }
                    data = output;
                    ((ByteBuffer)data).position(0);
                }
            }
            catch (DataFormatException dfe) {
                throw new THeaderException("Could not inflate data");
            }
            if (!this.writeTransforms.contains((Object)Transforms.ZLIB_TRANSFORM)) {
                this.writeTransforms.add(Transforms.ZLIB_TRANSFORM);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer transform(ByteBuffer data) throws TTransportException {
        if (this.writeTransforms.contains((Object)Transforms.ZLIB_TRANSFORM)) {
            byte[] output = new byte[data.limit() + 512];
            Deflater compressor = new Deflater();
            try {
                compressor.setInput(data.array(), data.position(), data.remaining());
                compressor.finish();
                int length = compressor.deflate(output);
                if (!compressor.finished()) {
                    throw new TTransportException("Output compress buffer not big enough");
                }
                data = ByteBuffer.wrap(output);
                data.limit(length);
            }
            finally {
                compressor.end();
            }
        }
        return data;
    }

    private int getWriteHeadersSize(Map<String, String> headers) {
        if (headers.size() == 0) {
            return 0;
        }
        int len = 10;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            len += 10;
            len += header.getKey().length();
            len += header.getValue().length();
        }
        return len;
    }

    private ByteBuffer flushInfoHeaders(Infos info, Map<String, String> headers) {
        ByteBuffer infoData = ByteBuffer.allocate(this.getWriteHeadersSize(headers));
        if (!headers.isEmpty()) {
            this.writeVarint(infoData, info.getValue());
            this.writeVarint(infoData, headers.size());
            for (Map.Entry<String, String> pairs : headers.entrySet()) {
                this.writeString(infoData, pairs.getKey());
                this.writeString(infoData, pairs.getValue());
            }
            headers.clear();
        }
        infoData.limit(infoData.position());
        infoData.position(0);
        return infoData;
    }

    @Override
    public void flush() throws TTransportException {
        this.flushImpl(false);
    }

    @Override
    public void onewayFlush() throws TTransportException {
        this.flushImpl(true);
    }

    public void flushImpl(boolean oneway) throws TTransportException {
        try {
            TMessage msg;
            Object proto;
            Throwable tae = null;
            byte[] buf = this.writeBuffer_.get();
            int len = this.writeBuffer_.len();
            if (len >= 2 && buf[0] == -126 && (buf[1] >> 5 & 3) == 3) {
                proto = new TCompactProtocol(new TMemoryInputTransport(buf));
                msg = ((TCompactProtocol)proto).readMessageBegin();
                tae = TApplicationException.read((TProtocol)proto);
            } else if (len >= 4 && (buf[0] << 24 | buf[1] << 16) == -2147418112 && buf[3] == 3) {
                proto = new TBinaryProtocol(new TMemoryInputTransport(buf));
                msg = ((TBinaryProtocol)proto).readMessageBegin();
                tae = TApplicationException.read((TProtocol)proto);
            }
            if (tae != null) {
                if (!this.writeHeaders.containsKey("uex")) {
                    this.writeHeaders.put("uex", "TApplicationException");
                }
                if (!this.writeHeaders.containsKey("uexw")) {
                    this.writeHeaders.put("uexw", tae.getMessage() == null ? "[null]" : tae.getMessage());
                }
            }
        }
        catch (TException tae) {
            // empty catch block
        }
        ByteBuffer frame = ByteBuffer.wrap(this.writeBuffer_.get());
        frame.limit(this.writeBuffer_.len());
        this.writeBuffer_.reset();
        if (this.clientType == ClientTypes.HEADERS) {
            frame = this.transform(frame);
        }
        if (frame.remaining() > 0x3FFFFFFF) {
            throw new TTransportException("Attempting to send frame that is too large: " + Integer.toString(frame.remaining()));
        }
        if (this.protoId == 1 && this.clientType != ClientTypes.HTTP) {
            throw new TTransportException("Trying to send JSON encoding over binary");
        }
        if (this.clientType == ClientTypes.HEADERS) {
            ByteBuffer transformData = ByteBuffer.allocate(this.writeTransforms.size() * 5);
            int numTransforms = this.writeTransforms.size();
            for (Transforms trans : this.writeTransforms) {
                this.writeVarint(transformData, trans.getValue());
            }
            transformData.limit(transformData.position());
            transformData.position(0);
            if (this.identity != null && this.identity.length() > 0) {
                this.writeHeaders.put(ID_VERSION_HEADER, ID_VERSION);
                this.writeHeaders.put(IDENTITY_HEADER, this.identity);
            }
            ByteBuffer infoData1 = this.flushInfoHeaders(Infos.INFO_PKEYVALUE, this.writePersistentHeaders);
            ByteBuffer infoData2 = this.flushInfoHeaders(Infos.INFO_KEYVALUE, this.writeHeaders);
            ByteBuffer headerData = ByteBuffer.allocate(10);
            this.writeVarint(headerData, this.protoId);
            this.writeVarint(headerData, numTransforms);
            headerData.limit(headerData.position());
            headerData.position(0);
            int headerSize = transformData.remaining() + infoData1.remaining() + infoData2.remaining() + headerData.remaining();
            int paddingSize = 4 - headerSize % 4;
            ByteBuffer out = ByteBuffer.allocate((headerSize += paddingSize) + 14);
            this.encodeInt(out, 10 + headerSize + frame.remaining());
            this.encodeShort(out, 4095);
            this.encodeShort(out, this.flags);
            this.encodeInt(out, this.seqId);
            this.encodeShort(out, headerSize / 4);
            out.put(headerData);
            out.put(transformData);
            out.put(infoData1);
            out.put(infoData2);
            for (int i = 0; i < paddingSize; ++i) {
                out.put((byte)0);
            }
            out.position(0);
            this.transport_.write(out.array(), out.position(), out.remaining());
            this.transport_.write(frame.array(), frame.position(), frame.remaining());
        } else if (this.clientType == ClientTypes.FRAMED_DEPRECATED) {
            ByteBuffer out = ByteBuffer.allocate(4);
            this.encodeInt(out, frame.remaining());
            out.position(0);
            this.transport_.write(out.array(), out.position(), out.remaining());
            this.transport_.write(frame.array(), frame.position(), frame.remaining());
        } else {
            if (this.clientType == ClientTypes.HTTP) {
                throw new TTransportException("HTTP is unimplemented in this language");
            }
            throw new TTransportException("Unknown client type on send");
        }
        if (oneway) {
            this.transport_.onewayFlush();
        } else {
            this.transport_.flush();
        }
    }

    private void encodeInt(ByteBuffer out, int val) {
        THeaderTransport.encodeWord(val, this.i32buf);
        out.put(this.i32buf, 0, 4);
    }

    private void encodeShort(ByteBuffer out, int val) {
        THeaderTransport.encodeShort(val, this.i16buf);
        out.put(this.i16buf, 0, 2);
    }

    public static class Factory
    extends TFramedTransport.Factory {
        List<ClientTypes> clientTypes;

        public Factory(List<ClientTypes> clientTypes) {
            this.clientTypes = clientTypes;
        }

        @Override
        public TTransport getTransport(TTransport base) {
            return new THeaderTransport(base, this.clientTypes);
        }
    }

    public static enum ClientTypes {
        HEADERS(0),
        FRAMED_DEPRECATED(1),
        HTTP(3),
        UNKNOWN(4);

        private int value;

        private ClientTypes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Infos {
        INFO_KEYVALUE(1),
        INFO_PKEYVALUE(2);

        private int value;

        private Infos(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Transforms {
        ZLIB_TRANSFORM(1),
        HMAC_TRANSFORM(2),
        SNAPPY_TRANSFORM(3);

        private int value;

        private Transforms(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

