/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.tsdb.greptime;

import io.greptime.GreptimeDB;
import io.greptime.models.AuthInfo;
import io.greptime.models.DataType;
import io.greptime.models.Result;
import io.greptime.models.Table;
import io.greptime.models.TableSchema;
import io.greptime.options.GreptimeOptions;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.TimePeriodUtil;
import org.apache.hertzbeat.warehouse.db.GreptimeSqlQueryExecutor;
import org.apache.hertzbeat.warehouse.store.history.tsdb.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.tsdb.greptime.GreptimeProperties;
import org.apache.hertzbeat.warehouse.store.history.tsdb.vm.PromQlQueryContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConditionalOnProperty(prefix="warehouse.store.greptime", name={"enabled"}, havingValue="true")
public class GreptimeDbDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(GreptimeDbDataStorage.class);
    private static final String BASIC = "Basic";
    private static final String QUERY_RANGE_PATH = "/v1/prometheus/api/v1/query_range";
    private static final String LABEL_KEY_NAME = "__name__";
    private static final String LABEL_KEY_FIELD = "__field__";
    private static final String LABEL_KEY_INSTANCE = "instance";
    private static final String LOG_TABLE_NAME = "hertzbeat_logs";
    private static final String LABEL_KEY_START_TIME = "start";
    private static final String LABEL_KEY_END_TIME = "end";
    private static final int LOG_BATCH_SIZE = 500;
    private GreptimeDB greptimeDb;
    private final GreptimeProperties greptimeProperties;
    private final RestTemplate restTemplate;
    private final GreptimeSqlQueryExecutor greptimeSqlQueryExecutor;

    public GreptimeDbDataStorage(GreptimeProperties greptimeProperties, RestTemplate restTemplate, GreptimeSqlQueryExecutor greptimeSqlQueryExecutor) {
        if (greptimeProperties == null) {
            log.error("init error, please config Warehouse GreptimeDB props in application.yml");
            throw new IllegalArgumentException("please config Warehouse GreptimeDB props");
        }
        this.restTemplate = restTemplate;
        this.greptimeProperties = greptimeProperties;
        this.greptimeSqlQueryExecutor = greptimeSqlQueryExecutor;
        this.serverAvailable = this.initGreptimeDbClient(greptimeProperties);
    }

    private boolean initGreptimeDbClient(GreptimeProperties greptimeProperties) {
        String endpoints = greptimeProperties.grpcEndpoints();
        try {
            GreptimeOptions opts = GreptimeOptions.newBuilder((String[])endpoints.split(","), (String)greptimeProperties.database()).writeMaxRetries(3).authInfo(new AuthInfo(greptimeProperties.username(), greptimeProperties.password())).routeTableRefreshPeriodSeconds(30L).build();
            this.greptimeDb = GreptimeDB.create((GreptimeOptions)opts);
        }
        catch (Exception e) {
            log.error("[warehouse greptime] Fail to start GreptimeDB client");
            return false;
        }
        return true;
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        if (!this.isServerAvailable() || metricsData.getCode() != CollectRep.Code.SUCCESS) {
            return;
        }
        if (metricsData.getValues().isEmpty()) {
            log.info("[warehouse greptime] flush metrics data {} {}is null, ignore.", (Object)metricsData.getId(), (Object)metricsData.getMetrics());
            return;
        }
        String instance = metricsData.getInstance();
        String app = metricsData.getApp();
        String tableName = this.getTableName(app, metricsData.getMetrics());
        TableSchema.Builder tableSchemaBuilder = TableSchema.newBuilder((String)tableName);
        tableSchemaBuilder.addTag(LABEL_KEY_INSTANCE, DataType.String).addTimestamp("ts", DataType.TimestampMillisecond);
        List fields = metricsData.getFields();
        fields.forEach(field -> {
            if (field.getLabel()) {
                tableSchemaBuilder.addTag(field.getName(), DataType.String);
            } else if (field.getType() == 0) {
                tableSchemaBuilder.addField(field.getName(), DataType.Float64);
            } else if (field.getType() == 1) {
                tableSchemaBuilder.addField(field.getName(), DataType.String);
            }
        });
        Table table = Table.from((TableSchema)tableSchemaBuilder.build());
        long now = System.currentTimeMillis();
        Object[] values = new Object[2 + fields.size()];
        values[0] = instance;
        values[1] = now;
        RowWrapper rowWrapper = metricsData.readRow();
        while (rowWrapper.hasNextRow()) {
            rowWrapper = rowWrapper.nextRow();
            AtomicInteger index = new AtomicInteger(-1);
            rowWrapper.cellStream().forEach(cell -> {
                index.getAndIncrement();
                if ("&nbsp;".equals(cell.getValue())) {
                    values[2 + index.get()] = null;
                    return;
                }
                Boolean label = cell.getMetadataAsBoolean("label");
                Byte type = cell.getMetadataAsByte("type");
                if (label.booleanValue()) {
                    values[2 + index.get()] = cell.getValue();
                } else if (type == 0) {
                    values[2 + index.get()] = Double.parseDouble(cell.getValue());
                } else if (type == 1) {
                    values[2 + index.get()] = cell.getValue();
                }
            });
            table.addRow(values);
        }
        CompletableFuture writeFuture = this.greptimeDb.write(new Table[]{table});
        try {
            Result result = (Result)writeFuture.get(10L, TimeUnit.SECONDS);
            if (result.isOk()) {
                log.debug("[warehouse greptime]-Write successful");
            } else {
                log.warn("[warehouse greptime]--Write failed: {}", result.getErr());
            }
        }
        catch (Throwable throwable) {
            log.error("[warehouse greptime]--Error occurred: {}", (Object)throwable.getMessage());
        }
    }

    @Override
    public Map<String, List<Value>> getHistoryMetricData(String instance, String app, String metrics, String metric, String history) {
        Map<String, Long> timeRange = this.getTimeRange(history);
        Long start = timeRange.get(LABEL_KEY_START_TIME);
        Long end = timeRange.get(LABEL_KEY_END_TIME);
        String step = this.getTimeStep(start, end);
        return this.getHistoryData(start, end, step, instance, app, metrics, metric);
    }

    private String getTableName(String app, String metrics) {
        return app + "_" + metrics;
    }

    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(String instance, String app, String metrics, String metric, String history) {
        Map<String, Long> timeRange = this.getTimeRange(history);
        Long start = timeRange.get(LABEL_KEY_START_TIME);
        Long end = timeRange.get(LABEL_KEY_END_TIME);
        String step = this.getTimeStep(start, end);
        Map<String, List<Value>> instanceValuesMap = this.getHistoryData(start, end, step, instance, app, metrics, metric);
        if (instanceValuesMap.isEmpty()) {
            return Collections.emptyMap();
        }
        List<Value> values = instanceValuesMap.get(instanceValuesMap.keySet().iterator().next());
        long effectiveStart = values.get(0).getTime() / 1000L;
        long effectiveEnd = values.get(values.size() - 1).getTime() / 1000L + Duration.ofHours(4L).getSeconds();
        String name = this.getTableName(app, metrics);
        String timeSeriesSelector = name + "{instance=\"" + instance + "\"";
        if (!"prometheus".equals(app)) {
            timeSeriesSelector = timeSeriesSelector + ",__field__=\"" + metric + "\"";
        }
        timeSeriesSelector = timeSeriesSelector + "}";
        try {
            String finalTimeSeriesSelector = timeSeriesSelector;
            URI uri = this.getUri(effectiveStart, effectiveEnd, step, uriComponents -> "max_over_time(" + finalTimeSeriesSelector + "[" + step + "])");
            this.requestIntervalMetricAndPutValue(uri, instanceValuesMap, Value::setMax);
            uri = this.getUri(effectiveStart, effectiveEnd, step, uriComponents -> "min_over_time(" + finalTimeSeriesSelector + "[" + step + "])");
            this.requestIntervalMetricAndPutValue(uri, instanceValuesMap, Value::setMin);
            uri = this.getUri(effectiveStart, effectiveEnd, step, uriComponents -> "avg_over_time(" + finalTimeSeriesSelector + "[" + step + "])");
            this.requestIntervalMetricAndPutValue(uri, instanceValuesMap, Value::setMean);
        }
        catch (Exception e) {
            log.error("query interval metrics data from greptime error. {}", (Object)e.getMessage(), (Object)e);
        }
        return instanceValuesMap;
    }

    private Map<String, Long> getTimeRange(String history) {
        long start;
        Instant now = Instant.now();
        try {
            if (NumberUtils.isParsable((String)history)) {
                start = NumberUtils.toLong((String)history);
                start = ZonedDateTime.now().toEpochSecond() - start;
            } else {
                TemporalAmount temporalAmount = TimePeriodUtil.parseTokenTime((String)history);
                assert (temporalAmount != null);
                Instant dateTime = now.minus(temporalAmount);
                start = dateTime.getEpochSecond();
            }
        }
        catch (Exception e) {
            log.error("history time error: {}. use default: 6h", (Object)e.getMessage());
            start = now.minus(6L, ChronoUnit.HOURS).getEpochSecond();
        }
        long end = now.getEpochSecond();
        return Map.of(LABEL_KEY_START_TIME, start, LABEL_KEY_END_TIME, end);
    }

    private String getTimeStep(long start, long end) {
        String step = "60s";
        if (end - start < Duration.ofDays(7L).getSeconds() && end - start > Duration.ofDays(1L).getSeconds()) {
            step = "1h";
        } else if (end - start >= Duration.ofDays(7L).getSeconds()) {
            step = "4h";
        }
        return step;
    }

    private Map<String, List<Value>> getHistoryData(long start, long end, String step, String instance, String app, String metrics, String metric) {
        String name = this.getTableName(app, metrics);
        String timeSeriesSelector = "__name__=\"" + name + "\",instance=\"" + instance + "\"";
        if (!"prometheus".equals(app)) {
            timeSeriesSelector = timeSeriesSelector + ",__field__=\"" + metric + "\"";
        }
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(8);
        try {
            HttpEntity<Void> httpEntity = this.getHttpEntity();
            String finalTimeSeriesSelector = timeSeriesSelector;
            URI uri = this.getUri(start, end, step, uriComponents -> {
                MultiValueMap queryParams = uriComponents.getQueryParams();
                if (!queryParams.isEmpty()) {
                    return "{" + finalTimeSeriesSelector + "}";
                }
                return null;
            });
            ResponseEntity responseEntity = null;
            if (uri != null) {
                responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, PromQlQueryContent.class);
            }
            if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
                log.debug("query metrics data from greptime success. {}", (Object)uri);
                if (responseEntity.getBody() != null && ((PromQlQueryContent)responseEntity.getBody()).getData() != null && ((PromQlQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                    List<PromQlQueryContent.ContentData.Content> contents = ((PromQlQueryContent)responseEntity.getBody()).getData().getResult();
                    for (PromQlQueryContent.ContentData.Content content : contents) {
                        Map<String, String> labels = content.getMetric();
                        labels.remove(LABEL_KEY_NAME);
                        labels.remove(LABEL_KEY_INSTANCE);
                        String labelStr = JsonUtil.toJson(labels);
                        if (content.getValues() == null || content.getValues().isEmpty()) continue;
                        List valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList());
                        for (Object[] valueArr : content.getValues()) {
                            long timestamp = ((Double)valueArr[0]).longValue();
                            String value = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                            valueList.add(new Value(value, timestamp * 1000L));
                        }
                    }
                }
            } else {
                log.error("query metrics data from greptime failed. {}", responseEntity);
            }
        }
        catch (Exception e) {
            log.error("query metrics data from greptime error. {}", (Object)e.getMessage(), (Object)e);
        }
        return instanceValuesMap;
    }

    private HttpEntity<Void> getHttpEntity() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        if (StringUtils.hasText((String)this.greptimeProperties.username()) && StringUtils.hasText((String)this.greptimeProperties.password())) {
            String authStr = this.greptimeProperties.username() + ":" + this.greptimeProperties.password();
            String encodedAuth = Base64Util.encode((String)authStr);
            headers.add("Authorization", "Basic " + encodedAuth);
        }
        return new HttpEntity((MultiValueMap)headers);
    }

    private URI getUri(long start, long end, String step, Function<UriComponents, String> queryFunction) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.greptimeProperties.httpEndpoint() + QUERY_RANGE_PATH)).queryParam(LABEL_KEY_START_TIME, new Object[]{start}).queryParam(LABEL_KEY_END_TIME, new Object[]{end}).queryParam("step", new Object[]{step}).queryParam("db", new Object[]{this.greptimeProperties.database()});
        UriComponents cloneUriComponents = uriComponentsBuilder.cloneBuilder().build(true);
        String queryValue = queryFunction.apply(cloneUriComponents);
        if (!StringUtils.hasText((String)queryValue)) {
            return null;
        }
        UriComponents uriComponents = uriComponentsBuilder.queryParam(URLEncoder.encode("query", StandardCharsets.UTF_8), new Object[]{URLEncoder.encode(queryValue, StandardCharsets.UTF_8)}).build(true);
        return uriComponents.toUri();
    }

    private void requestIntervalMetricAndPutValue(URI uri, Map<String, List<Value>> instanceValuesMap, BiConsumer<Value, String> valueConsumer) {
        if (uri == null) {
            return;
        }
        HttpEntity<Void> httpEntity = this.getHttpEntity();
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, PromQlQueryContent.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("query interval metrics data from greptime failed. {}", (Object)responseEntity);
            return;
        }
        log.debug("query interval metrics data from greptime success. {}", (Object)uri);
        PromQlQueryContent body = (PromQlQueryContent)responseEntity.getBody();
        if (body == null || body.getData() == null || body.getData().getResult() == null) {
            return;
        }
        List<PromQlQueryContent.ContentData.Content> contents = body.getData().getResult();
        for (PromQlQueryContent.ContentData.Content content : contents) {
            List valueList;
            Map<String, String> labels = content.getMetric();
            labels.remove(LABEL_KEY_NAME);
            labels.remove(LABEL_KEY_INSTANCE);
            String labelStr = JsonUtil.toJson(labels);
            if (content.getValues() == null || content.getValues().isEmpty() || (valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList())).size() != content.getValues().size()) continue;
            for (int timestampIndex = 0; timestampIndex < valueList.size(); ++timestampIndex) {
                Value value = (Value)valueList.get(timestampIndex);
                Object[] valueArr = content.getValues().get(timestampIndex);
                String avgValue = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                valueConsumer.accept(value, avgValue);
            }
        }
    }

    public void destroy() {
        if (this.greptimeDb != null) {
            this.greptimeDb.shutdownGracefully();
            this.greptimeDb = null;
        }
    }

    @Override
    public void saveLogData(LogEntry logEntry) {
        if (!this.isServerAvailable()) {
            return;
        }
        try {
            TableSchema.Builder tableSchemaBuilder = TableSchema.newBuilder((String)LOG_TABLE_NAME);
            tableSchemaBuilder.addTimestamp("time_unix_nano", DataType.TimestampNanosecond).addField("observed_time_unix_nano", DataType.TimestampNanosecond).addField("severity_number", DataType.Int32).addField("severity_text", DataType.String).addField("body", DataType.Json).addField("trace_id", DataType.String).addField("span_id", DataType.String).addField("trace_flags", DataType.Int32).addField("attributes", DataType.Json).addField("resource", DataType.Json).addField("instrumentation_scope", DataType.Json).addField("dropped_attributes_count", DataType.Int32);
            Table table = Table.from((TableSchema)tableSchemaBuilder.build());
            Object[] values = new Object[]{logEntry.getTimeUnixNano() != null ? logEntry.getTimeUnixNano() : System.nanoTime(), logEntry.getObservedTimeUnixNano() != null ? logEntry.getObservedTimeUnixNano() : System.nanoTime(), logEntry.getSeverityNumber(), logEntry.getSeverityText(), JsonUtil.toJson((Object)logEntry.getBody()), logEntry.getTraceId(), logEntry.getSpanId(), logEntry.getTraceFlags(), JsonUtil.toJson((Object)logEntry.getAttributes()), JsonUtil.toJson((Object)logEntry.getResource()), JsonUtil.toJson((Object)logEntry.getInstrumentationScope()), logEntry.getDroppedAttributesCount()};
            table.addRow(values);
            CompletableFuture writeFuture = this.greptimeDb.write(new Table[]{table});
            Result result = (Result)writeFuture.get(10L, TimeUnit.SECONDS);
            if (result.isOk()) {
                log.debug("[warehouse greptime-log] Write successful");
            } else {
                log.warn("[warehouse greptime-log] Write failed: {}", result.getErr());
            }
        }
        catch (Exception e) {
            log.error("[warehouse greptime-log] Error saving log entry", (Throwable)e);
        }
    }

    @Override
    public List<LogEntry> queryLogsByMultipleConditions(Long startTime, Long endTime, String traceId, String spanId, Integer severityNumber, String severityText, String searchContent) {
        try {
            StringBuilder sql = new StringBuilder("SELECT * FROM ").append(LOG_TABLE_NAME);
            this.buildWhereConditions(sql, startTime, endTime, traceId, spanId, severityNumber, severityText, searchContent);
            sql.append(" ORDER BY time_unix_nano DESC");
            List<Map<String, Object>> rows = this.greptimeSqlQueryExecutor.execute(sql.toString());
            return this.mapRowsToLogEntries(rows);
        }
        catch (Exception e) {
            log.error("[warehouse greptime-log] queryLogsByMultipleConditions error: {}", (Object)e.getMessage(), (Object)e);
            return List.of();
        }
    }

    @Override
    public List<LogEntry> queryLogsByMultipleConditionsWithPagination(Long startTime, Long endTime, String traceId, String spanId, Integer severityNumber, String severityText, String searchContent, Integer offset, Integer limit) {
        try {
            StringBuilder sql = new StringBuilder("SELECT * FROM ").append(LOG_TABLE_NAME);
            this.buildWhereConditions(sql, startTime, endTime, traceId, spanId, severityNumber, severityText, searchContent);
            sql.append(" ORDER BY time_unix_nano DESC");
            if (limit != null && limit > 0) {
                sql.append(" LIMIT ").append(limit);
                if (offset != null && offset > 0) {
                    sql.append(" OFFSET ").append(offset);
                }
            }
            List<Map<String, Object>> rows = this.greptimeSqlQueryExecutor.execute(sql.toString());
            return this.mapRowsToLogEntries(rows);
        }
        catch (Exception e) {
            log.error("[warehouse greptime-log] queryLogsByMultipleConditionsWithPagination error: {}", (Object)e.getMessage(), (Object)e);
            return List.of();
        }
    }

    @Override
    public long countLogsByMultipleConditions(Long startTime, Long endTime, String traceId, String spanId, Integer severityNumber, String severityText, String searchContent) {
        try {
            Object countObj;
            StringBuilder sql = new StringBuilder("SELECT COUNT(*) as count FROM ").append(LOG_TABLE_NAME);
            this.buildWhereConditions(sql, startTime, endTime, traceId, spanId, severityNumber, severityText, searchContent);
            List<Map<String, Object>> rows = this.greptimeSqlQueryExecutor.execute(sql.toString());
            if (rows != null && !rows.isEmpty() && (countObj = rows.get(0).get("count")) instanceof Number) {
                return ((Number)countObj).longValue();
            }
            return 0L;
        }
        catch (Exception e) {
            log.error("[warehouse greptime-log] countLogsByMultipleConditions error: {}", (Object)e.getMessage(), (Object)e);
            return 0L;
        }
    }

    private static long msToNs(Long ms) {
        return ms * 1000000L;
    }

    private static String safeString(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("'", "''");
    }

    private void buildWhereConditions(StringBuilder sql, Long startTime, Long endTime, String traceId, String spanId, Integer severityNumber, String severityText, String searchContent) {
        ArrayList<CallSite> conditions = new ArrayList<CallSite>();
        if (startTime != null && endTime != null) {
            conditions.add((CallSite)((Object)("time_unix_nano >= " + GreptimeDbDataStorage.msToNs(startTime) + " AND time_unix_nano <= " + GreptimeDbDataStorage.msToNs(endTime))));
        }
        if (StringUtils.hasText((String)traceId)) {
            conditions.add((CallSite)((Object)("trace_id = '" + GreptimeDbDataStorage.safeString(traceId) + "'")));
        }
        if (StringUtils.hasText((String)spanId)) {
            conditions.add((CallSite)((Object)("span_id = '" + GreptimeDbDataStorage.safeString(spanId) + "'")));
        }
        if (severityNumber != null) {
            conditions.add((CallSite)((Object)("severity_number = " + severityNumber)));
        }
        if (StringUtils.hasText((String)severityText)) {
            conditions.add((CallSite)((Object)("severity_text = '" + GreptimeDbDataStorage.safeString(severityText) + "'")));
        }
        if (StringUtils.hasText((String)searchContent)) {
            conditions.add((CallSite)((Object)("body LIKE '%" + GreptimeDbDataStorage.safeString(searchContent) + "%'")));
        }
        if (!conditions.isEmpty()) {
            sql.append(" WHERE ").append(String.join((CharSequence)" AND ", conditions));
        }
    }

    private List<LogEntry> mapRowsToLogEntries(List<Map<String, Object>> rows) {
        LinkedList<LogEntry> list = new LinkedList<LogEntry>();
        if (rows == null || rows.isEmpty()) {
            return list;
        }
        for (Map<String, Object> row : rows) {
            try {
                String scopeStr;
                LogEntry.InstrumentationScope scope = null;
                Object scopeObj = row.get("instrumentation_scope");
                if (scopeObj instanceof String && StringUtils.hasText((String)(scopeStr = (String)scopeObj))) {
                    try {
                        scope = (LogEntry.InstrumentationScope)JsonUtil.fromJson((String)scopeStr, LogEntry.InstrumentationScope.class);
                    }
                    catch (Exception ignore) {
                        scope = null;
                    }
                }
                Object bodyObj = GreptimeDbDataStorage.parseJsonMaybe(row.get("body"));
                Map<String, Object> attributes = GreptimeDbDataStorage.castToMap(GreptimeDbDataStorage.parseJsonMaybe(row.get("attributes")));
                Map<String, Object> resource = GreptimeDbDataStorage.castToMap(GreptimeDbDataStorage.parseJsonMaybe(row.get("resource")));
                LogEntry entry = LogEntry.builder().timeUnixNano(GreptimeDbDataStorage.castToLong(row.get("time_unix_nano"))).observedTimeUnixNano(GreptimeDbDataStorage.castToLong(row.get("observed_time_unix_nano"))).severityNumber(GreptimeDbDataStorage.castToInteger(row.get("severity_number"))).severityText(GreptimeDbDataStorage.castToString(row.get("severity_text"))).body(bodyObj).traceId(GreptimeDbDataStorage.castToString(row.get("trace_id"))).spanId(GreptimeDbDataStorage.castToString(row.get("span_id"))).traceFlags(GreptimeDbDataStorage.castToInteger(row.get("trace_flags"))).attributes(attributes).resource(resource).instrumentationScope(scope).droppedAttributesCount(GreptimeDbDataStorage.castToInteger(row.get("dropped_attributes_count"))).build();
                list.add(entry);
            }
            catch (Exception e) {
                log.warn("[warehouse greptime-log] map row to LogEntry error: {}", (Object)e.getMessage());
            }
        }
        return list;
    }

    private static Object parseJsonMaybe(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return value;
        }
        if (value instanceof String) {
            String str = (String)value;
            String s = str.trim();
            if (s.startsWith("{") && s.endsWith("}") || s.startsWith("[") && s.endsWith("]")) {
                try {
                    return JsonUtil.fromJson((String)s, Object.class);
                }
                catch (Exception e) {
                    return s;
                }
            }
            return s;
        }
        return value;
    }

    private static Map<String, Object> castToMap(Object obj) {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    private static Long castToLong(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            Number n = (Number)obj;
            return n.longValue();
        }
        try {
            return Long.parseLong(String.valueOf(obj));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Integer castToInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            Number n = (Number)obj;
            return n.intValue();
        }
        try {
            return Integer.parseInt(String.valueOf(obj));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String castToString(Object obj) {
        return obj == null ? null : String.valueOf(obj);
    }

    @Override
    public boolean batchDeleteLogs(List<Long> timeUnixNanos) {
        if (!this.isServerAvailable() || timeUnixNanos == null || timeUnixNanos.isEmpty()) {
            return false;
        }
        try {
            StringBuilder sql = new StringBuilder("DELETE FROM ").append(LOG_TABLE_NAME).append(" WHERE time_unix_nano IN (");
            sql.append(timeUnixNanos.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(", ")));
            sql.append(")");
            this.greptimeSqlQueryExecutor.execute(sql.toString());
            log.info("[warehouse greptime-log] Batch delete executed successfully for {} logs", (Object)timeUnixNanos.size());
            return true;
        }
        catch (Exception e) {
            log.error("[warehouse greptime-log] batchDeleteLogs error: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    @Override
    public void saveLogDataBatch(List<LogEntry> logEntries) {
        if (!this.isServerAvailable() || logEntries == null || logEntries.isEmpty()) {
            return;
        }
        int total = logEntries.size();
        for (int i = 0; i < total; i += 500) {
            int end = Math.min(i + 500, total);
            List<LogEntry> batch = logEntries.subList(i, end);
            this.doSaveLogBatch(batch);
        }
    }

    private void doSaveLogBatch(List<LogEntry> logEntries) {
        try {
            TableSchema.Builder tableSchemaBuilder = TableSchema.newBuilder((String)LOG_TABLE_NAME);
            tableSchemaBuilder.addTimestamp("time_unix_nano", DataType.TimestampNanosecond).addField("observed_time_unix_nano", DataType.TimestampNanosecond).addField("severity_number", DataType.Int32).addField("severity_text", DataType.String).addField("body", DataType.Json).addField("trace_id", DataType.String).addField("span_id", DataType.String).addField("trace_flags", DataType.Int32).addField("attributes", DataType.Json).addField("resource", DataType.Json).addField("instrumentation_scope", DataType.Json).addField("dropped_attributes_count", DataType.Int32);
            Table table = Table.from((TableSchema)tableSchemaBuilder.build());
            for (LogEntry logEntry : logEntries) {
                Object[] values = new Object[]{logEntry.getTimeUnixNano() != null ? logEntry.getTimeUnixNano() : System.nanoTime(), logEntry.getObservedTimeUnixNano() != null ? logEntry.getObservedTimeUnixNano() : System.nanoTime(), logEntry.getSeverityNumber(), logEntry.getSeverityText(), JsonUtil.toJson((Object)logEntry.getBody()), logEntry.getTraceId(), logEntry.getSpanId(), logEntry.getTraceFlags(), JsonUtil.toJson((Object)logEntry.getAttributes()), JsonUtil.toJson((Object)logEntry.getResource()), JsonUtil.toJson((Object)logEntry.getInstrumentationScope()), logEntry.getDroppedAttributesCount()};
                table.addRow(values);
            }
            CompletableFuture writeFuture = this.greptimeDb.write(new Table[]{table});
            Result result = (Result)writeFuture.get(10L, TimeUnit.SECONDS);
            if (result.isOk()) {
                log.debug("[warehouse greptime-log] Batch write {} logs successful", (Object)logEntries.size());
            } else {
                log.warn("[warehouse greptime-log] Batch write failed: {}", result.getErr());
            }
        }
        catch (Exception e) {
            log.error("[warehouse greptime-log] Error saving log entries batch", (Throwable)e);
        }
    }
}

