/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.hertzbeat.common.entity.alerter.JsonMapAttributeConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert_define")
@Schema(description="Alarm Threshold Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class AlertDefine {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Threshold Id", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Alert Rule Name", example="high_cpu_usage", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    @NotNull
    private @Size(max=100) @NotNull String name;
    @Schema(title="Rule Type: realtime_metric, periodic_metric, realtime_log, periodic_log", example="realtime_metric")
    private String type;
    @Schema(title="Alarm Threshold Expr", example="usage>90", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=2048)
    @Column(length=2048)
    private @Size(max=2048) String expr;
    @Schema(title="Execution Period/ Window Size (seconds) - For periodic rules/ For log realtime", example="300")
    private Integer period;
    @Schema(title="Alarm Trigger Times.The alarm is triggered only after the required number of times is reached", example="3", accessMode=Schema.AccessMode.READ_WRITE)
    private Integer times;
    @Schema(description="labels(status:success,env:prod,priority:critical)", example="{name: key1, value: value1}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=2048)
    private Map<String, String> labels;
    @Schema(title="Annotations", example="summary: High CPU usage")
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=4096)
    private Map<String, String> annotations;
    @Schema(title="Alert Content Template", example="Instance {{ $labels.instance }} CPU usage is {{ $value }}%")
    @Size(max=2048)
    @Column(length=2048)
    private @Size(max=2048) String template;
    @Schema(title="Data Source Type", example="PROMETHEUS")
    @Size(max=100)
    private @Size(max=100) String datasource;
    @Schema(title="Is Enabled", example="true")
    private boolean enable = true;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static AlertDefineBuilder builder() {
        return new AlertDefineBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getExpr() {
        return this.expr;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public Integer getTimes() {
        return this.times;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public void setTimes(Integer times) {
        this.times = times;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertDefine)) {
            return false;
        }
        AlertDefine other = (AlertDefine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$period = this.getPeriod();
        Integer other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Integer this$times = this.getTimes();
        Integer other$times = other.getTimes();
        if (this$times == null ? other$times != null : !((Object)this$times).equals(other$times)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$expr = this.getExpr();
        String other$expr = other.getExpr();
        if (this$expr == null ? other$expr != null : !this$expr.equals(other$expr)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$datasource = this.getDatasource();
        String other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertDefine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Integer $times = this.getTimes();
        result = result * 59 + ($times == null ? 43 : ((Object)$times).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $expr = this.getExpr();
        result = result * 59 + ($expr == null ? 43 : $expr.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : $datasource.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "AlertDefine(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", expr=" + this.getExpr() + ", period=" + this.getPeriod() + ", times=" + this.getTimes() + ", labels=" + this.getLabels() + ", annotations=" + this.getAnnotations() + ", template=" + this.getTemplate() + ", datasource=" + this.getDatasource() + ", enable=" + this.isEnable() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public AlertDefine(Long id, String name, String type, String expr, Integer period, Integer times, Map<String, String> labels, Map<String, String> annotations, String template, String datasource, boolean enable, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.expr = expr;
        this.period = period;
        this.times = times;
        this.labels = labels;
        this.annotations = annotations;
        this.template = template;
        this.datasource = datasource;
        this.enable = enable;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public AlertDefine() {
    }

    public static class AlertDefineBuilder {
        private Long id;
        private String name;
        private String type;
        private String expr;
        private Integer period;
        private Integer times;
        private Map<String, String> labels;
        private Map<String, String> annotations;
        private String template;
        private String datasource;
        private boolean enable;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        AlertDefineBuilder() {
        }

        public AlertDefineBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AlertDefineBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AlertDefineBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AlertDefineBuilder expr(String expr) {
            this.expr = expr;
            return this;
        }

        public AlertDefineBuilder period(Integer period) {
            this.period = period;
            return this;
        }

        public AlertDefineBuilder times(Integer times) {
            this.times = times;
            return this;
        }

        public AlertDefineBuilder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public AlertDefineBuilder annotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public AlertDefineBuilder template(String template) {
            this.template = template;
            return this;
        }

        public AlertDefineBuilder datasource(String datasource) {
            this.datasource = datasource;
            return this;
        }

        public AlertDefineBuilder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public AlertDefineBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AlertDefineBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public AlertDefineBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AlertDefineBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public AlertDefine build() {
            return new AlertDefine(this.id, this.name, this.type, this.expr, this.period, this.times, this.labels, this.annotations, this.template, this.datasource, this.enable, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "AlertDefine.AlertDefineBuilder(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", expr=" + this.expr + ", period=" + this.period + ", times=" + this.times + ", labels=" + this.labels + ", annotations=" + this.annotations + ", template=" + this.template + ", datasource=" + this.datasource + ", enable=" + this.enable + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

