/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.service.impl;

import java.util.ArrayList;
import org.apache.hertzbeat.ai.pojo.dto.ChatRequestContext;
import org.apache.hertzbeat.ai.service.ChatClientProviderService;
import org.apache.hertzbeat.base.dao.GeneralConfigDao;
import org.apache.hertzbeat.common.entity.ai.ChatMessage;
import org.apache.hertzbeat.common.entity.dto.ModelProviderConfig;
import org.apache.hertzbeat.common.entity.manager.GeneralConfig;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.prompt.SystemPromptTemplate;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
public class ChatClientProviderServiceImpl
implements ChatClientProviderService {
    private static final Logger log = LoggerFactory.getLogger(ChatClientProviderServiceImpl.class);
    private final ApplicationContext applicationContext;
    private final GeneralConfigDao generalConfigDao;
    @Autowired
    private ToolCallbackProvider toolCallbackProvider;
    private boolean isConfigured = false;
    @Value(value="classpath:/prompt/system-message.st")
    private Resource systemResource;

    @Autowired
    public ChatClientProviderServiceImpl(ApplicationContext applicationContext, GeneralConfigDao generalConfigDao) {
        this.applicationContext = applicationContext;
        this.generalConfigDao = generalConfigDao;
    }

    @Override
    public Flux<String> streamChat(ChatRequestContext context) {
        try {
            ChatClient chatClient = (ChatClient)this.applicationContext.getBean("openAiChatClient", ChatClient.class);
            ArrayList<Object> messages = new ArrayList<Object>();
            if (context.getConversationHistory() != null && !context.getConversationHistory().isEmpty()) {
                for (ChatMessage historyMessage : context.getConversationHistory()) {
                    if ("user".equals(historyMessage.getRole())) {
                        messages.add(new UserMessage(historyMessage.getContent()));
                        continue;
                    }
                    if (!"assistant".equals(historyMessage.getRole())) continue;
                    messages.add(new AssistantMessage(historyMessage.getContent()));
                }
            }
            messages.add(new UserMessage(context.getMessage()));
            log.info("Starting streaming chat for conversation: {}", (Object)context.getConversationId());
            return chatClient.prompt().messages(messages).system(SystemPromptTemplate.builder().resource(this.systemResource).build().getTemplate()).toolCallbacks(new ToolCallbackProvider[]{this.toolCallbackProvider}).stream().content().doOnComplete(() -> log.info("Streaming completed for conversation: {}", (Object)context.getConversationId())).doOnError(error -> log.error("Error in streaming chat: {}", (Object)error.getMessage(), error));
        }
        catch (Exception e) {
            log.error("Error setting up streaming chat: {}", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public boolean isConfigured() {
        if (!this.isConfigured) {
            GeneralConfig providerConfig = this.generalConfigDao.findByType("provider");
            ModelProviderConfig modelProviderConfig = (ModelProviderConfig)JsonUtil.fromJson((String)providerConfig.getContent(), ModelProviderConfig.class);
            this.isConfigured = modelProviderConfig != null && modelProviderConfig.getApiKey() != null;
        }
        return this.isConfigured;
    }
}

