/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.FactoryProvider;
import io.questdb.Metrics;
import io.questdb.ServerConfiguration;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.NanosecondClock;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.StationaryMillisClock;
import io.questdb.std.StationaryNanosClock;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.datetime.millitime.MillisecondClockImpl;

class PropHttpContextConfiguration
implements HttpContextConfiguration {
    private final int connectionPoolInitialCapacity;
    private final int connectionStringPoolCapacity;
    private final boolean httpAllowDeflateBeforeSend;
    private final int httpForceRecvFragmentationChunkSize;
    private final int httpForceSendFragmentationChunkSize;
    private final boolean httpFrozenClock;
    private final int httpIlpConnectionLimit;
    private final int httpJsonQueryConnectionLimit;
    private final boolean httpReadOnlySecurityContext;
    private final boolean httpServerCookiesEnabled;
    private final boolean httpServerKeepAlive;
    private final String httpVersion;
    private final boolean isReadOnlyInstance;
    private final int multipartHeaderBufferSize;
    private final long multipartIdleSpinCount;
    private final int requestHeaderBufferSize;
    private final ServerConfiguration serverConfiguration;

    PropHttpContextConfiguration(int connectionPoolInitialCapacity, int connectionStringPoolCapacity, ServerConfiguration serverConfiguration, boolean httpAllowDeflateBeforeSend, int httpForceRecvFragmentationChunkSize, int httpForceSendFragmentationChunkSize, boolean httpFrozenClock, boolean httpReadOnlySecurityContext, boolean httpServerCookiesEnabled, boolean httpServerKeepAlive, String httpVersion, boolean isReadOnlyInstance, int multipartHeaderBufferSize, long multipartIdleSpinCount, int requestHeaderBufferSize) {
        this(connectionPoolInitialCapacity, connectionStringPoolCapacity, serverConfiguration, httpAllowDeflateBeforeSend, httpForceRecvFragmentationChunkSize, httpForceSendFragmentationChunkSize, httpFrozenClock, httpReadOnlySecurityContext, httpServerCookiesEnabled, httpServerKeepAlive, httpVersion, isReadOnlyInstance, multipartHeaderBufferSize, multipartIdleSpinCount, requestHeaderBufferSize, -1, -1);
    }

    PropHttpContextConfiguration(int connectionPoolInitialCapacity, int connectionStringPoolCapacity, ServerConfiguration serverConfiguration, boolean httpAllowDeflateBeforeSend, int httpForceRecvFragmentationChunkSize, int httpForceSendFragmentationChunkSize, boolean httpFrozenClock, boolean httpReadOnlySecurityContext, boolean httpServerCookiesEnabled, boolean httpServerKeepAlive, String httpVersion, boolean isReadOnlyInstance, int multipartHeaderBufferSize, long multipartIdleSpinCount, int requestHeaderBufferSize, int httpJsonQueryConnectionLimit, int httpIlpConnectionLimit) {
        this.connectionPoolInitialCapacity = connectionPoolInitialCapacity;
        this.connectionStringPoolCapacity = connectionStringPoolCapacity;
        this.serverConfiguration = serverConfiguration;
        this.httpAllowDeflateBeforeSend = httpAllowDeflateBeforeSend;
        this.httpForceRecvFragmentationChunkSize = httpForceRecvFragmentationChunkSize;
        this.httpForceSendFragmentationChunkSize = httpForceSendFragmentationChunkSize;
        this.httpFrozenClock = httpFrozenClock;
        this.httpReadOnlySecurityContext = httpReadOnlySecurityContext;
        this.httpServerCookiesEnabled = httpServerCookiesEnabled;
        this.httpServerKeepAlive = httpServerKeepAlive;
        this.httpVersion = httpVersion;
        this.isReadOnlyInstance = isReadOnlyInstance;
        this.multipartHeaderBufferSize = multipartHeaderBufferSize;
        this.multipartIdleSpinCount = multipartIdleSpinCount;
        this.requestHeaderBufferSize = requestHeaderBufferSize;
        this.httpJsonQueryConnectionLimit = httpJsonQueryConnectionLimit;
        this.httpIlpConnectionLimit = httpIlpConnectionLimit;
    }

    @Override
    public boolean allowDeflateBeforeSend() {
        return this.httpAllowDeflateBeforeSend;
    }

    @Override
    public boolean areCookiesEnabled() {
        return this.httpServerCookiesEnabled;
    }

    @Override
    public int getConnectionPoolInitialCapacity() {
        return this.connectionPoolInitialCapacity;
    }

    @Override
    public int getConnectionStringPoolCapacity() {
        return this.connectionStringPoolCapacity;
    }

    @Override
    public boolean getDumpNetworkTraffic() {
        return false;
    }

    @Override
    public FactoryProvider getFactoryProvider() {
        return this.serverConfiguration.getFactoryProvider();
    }

    @Override
    public int getForceRecvFragmentationChunkSize() {
        return this.httpForceRecvFragmentationChunkSize;
    }

    @Override
    public int getForceSendFragmentationChunkSize() {
        return this.httpForceSendFragmentationChunkSize;
    }

    @Override
    public String getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public int getIlpConnectionLimit() {
        return this.httpIlpConnectionLimit;
    }

    @Override
    public int getJsonQueryConnectionLimit() {
        return this.httpJsonQueryConnectionLimit;
    }

    @Override
    public Metrics getMetrics() {
        return this.serverConfiguration.getMetrics();
    }

    @Override
    public MillisecondClock getMillisecondClock() {
        return this.httpFrozenClock ? StationaryMillisClock.INSTANCE : MillisecondClockImpl.INSTANCE;
    }

    @Override
    public int getMultipartHeaderBufferSize() {
        return this.multipartHeaderBufferSize;
    }

    @Override
    public long getMultipartIdleSpinCount() {
        return this.multipartIdleSpinCount;
    }

    @Override
    public NanosecondClock getNanosecondClock() {
        return this.httpFrozenClock ? StationaryNanosClock.INSTANCE : NanosecondClockImpl.INSTANCE;
    }

    @Override
    public NetworkFacade getNetworkFacade() {
        return NetworkFacadeImpl.INSTANCE;
    }

    @Override
    public int getRequestHeaderBufferSize() {
        return this.requestHeaderBufferSize;
    }

    @Override
    public boolean getServerKeepAlive() {
        return this.httpServerKeepAlive;
    }

    @Override
    public boolean readOnlySecurityContext() {
        return this.httpReadOnlySecurityContext || this.isReadOnlyInstance;
    }
}

