/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Job;
import io.questdb.mp.Sequence;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class O3OpenColumnJob
extends AbstractQueueConsumerJob<O3OpenColumnTask> {
    public static final int OPEN_LAST_PARTITION_FOR_APPEND = 2;
    public static final int OPEN_LAST_PARTITION_FOR_MERGE = 4;
    public static final int OPEN_MID_PARTITION_FOR_APPEND = 1;
    public static final int OPEN_MID_PARTITION_FOR_MERGE = 3;
    public static final int OPEN_NEW_PARTITION_FOR_APPEND = 5;
    private static final Log LOG = LogFactory.getLog(O3OpenColumnJob.class);

    public O3OpenColumnJob(MessageBus messageBus) {
        super(messageBus.getO3OpenColumnQueue(), messageBus.getO3OpenColumnSubSeq());
    }

    public static void appendLastPartition(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, MemoryMA dstFixMem, MemoryMA dstVarMem, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstLen = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop;
        if (ColumnType.isVarSize(columnType)) {
            O3OpenColumnJob.o3VarSizePartitionAppend(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, 0L, 0L, 0L, -dstFixMem.getFd(), -dstVarMem.getFd(), dstFixMem, dstVarMem, dstLen, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, partitionUpdateSinkAddr);
        } else if (ColumnType.isDesignatedTimestamp(columnType)) {
            O3OpenColumnJob.appendTimestampColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataMax, indexBlockCapacity, -dstFixMem.getFd(), 0L, 0L, dstFixMem, dstLen, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, partitionUpdateSinkAddr);
        } else {
            O3OpenColumnJob.appendFixColumn(pathToPartition, plen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, 0L, 0L, 0L, -dstFixMem.getFd(), dstFixMem, dstLen, tableWriter, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, indexWriter, columnNameTxn, partitionUpdateSinkAddr);
        }
    }

    public static void freeTimestampIndex(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, FilesFacade ff, boolean isOom) {
        tableWriter.o3BumpErrorCount(isOom);
        if (columnCounter.decrementAndGet() == 0) {
            O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
            O3Utils.close(ff, srcTimestampFd);
            tableWriter.o3ClockDownPartitionUpdateCount();
            tableWriter.o3CountDownDoneLatch();
            if (timestampMergeIndexAddr != 0L) {
                Unsafe.free(timestampMergeIndexAddr, timestampMergeIndexSize, 45);
            }
        }
    }

    public static boolean isOpenColumnModeForAppend(int openColumnMode) {
        switch (openColumnMode) {
            case 1: 
            case 2: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static void mergeVarColumn(Path pathToNewPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long o3AuxAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionHi, long srcDataTop, long srcDataMax, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeRowCount, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long srcDataFixFd, long srcDataVarFd, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, long colTopSinkAddr, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstDataAppendOffset2;
        long dstAuxAppendOffset2;
        long dstAuxAppendOffset1;
        long srcDataTopOffset;
        long srcDataFixOffset;
        int partCount = 0;
        long dstDataFd = 0L;
        long dstVarAddr = 0L;
        long srcAuxAddr = 0L;
        long newAuxSize = 0L;
        long dstDataSize = 0L;
        long dstAuxSize = 0L;
        long srcDataSize = 0L;
        long dstAuxFd = 0L;
        long dstAuxAddr = 0L;
        long srcDataAddr = 0L;
        long srcDataOffset = 0L;
        long dstDataAppendOffset1 = 0L;
        long srcFixFd = Math.abs(srcDataFixFd);
        long srcVarFd = Math.abs(srcDataVarFd);
        FilesFacade ff = tableWriter.getFilesFacade();
        boolean mixedIOFlag = tableWriter.allowMixedIO();
        try {
            pathToNewPartition.trimTo(pplen);
            ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
            if (srcDataTop > 0L && tableWriter.isCommitReplaceMode()) {
                long dataMax = 0L;
                if (prefixType == 2 && prefixHi >= prefixLo) {
                    dataMax = prefixHi + 1L;
                }
                if (suffixType == 2 && suffixHi >= suffixLo) {
                    dataMax = suffixHi + 1L;
                }
                srcDataMax = Math.min(srcDataMax, dataMax);
                srcDataTop = Math.min(srcDataTop, dataMax);
            }
            if (srcDataTop > 0L) {
                long auxRowCount = srcDataMax - srcDataTop;
                long oldAuxSize = columnTypeDriver.getAuxVectorSize(auxRowCount);
                long wouldBeAuxSize = columnTypeDriver.getAuxVectorSize(srcDataMax);
                if (srcDataTop > prefixHi || prefixType == 1) {
                    newAuxSize = columnTypeDriver.getAuxVectorSize(auxRowCount) + columnTypeDriver.getAuxVectorSize(srcDataMax);
                    srcAuxAddr = TableUtils.mapRW(ff, srcFixFd, newAuxSize, 6);
                    ff.madvise(srcAuxAddr, newAuxSize, Files.POSIX_MADV_SEQUENTIAL);
                    if (auxRowCount > 0L) {
                        srcDataSize = columnTypeDriver.getDataVectorSizeAt(srcAuxAddr, auxRowCount - 1L);
                    }
                    srcDataOffset = srcDataSize;
                    long reservedBytesForColTopNulls = srcDataTop * columnTypeDriver.getDataVectorMinEntrySize();
                    srcDataAddr = (srcDataSize += reservedBytesForColTopNulls + srcDataSize) > 0L ? TableUtils.mapRW(ff, srcVarFd, srcDataSize, 6) : srcDataAddr;
                    ff.madvise(srcDataAddr, srcDataSize, Files.POSIX_MADV_SEQUENTIAL);
                    columnTypeDriver.setDataVectorEntriesToNull(srcDataAddr + srcDataOffset, srcDataTop);
                    Vect.memcpy(srcDataAddr + srcDataOffset + reservedBytesForColTopNulls, srcDataAddr, srcDataOffset);
                    long dstAddr = srcAuxAddr + wouldBeAuxSize;
                    long dstAddrSize = newAuxSize - wouldBeAuxSize;
                    columnTypeDriver.shiftCopyAuxVector(-reservedBytesForColTopNulls, srcAuxAddr, 0L, auxRowCount - 1L, dstAddr, dstAddrSize);
                    columnTypeDriver.setPartAuxVectorNull(srcAuxAddr + oldAuxSize, 0L, srcDataTop);
                    srcDataTop = 0L;
                    srcDataFixOffset = oldAuxSize;
                } else {
                    if (prefixType != -1) {
                        Unsafe.getUnsafe().putLong(colTopSinkAddr, srcDataTop);
                    }
                    srcDataFixOffset = 0L;
                    if (auxRowCount > 0L) {
                        newAuxSize = columnTypeDriver.getAuxVectorSize(auxRowCount);
                        srcAuxAddr = TableUtils.mapRW(ff, srcFixFd, newAuxSize, 6);
                        ff.madvise(srcAuxAddr, newAuxSize, Files.POSIX_MADV_SEQUENTIAL);
                        srcDataSize = columnTypeDriver.getDataVectorSizeAt(srcAuxAddr, auxRowCount - 1L);
                        srcDataAddr = srcDataSize > 0L ? TableUtils.mapRO(ff, srcVarFd, srcDataSize, 6) : 0L;
                        ff.madvise(srcDataAddr, srcDataSize, Files.POSIX_MADV_SEQUENTIAL);
                    }
                }
            } else {
                srcDataFixOffset = 0L;
                if (srcDataMax > 0L) {
                    newAuxSize = columnTypeDriver.getAuxVectorSize(srcDataMax);
                    srcAuxAddr = TableUtils.mapRW(ff, srcFixFd, newAuxSize, 6);
                    ff.madvise(srcAuxAddr, newAuxSize, Files.POSIX_MADV_SEQUENTIAL);
                    srcDataSize = columnTypeDriver.getDataVectorSizeAt(srcAuxAddr, srcDataMax - 1L);
                    srcDataAddr = srcDataSize > 0L ? TableUtils.mapRO(ff, srcVarFd, srcDataSize, 6) : 0L;
                }
                ff.madvise(srcDataAddr, srcDataSize, Files.POSIX_MADV_SEQUENTIAL);
            }
            srcDataTopOffset = columnTypeDriver.getAuxVectorOffset(srcDataTop);
            dstAuxFd = TableUtils.openRW(ff, TableUtils.iFile(pathToNewPartition.trimTo(pplen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            long newRowCount = o3SplitPartitionSize > 0L ? o3SplitPartitionSize : srcDataNewPartitionSize - srcDataTop;
            dstAuxSize = columnTypeDriver.getAuxVectorSize(newRowCount);
            dstAuxAddr = TableUtils.mapRW(ff, dstAuxFd, dstAuxSize, 6);
            if (!mixedIOFlag) {
                ff.madvise(dstAuxAddr, dstAuxSize, Files.POSIX_MADV_RANDOM);
            }
            if (prefixType == 2) {
                dstAuxAppendOffset1 = columnTypeDriver.auxRowsToBytes(prefixHi - prefixLo + 1L - srcDataTop);
                prefixHi -= srcDataTop;
            } else {
                dstAuxAppendOffset1 = prefixType == -1 ? 0L : columnTypeDriver.auxRowsToBytes(prefixHi - prefixLo + 1L);
            }
            if (suffixType == 2 && srcDataTop > 0L) {
                suffixHi -= srcDataTop;
                suffixLo -= srcDataTop;
            }
            switch (prefixType) {
                case 1: {
                    dstDataAppendOffset1 = columnTypeDriver.getDataVectorSize(o3AuxAddr, prefixLo, prefixHi);
                    ++partCount;
                    break;
                }
                case 2: {
                    dstDataAppendOffset1 = columnTypeDriver.getDataVectorSize(srcAuxAddr + srcDataFixOffset, prefixLo, prefixHi);
                    ++partCount;
                    break;
                }
            }
            if (mergeDataLo > -1L && mergeOOOLo > -1L) {
                long mergeDataSize;
                if (mergeRowCount == mergeDataHi - mergeDataLo + 1L + mergeOOOHi - mergeOOOLo + 1L) {
                    long o3size = columnTypeDriver.getDataVectorSize(o3AuxAddr, mergeOOOLo, mergeOOOHi);
                    long dataSize = columnTypeDriver.getDataVectorSize(srcAuxAddr + srcDataFixOffset, mergeDataLo - srcDataTop, mergeDataHi - srcDataTop);
                    mergeDataSize = o3size + dataSize;
                } else {
                    mergeDataSize = tableWriter.isCommitReplaceMode() && mergeType == 1 ? columnTypeDriver.getDataVectorSize(o3AuxAddr, mergeOOOLo, mergeOOOHi) : (timestampMergeIndexAddr > 0L ? columnTypeDriver.dedupMergeVarColumnSize(timestampMergeIndexAddr, mergeRowCount, srcAuxAddr + srcDataFixOffset - columnTypeDriver.getAuxVectorOffset(srcDataTop), o3AuxAddr) : 0L);
                }
                dstAuxAppendOffset2 = dstAuxAppendOffset1 + columnTypeDriver.getAuxVectorOffset(mergeRowCount);
                dstDataAppendOffset2 = dstDataAppendOffset1 + mergeDataSize;
            } else {
                dstAuxAppendOffset2 = dstAuxAppendOffset1;
                dstDataAppendOffset2 = dstDataAppendOffset1;
            }
            long suffixSize = suffixType == 2 ? columnTypeDriver.getDataVectorSize(srcAuxAddr + srcDataFixOffset, suffixLo, suffixHi) : 0L;
            long suffixSize2 = suffixType == 1 ? columnTypeDriver.getDataVectorSize(o3AuxAddr, suffixLo, suffixHi) : 0L;
            dstDataSize = dstDataAppendOffset2 + suffixSize + suffixSize2;
            dstDataFd = TableUtils.openRW(ff, TableUtils.dFile(pathToNewPartition.trimTo(pplen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            if (dstDataSize > 0L) {
                dstVarAddr = TableUtils.mapRW(ff, dstDataFd, dstDataSize, 6);
                if (!mixedIOFlag) {
                    ff.madvise(dstVarAddr, dstDataSize, Files.POSIX_MADV_RANDOM);
                }
            }
            if (mergeType != -1) {
                ++partCount;
            }
            if (suffixType != -1) {
                ++partCount;
            }
        }
        catch (Throwable e) {
            LOG.error().$("merge var error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount(CairoException.isCairoOomError(e));
            O3CopyJob.unmapAndCloseAllPartsComplete(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcAuxAddr, newAuxSize, srcDataVarFd, srcDataAddr, srcDataSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstAuxFd, dstAuxAddr, dstAuxSize, dstDataFd, dstVarAddr, dstDataSize, 0L, 0L, tableWriter);
            throw e;
        }
        partCounter.set(partCount);
        O3OpenColumnJob.o3PublishCopyTasks(columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcAuxAddr, srcDataFixOffset, newAuxSize, srcDataVarFd, srcDataAddr, srcDataOffset, srcDataSize, srcDataTopOffset, srcDataMax, o3AuxAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, dstAuxFd, dstAuxAddr, dstAuxSize, dstDataFd, dstVarAddr, dstDataSize, dstAuxAppendOffset1, dstAuxAppendOffset2, dstDataAppendOffset1, dstDataAppendOffset2, 0L, 0L, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, null, srcDataTopOffset >> 2, partitionUpdateSinkAddr);
    }

    public static void o3PublishCopyTask(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr) {
        long cursor = tableWriter.getO3CopyPubSeq().next();
        if (cursor > -1L) {
            O3OpenColumnJob.publishCopyTaskHarmonized(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, cursor, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        } else {
            O3OpenColumnJob.publishCopyTaskContended(cursor, columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataTop, srcDataLo, srcDataHi, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void o3PublishCopyTasks(AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataTopOffset, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long dstAuxAppendOffset1, long dstAuxAppendOffset2, long dstDataAppendOffset1, long dstDataAppendOffset2, long dstKFd, long dstVFd, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long dstIndexAdjust, long partitionUpdateSinkAddr) {
        boolean partitionMutates = true;
        int partsPublished = 0;
        int partsToPublish = partCounter.get();
        try {
            switch (prefixType) {
                case 1: {
                    ++partsPublished;
                    O3OpenColumnJob.o3PublishCopyTask(columnCounter, partCounter, columnType, prefixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, prefixLo, prefixHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, 0L, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                    break;
                }
                case 2: {
                    ++partsPublished;
                    O3OpenColumnJob.o3PublishCopyTask(columnCounter, partCounter, columnType, prefixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, prefixLo, prefixHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, 0L, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                    break;
                }
            }
            switch (mergeType) {
                case 1: {
                    ++partsPublished;
                    O3OpenColumnJob.o3PublishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, mergeOOOLo, mergeOOOHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstAuxAppendOffset1, dstAuxAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstDataAppendOffset1, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                    break;
                }
                case 2: {
                    ++partsPublished;
                    O3OpenColumnJob.o3PublishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, mergeDataLo, mergeDataHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstAuxAppendOffset1, dstAuxAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstDataAppendOffset1, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                    break;
                }
                case 3: {
                    ++partsPublished;
                    O3OpenColumnJob.o3PublishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, mergeDataLo, mergeDataHi, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, mergeOOOLo, mergeOOOHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstAuxAppendOffset1, dstAuxAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstDataAppendOffset1, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                    break;
                }
            }
            switch (suffixType) {
                case 1: {
                    ++partsPublished;
                    O3OpenColumnJob.o3PublishCopyTask(columnCounter, partCounter, columnType, suffixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, suffixLo, suffixHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstAuxAppendOffset2, dstAuxAppendOffset2, dstFixSize, dstVarFd, dstVarAddr, dstDataAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                    return;
                }
                case 2: {
                    ++partsPublished;
                    O3OpenColumnJob.o3PublishCopyTask(columnCounter, partCounter, columnType, suffixType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, suffixLo, suffixHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstAuxAppendOffset2, dstAuxAppendOffset2, dstFixSize, dstVarFd, dstVarAddr, dstDataAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
                    return;
                }
            }
            return;
        }
        finally {
            if (partsPublished != partsToPublish && partCounter.addAndGet(partsPublished - partsToPublish) == 0) {
                O3CopyJob.unmapAndCloseAllPartsComplete(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, tableWriter);
            }
        }
    }

    public static void o3VarSizePartitionAppend(AtomicInteger columnCounter, int columnType, long srcOooAuxAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long activeFixFd, long activeVarFd, MemoryMA dstAuxMem, MemoryMA dstDataMem, long dstRowCount, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, long partitionUpdateSinkAddr) {
        long dstDataAdjust;
        long dstDataOffset;
        long dstAuxFileOffset;
        long dstAuxOffset;
        long dstAuxAddr = 0L;
        long dstDataAddr = 0L;
        long dstDataSize = 0L;
        long dstAuxSize = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
            long o3DataSize = columnTypeDriver.getDataVectorSize(srcOooAuxAddr, srcOooLo, srcOooHi);
            dstAuxSize = columnTypeDriver.getAuxVectorSize(dstRowCount);
            if (dstAuxMem == null || dstAuxMem.getAppendAddressSize() < dstAuxSize || dstDataMem.getAppendAddressSize() < o3DataSize) {
                assert (dstAuxMem == null || dstAuxMem.getAppendOffset() - columnTypeDriver.getMinAuxVectorSize() == columnTypeDriver.getAuxVectorOffset(srcDataMax - srcDataTop));
                dstAuxFileOffset = dstAuxOffset = columnTypeDriver.getAuxVectorOffset(srcDataMax - srcDataTop);
                dstAuxAddr = TableUtils.mapRW(ff, Math.abs(activeFixFd), dstAuxSize, 6);
                dstDataOffset = dstAuxOffset > 0L ? columnTypeDriver.getDataVectorSizeAt(dstAuxAddr, srcDataMax - 1L - srcDataTop) : 0L;
                dstDataSize = o3DataSize + dstDataOffset;
                dstDataAddr = dstDataSize > 0L ? TableUtils.mapRW(ff, Math.abs(activeVarFd), dstDataSize, 6) : 0L;
                dstDataAdjust = 0L;
            } else {
                assert (dstAuxMem.getAppendOffset() >= columnTypeDriver.getMinAuxVectorSize());
                assert (dstAuxMem.getAppendOffset() - columnTypeDriver.getMinAuxVectorSize() == columnTypeDriver.getAuxVectorOffset(srcDataMax - srcDataTop));
                dstAuxFileOffset = columnTypeDriver.getAuxVectorOffset(srcDataMax - srcDataTop);
                dstAuxAddr = dstAuxMem.getAppendAddress() - (dstAuxMem.getAppendOffset() - dstAuxFileOffset);
                dstDataAddr = dstDataMem.getAppendAddress();
                dstAuxOffset = 0L;
                dstAuxSize = -dstAuxSize;
                dstDataOffset = 0L;
                dstDataSize = -o3DataSize;
                dstDataAdjust = dstDataMem.getAppendOffset();
            }
        }
        catch (Throwable e) {
            LOG.error().$("append var error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            O3Utils.unmapAndClose(ff, activeFixFd, dstAuxAddr, dstAuxSize);
            O3Utils.unmapAndClose(ff, activeVarFd, dstDataAddr, dstDataSize);
            O3OpenColumnJob.freeTimestampIndex(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, CairoException.isCairoOomError(e));
            throw e;
        }
        O3OpenColumnJob.o3PublishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcOooLo, srcOooHi, srcDataTop, srcDataMax, srcOooAuxAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, activeFixFd, dstAuxAddr, dstAuxOffset, dstAuxFileOffset, dstAuxSize, activeVarFd, dstDataAddr, dstDataOffset, dstDataAdjust, dstDataSize, 0L, 0L, 0L, 0L, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, null, partitionUpdateSinkAddr);
    }

    public static void openColumn(int openColumnMode, Path pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long oldPartitionTimestamp, long srcDataTop, long srcDataMax, long srcNameTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, int suffixType, long suffixLo, long suffixHi, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int indexBlockCapacity, long activeFixFd, long activeVarFd, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr, int columnIndex, long columnNameTxn) {
        long mergeRowCount = mergeType == 3 ? timestampMergeIndexSize / 16L : (mergeType == 1 ? mergeOOOHi - mergeOOOLo + 1L : (mergeType == -1 ? 0L : mergeOOOHi - mergeOOOLo + 1L + mergeDataHi - mergeDataLo + 1L));
        Path pathToOldPartition = Path.getThreadLocal(pathToTable);
        TableUtils.setPathForNativePartition(pathToOldPartition, tableWriter.getPartitionBy(), oldPartitionTimestamp, srcNameTxn);
        int plen = pathToOldPartition.size();
        Path pathToNewPartition = Path.getThreadLocal2(pathToTable);
        boolean partitionAppend = O3OpenColumnJob.isOpenColumnModeForAppend(openColumnMode);
        TableUtils.setPathForNativePartition(pathToNewPartition, tableWriter.getPartitionBy(), partitionTimestamp, partitionAppend ? srcNameTxn : txn);
        int pplen = pathToNewPartition.size();
        long colTopSinkAddr = O3OpenColumnJob.columnTopAddress(partitionUpdateSinkAddr, columnIndex);
        switch (openColumnMode) {
            case 1: 
            case 2: {
                O3OpenColumnJob.appendMidPartition(pathToNewPartition, pplen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, oldPartitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, openColumnMode == 2 && indexWriter != null ? tableWriter.getBitmapIndexWriter(columnIndex) : indexWriter, colTopSinkAddr, columnIndex, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
            case 3: {
                O3OpenColumnJob.mergeMidPartition(pathToOldPartition, plen, pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeRowCount, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, colTopSinkAddr, oldPartitionTimestamp, columnIndex, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
            case 4: {
                O3OpenColumnJob.mergeLastPartition(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeRowCount, suffixType, suffixLo, suffixHi, indexBlockCapacity, activeFixFd, activeVarFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
            case 5: {
                Unsafe.getUnsafe().putLong(colTopSinkAddr, 0L);
                O3OpenColumnJob.appendNewPartition(pathToNewPartition, plen, columnName, columnCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataMax, indexBlockCapacity, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, columnNameTxn, partitionUpdateSinkAddr);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public static void openColumn(O3OpenColumnTask task, long cursor, Sequence subSeq) {
        int openColumnMode = task.getOpenColumnMode();
        Path pathToTable = task.getPathToTable();
        int columnType = task.getColumnType();
        CharSequence columnName = task.getColumnName();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long timestampMin = task.getTimestampMin();
        long partitionTimestamp = task.getPartitionTimestamp();
        long oldPartitionTimestamp = task.getOldPartitionTimestamp();
        long srcDataMax = task.getSrcDataMax();
        long srcNameTxn = task.getSrcNameTxn();
        long srcTimestampFd = task.getSrcTimestampFd();
        long srcTimestampAddr = task.getSrcTimestampAddr();
        long srcTimestampSize = task.getSrcTimestampSize();
        AtomicInteger columnCounter = task.getColumnCounter();
        AtomicInteger partCounter = task.getPartCounter();
        int indexBlockCapacity = task.getIndexBlockCapacity();
        long srcOooFixAddr = task.getSrcOooFixAddr();
        long srcOooVarAddr = task.getSrcOooVarAddr();
        long mergeOOOLo = task.getMergeOOOLo();
        long mergeOOOHi = task.getMergeOOOHi();
        long mergeDataLo = task.getMergeDataLo();
        long mergeDataHi = task.getMergeDataHi();
        long txn = task.getTxn();
        int prefixType = task.getPrefixType();
        long prefixLo = task.getPrefixLo();
        long prefixHi = task.getPrefixHi();
        int suffixType = task.getSuffixType();
        long suffixLo = task.getSuffixLo();
        long suffixHi = task.getSuffixHi();
        int mergeType = task.getMergeType();
        long timestampMergeIndexAddr = task.getTimestampMergeIndexAddr();
        long timestampMergeIndexSize = task.getTimestampMergeIndexSize();
        long activeFixFd = task.getActiveFixFd();
        long activeVarFd = task.getActiveVarFd();
        long srcDataTop = task.getSrcDataTop();
        TableWriter tableWriter = task.getTableWriter();
        BitmapIndexWriter indexWriter = task.getIndexWriter();
        long partitionUpdateSinkAddr = task.getPartitionUpdateSinkAddr();
        int columnIndex = task.getColumnIndex();
        long columnNameTxn = task.getColumnNameTxn();
        long srcDataNewPartitionSize = task.getSrcDataNewPartitionSize();
        long srcDataOldPartitionSize = task.getSrcDataOldPartitionSize();
        long o3SplitPartitionSize = task.getO3SplitPartitionSize();
        subSeq.done(cursor);
        O3OpenColumnJob.openColumn(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, oldPartitionTimestamp, srcDataTop, srcDataMax, srcNameTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, indexBlockCapacity, activeFixFd, activeVarFd, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr, columnIndex, columnNameTxn);
    }

    private static void appendFixColumn(Path pathToNewPartition, int pNewLen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long dstFixFd, MemoryMA dstFixMem, long dstLen, TableWriter tableWriter, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, BitmapIndexWriter indexWriter, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstFixFileOffset;
        long dstIndexAdjust;
        long dstIndexOffset;
        long dstFixOffset;
        long dstKFd = 0L;
        long dstVFd = 0L;
        int shl = ColumnType.pow2SizeOf(columnType);
        FilesFacade ff = tableWriter.getFilesFacade();
        long dstFixAddr = 0L;
        long dstFixSize = dstLen << shl;
        try {
            dstFixOffset = srcDataMax - srcDataTop << shl;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize) {
                dstFixAddr = TableUtils.mapRW(ff, Math.abs(dstFixFd), dstFixSize, 6);
            } else {
                dstFixAddr = dstFixMem.getAppendAddress() - dstFixOffset;
                dstFixSize = -dstFixSize;
            }
            dstIndexOffset = dstFixOffset;
            dstIndexAdjust = srcDataTop;
            dstFixFileOffset = dstFixOffset;
            if (indexBlockCapacity > -1 && !indexWriter.isOpen()) {
                dstKFd = TableUtils.openRW(ff, BitmapIndexUtils.keyFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstVFd = TableUtils.openRW(ff, BitmapIndexUtils.valueFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
        }
        catch (Throwable e) {
            LOG.error().$("append fix error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            if (dstFixSize > 0L) {
                O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            } else {
                O3Utils.unmapAndClose(ff, dstFixFd, 0L, 0L);
            }
            O3Utils.close(ff, dstKFd);
            O3Utils.close(ff, dstVFd);
            O3OpenColumnJob.freeTimestampIndex(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, CairoException.isCairoOomError(e));
            throw e;
        }
        O3OpenColumnJob.o3PublishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcOooLo, srcOooHi, srcDataTop << shl, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, 0L, 0L, 0L, 0L, 0L, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
    }

    private static void appendMidPartition(Path pathToNewPartition, int pNewLen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long oldPartitionTimestamp, long srcDataTop, long srcDataMax, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, int columnIndex, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstFixFd = 0L;
        long dstVarFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataTop == -1L) {
            try {
                srcDataTop = Math.min(srcDataMax, tableWriter.getColumnTop(oldPartitionTimestamp, columnIndex, srcDataMax));
                if (srcDataTop == srcDataMax) {
                    Unsafe.getUnsafe().putLong(colTopSinkAddr, srcDataMax);
                }
            }
            catch (Throwable e) {
                LOG.error().$("append mid partition error 1 [table=").$(tableWriter.getTableToken()).$(", e=").$(e).I$();
                O3OpenColumnJob.freeTimestampIndex(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, CairoException.isCairoOomError(e));
                throw e;
            }
        }
        long dstRowCount = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop;
        if (ColumnType.isVarSize(columnType)) {
            try {
                dstFixFd = TableUtils.openRW(ff, TableUtils.iFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstVarFd = TableUtils.openRW(ff, TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
            catch (Throwable e) {
                LOG.error().$("append mid partition error 2 [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                O3Utils.close(ff, dstFixFd);
                O3Utils.close(ff, dstVarFd);
                O3OpenColumnJob.freeTimestampIndex(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, CairoException.isCairoOomError(e));
                throw e;
            }
            O3OpenColumnJob.o3VarSizePartitionAppend(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstVarFd, null, null, dstRowCount, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, partitionUpdateSinkAddr);
        } else if (ColumnType.isDesignatedTimestamp(columnType)) {
            O3OpenColumnJob.appendTimestampColumn(columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, null, dstRowCount, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, partitionUpdateSinkAddr);
        } else {
            try {
                dstFixFd = TableUtils.openRW(ff, TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
            catch (Throwable e) {
                LOG.error().$("append mid partition error 3 [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                O3Utils.close(ff, dstFixFd);
                O3Utils.close(ff, dstVarFd);
                O3OpenColumnJob.freeTimestampIndex(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, CairoException.isCairoOomError(e));
                throw e;
            }
            O3OpenColumnJob.appendFixColumn(pathToNewPartition, pNewLen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, timestampMin, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, null, dstRowCount, tableWriter, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, indexWriter, columnNameTxn, partitionUpdateSinkAddr);
        }
    }

    private static void appendNewPartition(Path pathToNewPartition, int pNewLen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataMax, int indexBlockCapacity, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstFixFd = 0L;
        long dstFixAddr = 0L;
        long dstFixSize = 0L;
        long dstVarFd = 0L;
        long dstVarAddr = 0L;
        long dstVarSize = 0L;
        long dstKFd = 0L;
        long dstVFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            if (ColumnType.isVarSize(columnType)) {
                dstFixFd = TableUtils.openRW(ff, TableUtils.iFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                dstFixSize = columnTypeDriver.getAuxVectorSize(srcOooHi - srcOooLo + 1L);
                dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 6);
                dstVarFd = TableUtils.openRW(ff, TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstVarSize = columnTypeDriver.getDataVectorSize(srcOooFixAddr, srcOooLo, srcOooHi);
                dstVarAddr = dstVarSize > 0L ? TableUtils.mapRW(ff, dstVarFd, dstVarSize, 6) : 0L;
            } else {
                dstFixFd = TableUtils.openRW(ff, TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstFixSize = srcOooHi - srcOooLo + 1L << ColumnType.pow2SizeOf(Math.abs(columnType));
                dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 6);
                if (indexBlockCapacity > -1) {
                    dstKFd = TableUtils.openRW(ff, BitmapIndexUtils.keyFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    dstVFd = TableUtils.openRW(ff, BitmapIndexUtils.valueFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                }
            }
        }
        catch (Throwable e) {
            LOG.error().$("append new partition error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount(CairoException.isCairoOomError(e));
            FilesFacade ff1 = tableWriter.getFilesFacade();
            O3Utils.unmapAndClose(ff1, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff1, dstVarFd, dstVarAddr, dstVarSize);
            O3Utils.close(ff1, dstKFd);
            O3Utils.close(ff1, dstVFd);
            if (columnCounter.decrementAndGet() == 0) {
                tableWriter.o3ClockDownPartitionUpdateCount();
                tableWriter.o3CountDownDoneLatch();
            }
            throw e;
        }
        O3OpenColumnJob.o3PublishCopyTask(columnCounter, null, columnType, 1, timestampMergeIndexAddr, timestampMergeIndexSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, 0L, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, indexBlockCapacity, 0L, 0L, 0L, false, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
    }

    private static void appendTimestampColumn(AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long partitionTimestamp, long srcDataMax, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, MemoryMA dstFixMem, long dstLen, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, long partitionUpdateSinkAddr) {
        long dstFixAddr;
        long dstFixFileOffset;
        long dstFixOffset;
        long dstFixSize;
        long dstFixFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            dstFixSize = dstLen * 8L;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize) {
                dstFixFileOffset = dstFixOffset = srcDataMax * 8L;
                dstFixFd = -Math.abs(srcTimestampFd);
                dstFixAddr = TableUtils.mapRW(ff, -dstFixFd, dstFixSize, 6);
            } else {
                dstFixAddr = dstFixMem.getAppendAddress();
                dstFixOffset = 0L;
                dstFixFileOffset = dstFixMem.getAppendOffset();
                dstFixSize = -dstFixSize;
            }
        }
        catch (Throwable e) {
            LOG.error().$("append ts error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            O3Utils.close(ff, dstFixFd);
            O3OpenColumnJob.freeTimestampIndex(columnCounter, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, CairoException.isCairoOomError(e));
            throw e;
        }
        O3OpenColumnJob.o3PublishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcOooLo, srcOooHi, 0L, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, null, partitionUpdateSinkAddr);
    }

    private static long columnTopAddress(long partitionUpdateSinkAddr, int columnIndex) {
        return partitionUpdateSinkAddr + 64L + (long)columnIndex * 8L;
    }

    private static void mergeFixColumn(Path pathToNewPartition, int pNewLen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionHi, long srcDataMax, long srcDataTop, long srcDataFixFd, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeRowCount, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, long columnNameTxn, long partitionUpdateSinkAddr) {
        long dstFixAppendOffset2;
        long dstFixAppendOffset1;
        long dstIndexAdjust;
        long srcDataTopOffset;
        long srcDataFixOffset;
        int partCount = 0;
        long srcDataFixSize = 0L;
        long srcDataFixAddr = 0L;
        long dstFixFd = 0L;
        long dstFixAddr = 0L;
        long dstFixSize = 0L;
        long dstKFd = 0L;
        long dstVFd = 0L;
        long srcFixFd = Math.abs(srcDataFixFd);
        int shl = ColumnType.pow2SizeOf(Math.abs(columnType));
        FilesFacade ff = tableWriter.getFilesFacade();
        boolean mixedIOFlag = tableWriter.allowMixedIO();
        try {
            if (srcDataTop > 0L && tableWriter.isCommitReplaceMode()) {
                long dataMax = 0L;
                if (prefixType == 2 && prefixHi >= prefixLo) {
                    dataMax = prefixHi + 1L;
                }
                if (suffixType == 2 && suffixHi >= suffixLo) {
                    dataMax = suffixHi + 1L;
                }
                srcDataMax = Math.min(srcDataMax, dataMax);
                srcDataTop = Math.min(srcDataTop, dataMax);
            }
            if (srcDataTop > 0L) {
                long srcDataActualBytes = srcDataMax - srcDataTop << shl;
                long srcDataMaxBytes = srcDataMax << shl;
                if (srcDataTop > prefixHi || prefixType == 1) {
                    srcDataFixSize = srcDataActualBytes + srcDataMaxBytes;
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 6);
                    ff.madvise(srcDataFixAddr, srcDataFixSize, Files.POSIX_MADV_SEQUENTIAL);
                    TableUtils.setNull(columnType, srcDataFixAddr + srcDataActualBytes, srcDataTop);
                    Vect.memcpy(srcDataFixAddr + srcDataMaxBytes, srcDataFixAddr, srcDataActualBytes);
                    srcDataTop = 0L;
                    srcDataFixOffset = srcDataActualBytes;
                } else {
                    if (prefixType != -1) {
                        Unsafe.getUnsafe().putLong(colTopSinkAddr, srcDataTop);
                    }
                    if ((srcDataFixSize = srcDataActualBytes) != 0L) {
                        srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 6);
                        ff.madvise(srcDataFixAddr, srcDataFixSize, Files.POSIX_MADV_SEQUENTIAL);
                    }
                    srcDataFixOffset = 0L;
                }
            } else {
                srcDataFixSize = srcDataMax << shl;
                if (srcDataFixSize != 0L) {
                    srcDataFixAddr = TableUtils.mapRW(ff, srcFixFd, srcDataFixSize, 6);
                    ff.madvise(srcDataFixAddr, srcDataFixSize, Files.POSIX_MADV_SEQUENTIAL);
                }
                srcDataFixOffset = 0L;
            }
            srcDataTopOffset = srcDataTop << shl;
            dstIndexAdjust = srcDataTopOffset >> 2;
            dstFixFd = TableUtils.openRW(ff, TableUtils.dFile(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            long rowCount = o3SplitPartitionSize > 0L ? o3SplitPartitionSize : srcDataNewPartitionSize - srcDataTop;
            dstFixSize = rowCount << shl;
            dstFixAddr = TableUtils.mapRW(ff, dstFixFd, dstFixSize, 6);
            if (!mixedIOFlag) {
                ff.madvise(dstFixAddr, dstFixSize, Files.POSIX_MADV_RANDOM);
            }
            if (prefixType == 2) {
                dstFixAppendOffset1 = prefixHi - prefixLo + 1L - srcDataTop << shl;
                prefixHi -= srcDataTop;
            } else if (prefixType == -1) {
                dstFixAppendOffset1 = 0L;
                prefixHi -= srcDataTop;
                dstIndexAdjust = 0L;
            } else {
                dstFixAppendOffset1 = prefixHi - prefixLo + 1L << shl;
            }
            dstFixAppendOffset2 = mergeDataLo > -1L && mergeOOOLo > -1L ? dstFixAppendOffset1 + (mergeRowCount << shl) : dstFixAppendOffset1;
            if (suffixType == 2 && srcDataTop > 0L) {
                suffixHi -= srcDataTop;
                suffixLo -= srcDataTop;
            }
            if (indexBlockCapacity > -1) {
                dstKFd = TableUtils.openRW(ff, BitmapIndexUtils.keyFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                dstVFd = TableUtils.openRW(ff, BitmapIndexUtils.valueFileName(pathToNewPartition.trimTo(pNewLen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
            if (prefixType != -1) {
                ++partCount;
            }
            if (mergeType != -1) {
                ++partCount;
            }
            if (suffixType != -1) {
                ++partCount;
            }
        }
        catch (Throwable e) {
            LOG.error().$("merge fix error [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.close(ff, dstKFd);
            O3Utils.close(ff, dstVFd);
            tableWriter.o3BumpErrorCount(CairoException.isCairoOomError(e));
            if (columnCounter.decrementAndGet() == 0) {
                O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
                O3Utils.close(ff, srcTimestampFd);
                Unsafe.free(timestampMergeIndexAddr, timestampMergeIndexSize, 45);
                tableWriter.o3ClockDownPartitionUpdateCount();
                tableWriter.o3CountDownDoneLatch();
            }
            throw e;
        }
        partCounter.set(partCount);
        O3OpenColumnJob.o3PublishCopyTasks(columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, 0L, 0L, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, dstFixFd, dstFixAddr, dstFixSize, 0L, 0L, 0L, dstFixAppendOffset1, dstFixAppendOffset2, 0L, 0L, dstKFd, dstVFd, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, dstIndexAdjust, partitionUpdateSinkAddr);
    }

    private static void mergeLastPartition(Path pathToNewPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionHi, long srcDataTop, long srcDataMax, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeRowCount, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, long activeFixFd, long activeVarFd, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, long columnNameTxn, long partitionUpdateSinkAddr) {
        if (ColumnType.isVarSize(columnType)) {
            O3OpenColumnJob.mergeVarColumn(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, srcDataTop, srcDataMax, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeRowCount, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, -activeFixFd, -activeVarFd, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
        } else {
            O3OpenColumnJob.mergeFixColumn(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, srcDataMax, srcDataTop, -activeFixFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeRowCount, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
        }
    }

    private static void mergeMidPartition(Path pathToOldPartition, int plen, Path pathToNewPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionHi, long srcDataTop, long srcDataMax, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeRowCount, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, long oldPartitionTimestamp, int columnIndex, long columnNameTxn, long partitionUpdateSinkAddr) {
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataTop == -1L) {
            try {
                srcDataTop = Math.min(tableWriter.getColumnTop(oldPartitionTimestamp, columnIndex, srcDataMax), srcDataMax);
            }
            catch (Throwable e) {
                LOG.error().$("merge mid partition error 1 [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                O3OpenColumnJob.freeTimestampIndex(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, CairoException.isCairoOomError(e));
                throw e;
            }
        }
        long srcDataFixFd = 0L;
        long srcDataVarFd = 0L;
        if (ColumnType.isVarSize(columnType)) {
            try {
                srcDataFixFd = TableUtils.openRW(ff, TableUtils.iFile(pathToOldPartition.trimTo(plen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                srcDataVarFd = TableUtils.openRW(ff, TableUtils.dFile(pathToOldPartition.trimTo(plen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
            catch (Throwable e) {
                LOG.error().$("merge mid partition error 2 [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                O3Utils.close(ff, srcDataFixFd);
                O3Utils.close(ff, srcDataVarFd);
                O3OpenColumnJob.freeTimestampIndex(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, CairoException.isCairoOomError(e));
                throw e;
            }
            O3OpenColumnJob.mergeVarColumn(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, srcDataTop, srcDataMax, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeRowCount, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, srcDataFixFd, srcDataVarFd, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
        } else {
            try {
                srcDataFixFd = columnType < 0 && srcTimestampFd > 0L ? -srcTimestampFd : TableUtils.openRW(ff, TableUtils.dFile(pathToOldPartition.trimTo(plen), columnName, columnNameTxn), LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
            }
            catch (Throwable e) {
                LOG.error().$("merge mid partition error 3 [table=").$safe(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                O3OpenColumnJob.freeTimestampIndex(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, ff, CairoException.isCairoOomError(e));
                throw e;
            }
            O3OpenColumnJob.mergeFixColumn(pathToNewPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionHi, srcDataMax, srcDataTop, srcDataFixFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeRowCount, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, colTopSinkAddr, columnNameTxn, partitionUpdateSinkAddr);
        }
    }

    private static void publishCopyTaskContended(long cursor, AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataTop, long srcDataLo, long srcDataHi, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr) {
        while (cursor == -2L) {
            cursor = tableWriter.getO3CopyPubSeq().next();
        }
        if (cursor == -1L) {
            O3CopyJob.copy(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        } else {
            O3OpenColumnJob.publishCopyTaskHarmonized(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, cursor, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        }
    }

    private static void publishCopyTaskHarmonized(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, long cursor, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, long srcDataNewPartitionSize, long srcDataOldPartitionSize, long o3SplitPartitionSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long partitionUpdateSinkAddr) {
        O3CopyTask task = tableWriter.getO3CopyQueue().get(cursor);
        task.of(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, srcDataNewPartitionSize, srcDataOldPartitionSize, o3SplitPartitionSize, tableWriter, indexWriter, partitionUpdateSinkAddr);
        tableWriter.getO3CopyPubSeq().done(cursor);
    }

    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        O3OpenColumnJob.openColumn((O3OpenColumnTask)this.queue.get(cursor), cursor, this.subSeq);
        return true;
    }
}

