/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.BorrowedFlatArrayView;
import io.questdb.cairo.arr.MutableArray;
import io.questdb.std.DirectIntSlice;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;

public class BorrowedArray
extends MutableArray
implements Mutable {
    private final DirectIntSlice borrowedShape = new DirectIntSlice();

    public BorrowedArray() {
        this.flatView = new BorrowedFlatArrayView();
    }

    @Override
    public void clear() {
        this.type = 0;
        this.borrowedFlatView().reset();
        this.shape.clear();
        this.strides.clear();
    }

    public BorrowedArray of(int columnType, long auxAddr, long auxLim, long dataAddr, long dataLim, long rowNum) {
        assert (ColumnType.isArray(columnType)) : "type class is not Array";
        this.setType(columnType);
        short elemType = ColumnType.decodeArrayElementType(columnType);
        int elemSize = ColumnType.sizeOf(elemType);
        int nDims = ColumnType.decodeArrayDimensionality(columnType);
        assert (nDims > 0 && nDims <= 32);
        long rowOffset = ArrayTypeDriver.getAuxVectorOffsetStatic(rowNum);
        assert (auxAddr + 16L <= auxLim);
        long crcAndOffset = Unsafe.getUnsafe().getLong(auxAddr + rowOffset);
        long sizeBytes = Unsafe.getUnsafe().getInt(auxAddr + rowOffset + 8L);
        if (sizeBytes == 0L) {
            this.ofNull();
            return this;
        }
        assert (dataAddr + sizeBytes <= dataLim) : "dataAddr + sizeBytes > dataLim";
        long offset = crcAndOffset & 0xFFFFFFFFFFFFL;
        long dataEntryPtr = dataAddr + offset;
        this.loadShape(dataEntryPtr, nDims);
        assert (dataEntryPtr + (long)(nDims * 4) <= dataLim) : "dataEntryPtr + shapeSize > dataLim";
        this.resetToDefaultStrides();
        long unalignedValuesOffset = offset + (long)nDims * 4L;
        long bytesToSkipForAlignment = ArrayTypeDriver.bytesToSkipForAlignment(unalignedValuesOffset, elemSize);
        long valuesPtr = dataAddr + unalignedValuesOffset + bytesToSkipForAlignment;
        assert (valuesPtr + (long)this.flatViewLength * (long)elemSize <= dataLim);
        this.borrowedFlatView().of(valuesPtr, elemType, this.flatViewLength);
        return this;
    }

    public BorrowedArray of(int columnType, long shapeAddr, long valuePtr, int valueSize) {
        assert (shapeAddr != 0L) : "shapeAddr == 0";
        assert (ColumnType.isArray(columnType)) : "columnType is not Array";
        short elemType = ColumnType.decodeArrayElementType(columnType);
        this.setType(columnType);
        this.loadShape(shapeAddr, ColumnType.decodeArrayDimensionality(columnType));
        this.resetToDefaultStrides();
        assert (ColumnType.sizeOf(elemType) * this.flatViewLength == valueSize);
        if (!this.isEmpty()) {
            this.borrowedFlatView().of(valuePtr, elemType, this.flatViewLength);
        }
        return this;
    }

    public BorrowedArray of(BorrowedArray other) {
        this.type = other.type;
        this.shape.clear();
        this.strides.clear();
        this.shape.addAll(other.shape);
        this.strides.addAll(other.strides);
        this.flatViewLength = other.flatViewLength;
        this.flatViewOffset = other.flatViewOffset;
        this.borrowedFlatView().of(other.borrowedFlatView());
        return this;
    }

    public void ofNull() {
        this.clear();
        this.type = 33;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadShape(long shapeAddr, int nDims) {
        this.borrowedShape.of(shapeAddr, nDims);
        try {
            for (int i = 0; i < nDims; ++i) {
                this.setDimLen(i, this.borrowedShape.get(i));
            }
        }
        finally {
            this.borrowedShape.reset();
        }
    }
}

