/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.OrderedMap;
import io.questdb.cairo.map.OrderedMapCursor;
import io.questdb.cairo.map.OrderedMapFixedSizeRecord;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.std.DirectLongLongSortedList;
import io.questdb.std.bytes.Bytes;

class OrderedMapFixedSizeCursor
implements OrderedMapCursor {
    private final long entrySize;
    private final OrderedMapFixedSizeRecord recordA;
    private final OrderedMapFixedSizeRecord recordB;
    private long heapAddr;
    private long heapStart;
    private int remaining;
    private int size;

    OrderedMapFixedSizeCursor(OrderedMapFixedSizeRecord record, OrderedMap map) {
        assert (map.keySize() != -1L);
        this.recordA = record;
        this.recordB = record.clone();
        this.entrySize = Bytes.align8b(map.keySize() + map.valueSize());
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        if (this.remaining > 0) {
            counter.add(this.remaining);
            this.remaining = 0;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public MapRecord getRecord() {
        return this.recordA;
    }

    @Override
    public MapRecord getRecordB() {
        return this.recordB;
    }

    @Override
    public boolean hasNext() {
        if (this.remaining > 0) {
            this.recordA.of(this.heapAddr);
            this.heapAddr += this.entrySize;
            --this.remaining;
            return true;
        }
        return false;
    }

    @Override
    public OrderedMapFixedSizeCursor init(long heapStart, long heapLimit, int size) {
        this.heapAddr = this.heapStart = heapStart;
        this.remaining = this.size = size;
        this.recordA.setLimit(heapLimit);
        this.recordB.setLimit(heapLimit);
        return this;
    }

    @Override
    public void longTopK(DirectLongLongSortedList list, Function recordFunction) {
        long lim = this.heapStart + this.entrySize * (long)this.size;
        for (long addr = this.heapStart; addr < lim; addr += this.entrySize) {
            this.recordA.of(addr);
            long v = recordFunction.getLong(this.recordA);
            list.add(addr, v);
        }
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((OrderedMapFixedSizeRecord)record).of(atRowId);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void toTop() {
        this.heapAddr = this.heapStart;
        this.remaining = this.size;
    }
}

