/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.OrderedMapRecord;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Long256Util;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

final class OrderedMapValue
implements MapValue {
    private final Long256Impl long256 = new Long256Impl();
    private final long[] valueOffsets;
    private final long valueSize;
    private long limit;
    private boolean newValue;
    private OrderedMapRecord record;
    private long startAddress;
    private long valueAddress;

    public OrderedMapValue(long valueSize, long[] valueOffsets) {
        this.valueSize = valueSize;
        this.valueOffsets = valueOffsets;
    }

    @Override
    public void addByte(int index, byte value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putByte(p, (byte)(Unsafe.getUnsafe().getByte(p) + value));
    }

    @Override
    public void addDouble(int index, double value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putDouble(p, Unsafe.getUnsafe().getDouble(p) + value);
    }

    @Override
    public void addFloat(int index, float value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putFloat(p, Unsafe.getUnsafe().getFloat(p) + value);
    }

    @Override
    public void addInt(int index, int value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putInt(p, Unsafe.getUnsafe().getInt(p) + value);
    }

    @Override
    public void addLong(int index, long value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putLong(p, Unsafe.getUnsafe().getLong(p) + value);
    }

    @Override
    public void addLong256(int index, Long256 value) {
        Long256 acc = this.getLong256A(index);
        Long256Util.add(acc, value);
        long p = this.address0(index);
        Unsafe.getUnsafe().putLong(p, acc.getLong0());
        Unsafe.getUnsafe().putLong(p + 8L, acc.getLong1());
        Unsafe.getUnsafe().putLong(p + 16L, acc.getLong2());
        Unsafe.getUnsafe().putLong(p + 24L, acc.getLong3());
    }

    @Override
    public void addShort(int index, short value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putShort(p, (short)(Unsafe.getUnsafe().getShort(p) + value));
    }

    @Override
    public void copyFrom(MapValue value) {
        OrderedMapValue other = (OrderedMapValue)value;
        Vect.memcpy(this.valueAddress, other.valueAddress, this.valueSize);
    }

    @Override
    public boolean getBool(int index) {
        return this.getByte(index) == 1;
    }

    @Override
    public byte getByte(int index) {
        return Unsafe.getUnsafe().getByte(this.address0(index));
    }

    @Override
    public char getChar(int index) {
        return Unsafe.getUnsafe().getChar(this.address0(index));
    }

    @Override
    public long getDate(int index) {
        return this.getLong(index);
    }

    @Override
    public double getDouble(int index) {
        return Unsafe.getUnsafe().getDouble(this.address0(index));
    }

    @Override
    public float getFloat(int index) {
        return Unsafe.getUnsafe().getFloat(this.address0(index));
    }

    @Override
    public byte getGeoByte(int col) {
        return this.getByte(col);
    }

    @Override
    public int getGeoInt(int col) {
        return this.getInt(col);
    }

    @Override
    public long getGeoLong(int col) {
        return this.getLong(col);
    }

    @Override
    public short getGeoShort(int col) {
        return this.getShort(col);
    }

    @Override
    public int getIPv4(int index) {
        return Unsafe.getUnsafe().getInt(this.address0(index));
    }

    @Override
    public int getInt(int index) {
        return Unsafe.getUnsafe().getInt(this.address0(index));
    }

    @Override
    public long getLong(int index) {
        return Unsafe.getUnsafe().getLong(this.address0(index));
    }

    @Override
    public long getLong128Hi(int col) {
        return Unsafe.getUnsafe().getLong(this.address0(col) + 8L);
    }

    @Override
    public long getLong128Lo(int col) {
        return Unsafe.getUnsafe().getLong(this.address0(col));
    }

    @Override
    public Long256 getLong256A(int index) {
        this.long256.fromAddress(this.address0(index));
        return this.long256;
    }

    @Override
    public short getShort(int index) {
        return Unsafe.getUnsafe().getShort(this.address0(index));
    }

    @Override
    public long getStartAddress() {
        return this.startAddress;
    }

    @Override
    public long getTimestamp(int index) {
        return this.getLong(index);
    }

    @Override
    public boolean isNew() {
        return this.newValue;
    }

    @Override
    public void maxInt(int index, int value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putInt(p, Math.max(value, Unsafe.getUnsafe().getInt(p)));
    }

    @Override
    public void maxLong(int index, long value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putLong(p, Math.max(value, Unsafe.getUnsafe().getLong(p)));
    }

    @Override
    public void minInt(int index, int value) {
        if (value != Integer.MIN_VALUE) {
            long p = this.address0(index);
            int current = Unsafe.getUnsafe().getInt(p);
            Unsafe.getUnsafe().putInt(p, current != Integer.MIN_VALUE ? Math.min(value, current) : value);
        }
    }

    @Override
    public void minLong(int index, long value) {
        if (value != Long.MIN_VALUE) {
            long p = this.address0(index);
            long current = Unsafe.getUnsafe().getLong(p);
            Unsafe.getUnsafe().putLong(p, current != Long.MIN_VALUE ? Math.min(value, current) : value);
        }
    }

    @Override
    public void putBool(int index, boolean value) {
        this.putByte(index, (byte)(value ? 1 : 0));
    }

    @Override
    public void putByte(int index, byte value) {
        long p = this.address0(index);
        assert (p + 1L <= this.limit);
        Unsafe.getUnsafe().putByte(p, value);
    }

    @Override
    public void putChar(int index, char value) {
        long p = this.address0(index);
        assert (p + 2L <= this.limit);
        Unsafe.getUnsafe().putChar(p, value);
    }

    @Override
    public void putDate(int index, long value) {
        this.putLong(index, value);
    }

    @Override
    public void putDouble(int index, double value) {
        long p = this.address0(index);
        assert (p + 8L <= this.limit);
        Unsafe.getUnsafe().putDouble(p, value);
    }

    @Override
    public void putFloat(int index, float value) {
        long p = this.address0(index);
        assert (p + 4L <= this.limit);
        Unsafe.getUnsafe().putFloat(p, value);
    }

    @Override
    public void putInt(int index, int value) {
        long p = this.address0(index);
        assert (p + 4L <= this.limit);
        Unsafe.getUnsafe().putInt(p, value);
    }

    @Override
    public void putLong(int index, long value) {
        long p = this.address0(index);
        assert (p + 8L <= this.limit);
        Unsafe.getUnsafe().putLong(p, value);
    }

    @Override
    public void putLong128(int index, long lo, long hi) {
        long address = this.address0(index);
        Unsafe.getUnsafe().putLong(address, lo);
        Unsafe.getUnsafe().putLong(address + 8L, hi);
    }

    @Override
    public void putLong256(int index, Long256 value) {
        long p = this.address0(index);
        assert (p + 32L <= this.limit);
        Unsafe.getUnsafe().putLong(p, value.getLong0());
        Unsafe.getUnsafe().putLong(p + 8L, value.getLong1());
        Unsafe.getUnsafe().putLong(p + 16L, value.getLong2());
        Unsafe.getUnsafe().putLong(p + 24L, value.getLong3());
    }

    @Override
    public void putShort(int index, short value) {
        Unsafe.getUnsafe().putShort(this.address0(index), value);
    }

    @Override
    public void putTimestamp(int index, long value) {
        this.putLong(index, value);
    }

    @Override
    public void setMapRecordHere() {
        this.record.of(this.startAddress);
    }

    private long address0(int index) {
        return this.valueAddress + this.valueOffsets[index];
    }

    void copyRawValue(long ptr) {
        Vect.memcpy(this.valueAddress, ptr, this.valueSize);
    }

    void linkRecord(OrderedMapRecord record) {
        this.record = record;
        record.setLimit(this.limit);
    }

    OrderedMapValue of(long startAddress, long valueAddress, long limit, boolean newValue) {
        this.startAddress = startAddress;
        this.valueAddress = valueAddress;
        this.limit = limit;
        this.newValue = newValue;
        return this;
    }
}

