/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.mig.MigrationActions;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.Path;

final class Mig605 {
    Mig605() {
    }

    static void migrate(MigrationContext migrationContext) {
        MigrationActions.LOG.info().$("updating column type IDs [table=").$(migrationContext.getTablePath()).I$();
        FilesFacade ff = migrationContext.getFf();
        Path path = migrationContext.getTablePath();
        path.concat("_meta");
        if (!ff.exists(path.$())) {
            MigrationActions.LOG.error().$("meta file does not exist, nothing to migrate [path=").$(path).I$();
            return;
        }
        try (MemoryMARW rwMem = migrationContext.getRwMemory();){
            rwMem.of(ff, path.$(), ff.getPageSize(), ff.length(path.$()), 44);
            int columnCount = rwMem.getInt(0L);
            long offset = 128L;
            for (int i = 0; i < columnCount; ++i) {
                byte oldTypeId = rwMem.getByte(offset);
                long oldFlags = rwMem.getLong(offset + 1L);
                int blockCapacity = rwMem.getInt(offset + 1L + 8L);
                rwMem.putInt(offset, oldTypeId == 13 ? 18 : oldTypeId + 1);
                rwMem.putLong(offset + 4L, oldFlags);
                rwMem.putInt(offset + 4L + 8L, blockCapacity);
                offset += 16L;
            }
        }
    }
}

