/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.file.AppendableBlock;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cairo.file.ReadableBlock;
import io.questdb.cairo.vm.Vm;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatViewDefinition
implements Mutable {
    public static final String MAT_VIEW_DEFINITION_FILE_NAME = "_mv";
    public static final int MAT_VIEW_DEFINITION_FORMAT_EXTRA_MSG_TYPE = 1;
    public static final int MAT_VIEW_DEFINITION_FORMAT_MSG_TYPE = 0;
    public static final int REFRESH_TYPE_IMMEDIATE = 0;
    public static final int REFRESH_TYPE_MANUAL = 2;
    public static final int REFRESH_TYPE_TIMER = 1;
    private static final Log LOG = LogFactory.getLog(MatViewDefinition.class);
    private String baseTableName;
    private boolean deferred;
    private long fixedOffset;
    private String matViewSql;
    private volatile TableToken matViewToken;
    private int periodDelay;
    private char periodDelayUnit;
    private int periodLength;
    private char periodLengthUnit;
    private TimestampSampler periodSampler;
    private int refreshLimitHoursOrMonths;
    private int refreshType = -1;
    @Nullable
    private TimeZoneRules rules;
    private long samplingInterval;
    private char samplingIntervalUnit;
    @Nullable
    private String timeZone;
    @Nullable
    private String timeZoneOffset;
    private int timerInterval;
    @Nullable
    private TimeZoneRules timerRules;
    private long timerStart = Long.MIN_VALUE;
    @Nullable
    private String timerTimeZone;
    private char timerUnit;
    private TimestampSampler timestampSampler;

    public static void append(@NotNull MatViewDefinition matViewDefinition, @NotNull AppendableBlock block) {
        int refreshTypeRaw = MatViewDefinition.encodeRefreshTypeAndDeferred(matViewDefinition.refreshType, matViewDefinition.deferred);
        block.putInt(refreshTypeRaw);
        block.putStr(matViewDefinition.baseTableName);
        block.putLong(matViewDefinition.samplingInterval);
        block.putChar(matViewDefinition.samplingIntervalUnit);
        block.putStr(matViewDefinition.timeZone);
        block.putStr(matViewDefinition.timeZoneOffset);
        block.putStr(matViewDefinition.matViewSql);
    }

    public static void append(@NotNull MatViewDefinition matViewDefinition, @NotNull BlockFileWriter writer) {
        AppendableBlock block = writer.append();
        MatViewDefinition.append(matViewDefinition, block);
        block.commit(0);
        block = writer.append();
        MatViewDefinition.appendExtra(matViewDefinition, block);
        block.commit(1);
        writer.commit();
    }

    public static void appendExtra(@NotNull MatViewDefinition matViewDefinition, @NotNull AppendableBlock block) {
        block.putInt(matViewDefinition.refreshLimitHoursOrMonths);
        block.putInt(matViewDefinition.timerInterval);
        block.putChar(matViewDefinition.timerUnit);
        block.putLong(matViewDefinition.timerStart);
        block.putStr(matViewDefinition.timerTimeZone);
        block.putInt(matViewDefinition.periodLength);
        block.putChar(matViewDefinition.periodLengthUnit);
        block.putInt(matViewDefinition.periodDelay);
        block.putChar(matViewDefinition.periodDelayUnit);
    }

    public static void readFrom(@NotNull MatViewDefinition destDefinition, @NotNull BlockFileReader reader, @NotNull Path path, int rootLen, @NotNull TableToken viewToken) {
        path.trimTo(rootLen).concat(viewToken.getDirName()).concat(MAT_VIEW_DEFINITION_FILE_NAME);
        reader.of(path.$());
        boolean definitionBlockFound = false;
        BlockFileReader.BlockCursor cursor = reader.getCursor();
        while (cursor.hasNext()) {
            ReadableBlock block = cursor.next();
            if (block.type() == 0) {
                definitionBlockFound = true;
                MatViewDefinition.readDefinitionBlock(destDefinition, block, viewToken);
                continue;
            }
            if (block.type() != 1) continue;
            MatViewDefinition.readExtraBlock(destDefinition, block);
            return;
        }
        if (!definitionBlockFound) {
            throw CairoException.critical(0).put("cannot read materialized view definition, block not found [path=").put(path).put(']');
        }
        if (destDefinition.refreshType == 1 && destDefinition.timerInterval == 0) {
            LOG.error().$("cannot find timer interval value, falling back to manual refresh [view=").$(viewToken).I$();
            destDefinition.refreshType = 2;
        }
    }

    @Override
    public void clear() {
        this.matViewToken = null;
        this.baseTableName = null;
        this.matViewSql = null;
        this.rules = null;
        this.timeZone = null;
        this.timeZoneOffset = null;
        this.timestampSampler = null;
        this.fixedOffset = 0L;
        this.refreshType = -1;
        this.deferred = false;
        this.samplingInterval = 0L;
        this.samplingIntervalUnit = '\u0000';
        this.refreshLimitHoursOrMonths = 0;
        this.timerInterval = 0;
        this.timerUnit = '\u0000';
        this.timerStart = Long.MIN_VALUE;
        this.timerTimeZone = null;
        this.timerRules = null;
        this.periodLength = 0;
        this.periodLengthUnit = '\u0000';
        this.periodDelay = 0;
        this.periodDelayUnit = '\u0000';
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public long getFixedOffset() {
        return this.fixedOffset;
    }

    public String getMatViewSql() {
        return this.matViewSql;
    }

    public TableToken getMatViewToken() {
        return this.matViewToken;
    }

    public int getPeriodDelay() {
        return this.periodDelay;
    }

    public char getPeriodDelayUnit() {
        return this.periodDelayUnit;
    }

    public int getPeriodLength() {
        return this.periodLength;
    }

    public char getPeriodLengthUnit() {
        return this.periodLengthUnit;
    }

    public TimestampSampler getPeriodSampler() {
        return this.periodSampler;
    }

    public int getRefreshLimitHoursOrMonths() {
        return this.refreshLimitHoursOrMonths;
    }

    public int getRefreshType() {
        return this.refreshType;
    }

    public long getSamplingInterval() {
        return this.samplingInterval;
    }

    public char getSamplingIntervalUnit() {
        return this.samplingIntervalUnit;
    }

    @Nullable
    public String getTimeZone() {
        return this.timeZone;
    }

    @Nullable
    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public int getTimerInterval() {
        return this.timerInterval;
    }

    public long getTimerStart() {
        return this.timerStart;
    }

    @Nullable
    public String getTimerTimeZone() {
        return this.timerTimeZone;
    }

    @Nullable
    public TimeZoneRules getTimerTzRules() {
        return this.timerRules;
    }

    public char getTimerUnit() {
        return this.timerUnit;
    }

    public TimestampSampler getTimestampSampler() {
        return this.timestampSampler;
    }

    @Nullable
    public TimeZoneRules getTzRules() {
        return this.rules;
    }

    public void init(int refreshType, boolean deferred, @NotNull TableToken matViewToken, @NotNull String matViewSql, @NotNull String baseTableName, long samplingInterval, char samplingIntervalUnit, @Nullable String timeZone, @Nullable String timeZoneOffset, int refreshLimitHoursOrMonths, int timerInterval, char timerUnit, long timerStart, @Nullable String timerTimeZone, int periodLength, char periodLengthUnit, int periodDelay, char periodDelayUnit) {
        this.initDefinition(refreshType, deferred, matViewToken, matViewSql, baseTableName, samplingInterval, samplingIntervalUnit, timeZone, timeZoneOffset);
        this.initDefinitionExtra(refreshLimitHoursOrMonths, timerInterval, timerUnit, timerStart, timerTimeZone, periodLength, periodLengthUnit, periodDelay, periodDelayUnit);
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public void setPeriodSampler(TimestampSampler periodSampler) {
        this.periodSampler = periodSampler;
    }

    public MatViewDefinition updateRefreshLimit(int refreshLimitHoursOrMonths) {
        MatViewDefinition newDefinition = new MatViewDefinition();
        newDefinition.init(this.refreshType, this.deferred, this.matViewToken, this.matViewSql, this.baseTableName, this.samplingInterval, this.samplingIntervalUnit, this.timeZone, this.timeZoneOffset, refreshLimitHoursOrMonths, this.timerInterval, this.timerUnit, this.timerStart, this.timerTimeZone, this.periodLength, this.periodLengthUnit, this.periodDelay, this.periodDelayUnit);
        return newDefinition;
    }

    public MatViewDefinition updateRefreshParams(int refreshType, int timerInterval, char timerUnit, long timerStart, @Nullable CharSequence timerTimeZone, int periodLength, char periodLengthUnit, int periodDelay, char periodDelayUnit) {
        MatViewDefinition newDefinition = new MatViewDefinition();
        newDefinition.init(refreshType, this.deferred, this.matViewToken, this.matViewSql, this.baseTableName, this.samplingInterval, this.samplingIntervalUnit, this.timeZone, this.timeZoneOffset, this.refreshLimitHoursOrMonths, timerInterval, timerUnit, timerStart, Chars.toString(timerTimeZone), periodLength, periodLengthUnit, periodDelay, periodDelayUnit);
        return newDefinition;
    }

    public MatViewDefinition updateTimer(int timerInterval, char timerUnit, long timerStart) {
        MatViewDefinition newDefinition = new MatViewDefinition();
        newDefinition.init(this.refreshType, this.deferred, this.matViewToken, this.matViewSql, this.baseTableName, this.samplingInterval, this.samplingIntervalUnit, this.timeZone, this.timeZoneOffset, this.refreshLimitHoursOrMonths, timerInterval, timerUnit, timerStart, this.timerTimeZone, this.periodLength, this.periodLengthUnit, this.periodDelay, this.periodDelayUnit);
        return newDefinition;
    }

    public void updateToken(TableToken updatedToken) {
        this.matViewToken = updatedToken;
    }

    private static boolean decodeDeferred(int refreshTypeRaw) {
        return refreshTypeRaw < 0;
    }

    private static int decodeRefreshType(int refreshTypeRaw) {
        return refreshTypeRaw < 0 ? Math.abs(refreshTypeRaw + 1) : refreshTypeRaw;
    }

    private static int encodeRefreshTypeAndDeferred(int refreshType, boolean deferred) {
        return deferred ? -(refreshType + 1) : refreshType;
    }

    private static void readDefinitionBlock(MatViewDefinition destDefinition, ReadableBlock block, TableToken matViewToken) {
        assert (block.type() == 0);
        long offset = 0L;
        int refreshTypeRaw = block.getInt(offset);
        boolean deferred = MatViewDefinition.decodeDeferred(refreshTypeRaw);
        int refreshType = MatViewDefinition.decodeRefreshType(refreshTypeRaw);
        if (refreshType != 0 && refreshType != 1 && refreshType != 2) {
            throw CairoException.critical(0).put("unsupported refresh type [view=").put(matViewToken.getTableName()).put(", type=").put(refreshType).put(']');
        }
        CharSequence baseTableName = block.getStr(offset += 4L);
        if (baseTableName == null || baseTableName.length() == 0) {
            throw CairoException.critical(0).put("base table name for materialized view is empty [view=").put(matViewToken.getTableName()).put(']');
        }
        String baseTableNameStr = Chars.toString(baseTableName);
        long samplingInterval = block.getLong(offset += (long)Vm.getStorageLength(baseTableName));
        char samplingIntervalUnit = block.getChar(offset += 8L);
        CharSequence timeZone = block.getStr(offset += 2L);
        String timeZoneStr = Chars.toString(timeZone);
        CharSequence timeZoneOffset = block.getStr(offset += (long)Vm.getStorageLength(timeZone));
        String timeZoneOffsetStr = Chars.toString(timeZoneOffset);
        CharSequence matViewSql = block.getStr(offset += (long)Vm.getStorageLength(timeZoneOffset));
        if (matViewSql == null || matViewSql.length() == 0) {
            throw CairoException.critical(0).put("materialized view SQL is empty [view=").put(matViewToken.getTableName()).put(']');
        }
        destDefinition.initDefinition(refreshType, deferred, matViewToken, Chars.toString(matViewSql), baseTableNameStr, samplingInterval, samplingIntervalUnit, timeZoneStr, timeZoneOffsetStr);
    }

    private static void readExtraBlock(MatViewDefinition destDefinition, ReadableBlock block) {
        assert (block.type() == 1);
        long offset = 0L;
        int refreshLimitHoursOrMonths = block.getInt(offset);
        int timerInterval = block.getInt(offset += 4L);
        char timerUnit = block.getChar(offset += 4L);
        long timerStart = block.getLong(offset += 2L);
        CharSequence timerTimeZone = block.getStr(offset += 8L);
        int periodLength = block.getInt(offset += (long)Vm.getStorageLength(timerTimeZone));
        char periodLengthUnit = block.getChar(offset += 4L);
        int periodDelay = block.getInt(offset += 2L);
        char periodDelayUnit = block.getChar(offset += 4L);
        destDefinition.initDefinitionExtra(refreshLimitHoursOrMonths, timerInterval, timerUnit, timerStart, Chars.toString(timerTimeZone), periodLength, periodLengthUnit, periodDelay, periodDelayUnit);
    }

    private void initDefinition(int refreshType, boolean deferred, @NotNull TableToken matViewToken, @NotNull String matViewSql, @NotNull String baseTableName, long samplingInterval, char samplingIntervalUnit, @Nullable String timeZone, @Nullable String timeZoneOffset) {
        this.refreshType = refreshType;
        this.deferred = deferred;
        this.matViewToken = matViewToken;
        this.matViewSql = matViewSql;
        this.baseTableName = baseTableName;
        this.samplingInterval = samplingInterval;
        this.samplingIntervalUnit = samplingIntervalUnit;
        this.timeZone = timeZone;
        this.timeZoneOffset = timeZoneOffset;
        try {
            this.timestampSampler = TimestampSamplerFactory.getInstance(samplingInterval, samplingIntervalUnit, 0);
        }
        catch (SqlException e) {
            throw CairoException.critical(0).put("invalid sampling interval and/or unit: ").put(samplingInterval).put(", ").put(samplingIntervalUnit);
        }
        if (timeZone != null) {
            try {
                this.rules = Timestamps.getTimezoneRules(TimestampFormatUtils.EN_LOCALE, timeZone);
            }
            catch (NumericException e) {
                throw CairoException.critical(0).put("invalid timezone: ").put(timeZone);
            }
        } else {
            this.rules = null;
        }
        if (timeZoneOffset != null) {
            long val = Timestamps.parseOffset(timeZoneOffset);
            if (val == Long.MIN_VALUE) {
                throw CairoException.critical(0).put("invalid offset: ").put(timeZoneOffset);
            }
            this.fixedOffset = (long)Numbers.decodeLowInt(val) * 60000000L;
        } else {
            this.fixedOffset = 0L;
        }
    }

    private void initDefinitionExtra(int refreshLimitHoursOrMonths, int timerInterval, char timerUnit, long timerStart, @Nullable String timerTimeZone, int periodLength, char periodLengthUnit, int periodDelay, char periodDelayUnit) {
        this.refreshLimitHoursOrMonths = refreshLimitHoursOrMonths;
        this.timerInterval = timerInterval;
        this.timerUnit = timerUnit;
        this.timerStart = timerStart;
        this.timerTimeZone = timerTimeZone;
        this.periodLength = periodLength;
        this.periodLengthUnit = periodLengthUnit;
        this.periodDelay = periodDelay;
        this.periodDelayUnit = periodDelayUnit;
        if (timerTimeZone != null) {
            try {
                this.timerRules = Timestamps.getTimezoneRules(TimestampFormatUtils.EN_LOCALE, timerTimeZone);
            }
            catch (NumericException e) {
                throw CairoException.critical(0).put("invalid timer timezone: ").put(timerTimeZone);
            }
        } else {
            this.timerRules = null;
        }
    }
}

