/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.array;

import io.questdb.cutlass.line.array.AbstractArray;
import io.questdb.std.Unsafe;

public class LongArray
extends AbstractArray {
    public LongArray(int ... shape) {
        super(shape, (short)6);
    }

    public LongArray append(long value) {
        this.ensureLegalAppendPosition();
        this.memA.putLong(value);
        return this;
    }

    public LongArray set(long value, int ... coords) {
        assert (!this.closed);
        this.array.putLong(this.toFlatOffset(coords), value);
        return this;
    }

    public LongArray setAll(long value) {
        long ptr = this.array.ptr();
        int size = this.array.getFlatViewLength();
        for (int i = 0; i < size; ++i) {
            Unsafe.getUnsafe().putLong(ptr, value);
            ptr += 8L;
        }
        return this;
    }
}

