/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;

public class PgAttrDefFunctionFactory
implements FunctionFactory {
    static final RecordMetadata METADATA;
    private static final Log LOG;
    private static final String SIGNATURE = "pg_attrdef()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new AttrDefCatalogueCursorFactory(configuration, METADATA)){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        LOG = LogFactory.getLog(PgAttrDefFunctionFactory.class);
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("adrelid", 5));
        metadata.add(new TableColumnMetadata("adnum", 3));
        metadata.add(new TableColumnMetadata("adbin", 11));
        METADATA = metadata;
    }

    private static class AttrDefCatalogueCursorFactory
    extends AbstractRecordCursorFactory {
        private final AttrDefCatalogueCursor cursor;
        private final Path path;
        private long tempMem;

        public AttrDefCatalogueCursorFactory(CairoConfiguration configuration, RecordMetadata metadata) {
            super(metadata);
            try {
                this.path = new Path();
                this.tempMem = Unsafe.malloc(4L, 31);
                this.cursor = new AttrDefCatalogueCursor(configuration, this.path, this.tempMem);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type(PgAttrDefFunctionFactory.SIGNATURE);
        }

        @Override
        protected void _close() {
            Misc.free(this.path);
            this.tempMem = Unsafe.free(this.tempMem, 4L, 31);
        }
    }

    private static class AttrDefCatalogueCursor
    implements NoRandomAccessRecordCursor {
        private final DiskReadingRecord diskReadingRecord = new DiskReadingRecord();
        private final FilesFacade ff;
        private final Path path;
        private final int plimit;
        private final long tempMem;
        private int columnCount;
        private int columnIndex = 0;
        private long findFileStruct = 0L;
        private boolean foundMetadataFile = false;
        private boolean hasNextFile = true;
        private boolean readNextFileFromDisk = true;
        private int tableId = -1;

        public AttrDefCatalogueCursor(CairoConfiguration configuration, Path path, long tempMem) {
            this.ff = configuration.getFilesFacade();
            this.path = path;
            this.path.of(configuration.getDbRoot()).$();
            this.plimit = path.size();
            this.tempMem = tempMem;
        }

        @Override
        public void close() {
            this.findFileStruct = this.ff.findClose(this.findFileStruct);
        }

        @Override
        public Record getRecord() {
            return this.diskReadingRecord;
        }

        @Override
        public boolean hasNext() {
            if (this.findFileStruct == 0L) {
                this.findFileStruct = this.ff.findFirst(this.path.trimTo(this.plimit).$());
                if (this.findFileStruct > 0L) {
                    return this.next0();
                }
                this.findFileStruct = 0L;
                return false;
            }
            return this.next0();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.findFileStruct = this.ff.findClose(this.findFileStruct);
        }

        private boolean next0() {
            do {
                if (this.readNextFileFromDisk) {
                    this.foundMetadataFile = false;
                    long pUtf8NameZ = this.ff.findName(this.findFileStruct);
                    if (this.hasNextFile) {
                        if (this.ff.isDirOrSoftLinkDirNoDots(this.path, this.plimit, pUtf8NameZ, this.ff.findType(this.findFileStruct)) && this.ff.exists(this.path.concat("_meta").$())) {
                            long fd = this.ff.openRO(this.path.$());
                            if (fd > -1L) {
                                if (this.ff.read(fd, this.tempMem, 4L, 16L) == 4L) {
                                    this.tableId = Unsafe.getUnsafe().getInt(this.tempMem);
                                    if (this.ff.read(fd, this.tempMem, 4L, 0L) == 4L) {
                                        this.foundMetadataFile = true;
                                        this.columnCount = Unsafe.getUnsafe().getInt(this.tempMem);
                                    } else {
                                        LOG.error().$("Could not read column count [fd=").$(fd).$(", errno=").$(this.ff.errno()).I$();
                                    }
                                } else {
                                    LOG.error().$("Could not read table id [fd=").$(fd).$(", errno=").$(this.ff.errno()).I$();
                                }
                                this.ff.close(fd);
                            } else {
                                LOG.error().$("could not read metadata [file=").$(this.path).I$();
                            }
                        }
                        boolean bl = this.hasNextFile = this.ff.findNext(this.findFileStruct) > 0;
                    }
                }
                if (!this.foundMetadataFile) continue;
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.columnIndex != i) continue;
                    this.diskReadingRecord.columnNumber = (short)(i + 1);
                    ++this.columnIndex;
                    if (this.columnIndex == this.columnCount) {
                        this.readNextFileFromDisk = true;
                        this.columnIndex = 0;
                    } else {
                        this.readNextFileFromDisk = false;
                    }
                    return true;
                }
            } while (this.hasNextFile);
            this.findFileStruct = this.ff.findClose(this.findFileStruct);
            this.hasNextFile = true;
            this.foundMetadataFile = false;
            this.tableId = -1;
            return false;
        }

        private class DiskReadingRecord
        implements Record {
            public short columnNumber = 0;

            private DiskReadingRecord() {
            }

            @Override
            public int getInt(int col) {
                return AttrDefCatalogueCursor.this.tableId;
            }

            @Override
            public short getShort(int col) {
                return this.columnNumber;
            }

            @Override
            public CharSequence getStrA(int col) {
                return "";
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return this.getStrA(col).length();
            }
        }
    }
}

