/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.LeadLagWindowFunctionFactoryHelper;
import io.questdb.griffin.engine.functions.window.WindowTimestampFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class LagTimestampFunctionFactory
extends AbstractWindowFunctionFactory {
    private static final String SIGNATURE = "lag(NV)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return LeadLagWindowFunctionFactoryHelper.newInstance(position, args, argPositions, configuration, sqlExecutionContext, defaultValue -> {
            if (!ColumnType.isAssignableFrom(defaultValue.getType(), 8)) {
                throw SqlException.$(argPositions.getQuick(2), "default value must be can cast to timestamp");
            }
        }, LagFunction::new, LeadLagValueCurrentRow::new, LagOverPartitionFunction::new);
    }

    static class LeadLagValueCurrentRow
    extends LeadLagWindowFunctionFactoryHelper.BaseLeadLagCurrentRow
    implements WindowTimestampFunction {
        private long value;

        public LeadLagValueCurrentRow(VirtualRecord partitionByRecord, Function arg, String name, boolean ignoreNulls) {
            super(partitionByRecord, arg, name, ignoreNulls);
        }

        @Override
        public void computeNext(Record record) {
            this.value = this.arg.getTimestamp(record);
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.value;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }
    }

    static class LagOverPartitionFunction
    extends LeadLagWindowFunctionFactoryHelper.BaseLagOverPartitionFunction
    implements WindowTimestampFunction {
        private long lagValue;

        public LagOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, MemoryARW memory, Function arg, boolean ignoreNulls, Function defaultValue, long offset) {
            super(map, partitionByRecord, partitionBySink, memory, arg, ignoreNulls, defaultValue, offset);
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.lagValue;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.lagValue);
        }

        @Override
        protected boolean computeNext0(long count, long offset, long startOffset, long firstIdx, Record record) {
            boolean respectNulls;
            long l = this.arg.getTimestamp(record);
            this.lagValue = count < offset ? (this.defaultValue == null ? Long.MIN_VALUE : this.defaultValue.getTimestamp(record)) : this.memory.getLong(startOffset + firstIdx * 8L);
            boolean bl = respectNulls = !this.ignoreNulls || Long.MIN_VALUE != l;
            if (respectNulls) {
                this.memory.putLong(startOffset + firstIdx * 8L, l);
            }
            return respectNulls;
        }
    }

    public static class LagFunction
    extends LeadLagWindowFunctionFactoryHelper.BaseLagFunction
    implements WindowTimestampFunction {
        private long lagValue;

        public LagFunction(Function arg, Function defaultValueFunc, long offset, MemoryARW memory, boolean ignoreNulls) {
            super(arg, defaultValueFunc, offset, memory, ignoreNulls);
        }

        @Override
        public boolean computeNext0(Record record) {
            boolean respectNulls;
            this.lagValue = this.count < this.offset ? (this.defaultValue == null ? Long.MIN_VALUE : this.defaultValue.getTimestamp(record)) : this.buffer.getLong((long)this.loIdx * 8L);
            long l = this.arg.getTimestamp(record);
            boolean bl = respectNulls = !this.ignoreNulls || l != Long.MIN_VALUE;
            if (respectNulls) {
                this.buffer.putLong((long)this.loIdx * 8L, l);
            }
            return respectNulls;
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.lagValue;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.lagValue);
        }
    }
}

