/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class HashOuterJoinFilteredRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final HashOuterJoinRecordCursor cursor;
    private final Function filter;
    private final RecordSink masterSink;
    private final RecordSink slaveKeySink;

    public HashOuterJoinFilteredRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterSink, RecordSink slaveKeySink, RecordSink slaveChainSink, int columnSplit, @NotNull Function filter, JoinContext joinContext) {
        super(metadata, joinContext, masterFactory, slaveFactory);
        RecordChain slaveChain = null;
        Map joinKeyMap = null;
        try {
            slaveChain = new RecordChain(slaveFactory.getMetadata(), slaveChainSink, configuration.getSqlHashJoinValuePageSize(), configuration.getSqlHashJoinValueMaxPages());
            this.masterSink = masterSink;
            this.slaveKeySink = slaveKeySink;
            joinKeyMap = MapFactory.createUnorderedMap(configuration, joinColumnTypes, valueTypes);
            this.cursor = new HashOuterJoinRecordCursor(columnSplit, joinKeyMap, slaveChain, NullRecordFactory.getInstance(slaveFactory.getMetadata()));
            this.filter = filter;
        }
        catch (Throwable th) {
            Misc.free(slaveChain);
            Misc.free(joinKeyMap);
            this.close();
            throw th;
        }
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        RecordCursor masterCursor = null;
        try {
            masterCursor = this.masterFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Hash Outer Join");
        sink.optAttr((CharSequence)"condition", this.joinContext);
        sink.attr("filter").val(this.filter);
        sink.child(this.masterFactory);
        sink.child("Hash", this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.cursor);
        Misc.free(this.filter);
    }

    private class HashOuterJoinRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final OuterJoinRecord record;
        private final RecordChain slaveChain;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isMapBuilt;
        private boolean isOpen;
        private Record masterRecord;
        private boolean useSlaveCursor;

        public HashOuterJoinRecordCursor(int columnSplit, Map joinKeyMap, RecordChain slaveChain, Record nullRecord) {
            super(columnSplit);
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.joinKeyMap = joinKeyMap;
            this.slaveChain = slaveChain;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (!this.isMapBuilt) {
                TableUtils.populateRecordHashMap(this.circuitBreaker, this.slaveCursor, this.joinKeyMap, HashOuterJoinFilteredRecordCursorFactory.this.slaveKeySink, this.slaveChain);
                this.isMapBuilt = true;
            }
            if (this.useSlaveCursor && this.slaveChain.hasNext()) {
                this.record.hasSlave(true);
                do {
                    if (!HashOuterJoinFilteredRecordCursorFactory.this.filter.getBool(this.record)) continue;
                    return true;
                } while (this.slaveChain.hasNext());
            }
            if (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashOuterJoinFilteredRecordCursorFactory.this.masterSink);
                MapValue value = key.findValue();
                if (value != null) {
                    this.slaveChain.of(value.getInt(0));
                    this.useSlaveCursor = true;
                    this.record.hasSlave(true);
                    while (this.slaveChain.hasNext()) {
                        if (!HashOuterJoinFilteredRecordCursorFactory.this.filter.getBool(this.record)) continue;
                        return true;
                    }
                }
                this.useSlaveCursor = false;
                this.record.hasSlave(false);
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return this.isMapBuilt ? 1L : 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.useSlaveCursor = false;
            HashOuterJoinFilteredRecordCursorFactory.this.filter.toTop();
            if (!this.isMapBuilt) {
                this.slaveCursor.toTop();
                this.joinKeyMap.clear();
                this.slaveChain.clear();
            }
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionContext executionContext) throws SqlException {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
                this.slaveChain.reopen();
            }
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.circuitBreaker = executionContext.getCircuitBreaker();
            this.masterRecord = masterCursor.getRecord();
            Record slaveRecord = this.slaveChain.getRecord();
            this.record.of(this.masterRecord, slaveRecord);
            this.slaveChain.setSymbolTableResolver(slaveCursor);
            this.useSlaveCursor = false;
            this.isMapBuilt = false;
            HashOuterJoinFilteredRecordCursorFactory.this.filter.init(this, executionContext);
        }
    }
}

