/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.griffin.engine.join.SymbolShortCircuit;
import io.questdb.std.CompactIntHashSet;

public final class SingleSymbolSymbolShortCircuit
implements SymbolShortCircuit {
    private final CairoConfiguration config;
    private final CompactIntHashSet masterKeysExistingInSlaveCache = new CompactIntHashSet(16, 0.4);
    private final int masterSymbolIndex;
    private final int slaveSymbolIndex;
    private int maxCacheSize = 0;
    private StaticSymbolTable slaveSymbolTable;

    public SingleSymbolSymbolShortCircuit(CairoConfiguration config, int masterSymbolIndex, int slaveSymbolIndex) {
        this.masterSymbolIndex = masterSymbolIndex;
        this.slaveSymbolIndex = slaveSymbolIndex;
        this.config = config;
    }

    @Override
    public boolean isShortCircuit(Record masterRecord) {
        assert (this.slaveSymbolTable != null) : "slaveSymbolTable must be set before calling isShortCircuit";
        int masterKey = masterRecord.getInt(this.masterSymbolIndex);
        if (!this.masterKeysExistingInSlaveCache.excludes(masterKey)) {
            return false;
        }
        if (masterKey == Integer.MIN_VALUE) {
            if (this.slaveSymbolTable.containsNullValue()) {
                this.masterKeysExistingInSlaveCache.add(masterKey);
                return false;
            }
            return true;
        }
        CharSequence strSym = masterRecord.getSymA(this.masterSymbolIndex);
        if (this.slaveSymbolTable.keyOf(strSym) == -2) {
            return true;
        }
        if (this.masterKeysExistingInSlaveCache.size() < this.maxCacheSize) {
            this.masterKeysExistingInSlaveCache.add(masterKey);
        }
        return false;
    }

    @Override
    public void of(TimeFrameRecordCursor slaveCursor) {
        this.slaveSymbolTable = slaveCursor.getSymbolTable(this.slaveSymbolIndex);
        this.masterKeysExistingInSlaveCache.clear();
        this.maxCacheSize = this.config.getSqlAsOfJoinShortCircuitCacheCapacity();
    }
}

