/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.TableToken;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlterOperationBuilder
implements Mutable {
    private final LongList extraInfo = new LongList();
    private final ObjList<CharSequence> extraStrInfo = new ObjList();
    private final AlterOperation op = new AlterOperation(this.extraInfo, this.extraStrInfo);
    private short command;
    private int tableId = -1;
    private int tableNamePosition = -1;
    private TableToken tableToken;

    public void addColumnToList(CharSequence columnName, int columnNamePosition, int type, int symbolCapacity, boolean cache, boolean indexed, int indexValueBlockCapacity, boolean dedupKey) {
        assert (columnName != null && columnName.length() > 0);
        this.extraStrInfo.add(columnName);
        this.extraInfo.add(type);
        this.extraInfo.add(symbolCapacity);
        this.extraInfo.add(cache ? 1L : -1L);
        this.extraInfo.add(AlterOperation.getFlags(indexed, dedupKey));
        this.extraInfo.add(indexValueBlockCapacity);
        this.extraInfo.add(columnNamePosition);
    }

    public void addPartitionToList(long timestamp, int timestampPosition) {
        this.extraInfo.add(timestamp);
        if (this.command != 20) {
            this.extraInfo.add(timestampPosition);
        }
    }

    public AlterOperation build() {
        return this.op.of(this.command, this.tableToken, this.tableId, this.tableNamePosition);
    }

    @Override
    public void clear() {
        this.op.clear();
        this.extraStrInfo.clear();
        this.extraInfo.clear();
        this.command = 0;
        this.tableToken = null;
        this.tableId = -1;
        this.tableNamePosition = -1;
    }

    public ObjList<CharSequence> getExtraStrInfo() {
        return this.extraStrInfo;
    }

    public AlterOperationBuilder ofAddColumn(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = 1;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public void ofAddColumn(CharSequence columnName, int columnNamePosition, int type, int symbolCapacity, boolean cache, boolean indexed, int indexValueBlockCapacity) {
        assert (columnName != null && columnName.length() > 0);
        this.extraStrInfo.add(columnName);
        this.extraInfo.add(type);
        this.extraInfo.add(symbolCapacity);
        this.extraInfo.add(cache ? 1L : -1L);
        this.extraInfo.add(AlterOperation.getFlags(indexed, false));
        this.extraInfo.add(indexValueBlockCapacity);
        this.extraInfo.add(columnNamePosition);
    }

    public void ofAddIndex(int tableNamePosition, TableToken tableToken, int tableId, CharSequence columnName, int indexValueBlockSize) {
        this.command = (short)4;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.extraStrInfo.add(columnName);
        this.extraInfo.add(indexValueBlockSize);
    }

    public AlterOperationBuilder ofAttachPartition(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)3;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public void ofCacheSymbol(int tableNamePosition, TableToken tableToken, int tableId, CharSequence columnName) {
        this.command = (short)6;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.extraStrInfo.add(columnName);
    }

    public AlterOperationBuilder ofColumnChangeType(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)17;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofConvertPartition(int tableNamePosition, TableToken tableToken, int tableId, boolean toParquet) {
        this.command = (short)(toParquet ? 18 : 19);
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofDedupDisable(int tableNamePosition, TableToken tableToken) {
        this.command = (short)16;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableToken.getTableId();
        return this;
    }

    public AlterOperationBuilder ofDedupEnable(int tableNamePosition, TableToken tableToken) {
        this.command = (short)15;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableToken.getTableId();
        return this;
    }

    public AlterOperationBuilder ofDetachPartition(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)12;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofDropColumn(CharSequence columnName) {
        assert (columnName != null && columnName.length() > 0);
        this.extraStrInfo.add(columnName);
        return this;
    }

    public AlterOperationBuilder ofDropColumn(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)8;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public void ofDropIndex(int tableNamePosition, TableToken tableToken, int tableId, CharSequence columnName, int columnNamePosition) {
        this.command = (short)5;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.extraStrInfo.add(columnName);
        this.extraInfo.add(columnNamePosition);
    }

    public AlterOperationBuilder ofDropPartition(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)2;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofForceDropPartition(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)20;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public void ofRemoveCacheSymbol(int tableNamePosition, TableToken tableToken, int tableId, CharSequence columnName) {
        assert (columnName != null && columnName.length() > 0);
        this.command = (short)7;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.extraStrInfo.add(columnName);
    }

    public AlterOperationBuilder ofRenameColumn(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)9;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public void ofRenameColumn(CharSequence columnName, CharSequence newName) {
        this.extraStrInfo.add(columnName);
        this.extraStrInfo.add(newName);
    }

    public AlterOperationBuilder ofSetMatViewRefresh(int matViewNamePosition, @NotNull TableToken matViewToken, int tableId, int refreshType, int timerInterval, char timerUnit, long timerStart, @Nullable CharSequence timerTimeZone, int periodLength, char periodLengthUnit, int periodDelay, char periodDelayUnit) {
        this.command = (short)25;
        this.tableNamePosition = matViewNamePosition;
        this.tableToken = matViewToken;
        this.extraInfo.add(refreshType);
        this.extraInfo.add(timerInterval);
        this.extraInfo.add(timerUnit);
        this.extraInfo.add(timerStart);
        this.extraInfo.add(periodLength);
        this.extraInfo.add(periodLengthUnit);
        this.extraInfo.add(periodDelay);
        this.extraInfo.add(periodDelayUnit);
        this.extraStrInfo.add(timerTimeZone);
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofSetMatViewRefreshLimit(int matViewNamePosition, TableToken matViewToken, int tableId, int limitHoursOrMonths) {
        this.command = (short)23;
        this.tableNamePosition = matViewNamePosition;
        this.tableToken = matViewToken;
        this.extraInfo.add(limitHoursOrMonths);
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofSetO3MaxLag(int tableNamePosition, TableToken tableToken, int tableId, long o3MaxLag) {
        this.command = (short)11;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.extraInfo.add(o3MaxLag);
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofSetParamUncommittedRows(int tableNamePosition, TableToken tableToken, int tableId, int maxUncommittedRows) {
        this.command = (short)10;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.extraInfo.add(maxUncommittedRows);
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofSetTtl(int tableNamePosition, TableToken tableToken, int tableId, int ttlHoursOrMonths) {
        this.command = (short)21;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.extraInfo.add(ttlHoursOrMonths);
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofSquashPartitions(int tableNamePosition, TableToken tableToken) {
        this.command = (short)13;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableToken.getTableId();
        return this;
    }

    public AlterOperationBuilder ofSymbolCapacityChange(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)22;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public void setDedupKeyFlag(int writerColumnIndex) {
        this.extraInfo.add(writerColumnIndex);
    }
}

