/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.engine.AbstractRedBlackTree;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.std.Unsafe;

public class LongTreeChain
extends AbstractRedBlackTree
implements Reopenable {
    private static final long CHAIN_VALUE_SIZE = 12L;
    private static final long MAX_VALUE_HEAP_SIZE_LIMIT = Integer.toUnsignedLong(-1) - 1L << 2;
    private final TreeCursor cursor = new TreeCursor();
    private final long initialValueHeapSize;
    private final long maxValueHeapSize;
    private long valueHeapLimit;
    private long valueHeapPos;
    private long valueHeapSize;
    private long valueHeapStart;

    public LongTreeChain(long keyPageSize, int keyMaxPages, long valuePageSize, int valueMaxPages) {
        super(keyPageSize, keyMaxPages);
        try {
            this.valueHeapSize = this.initialValueHeapSize = valuePageSize;
            this.valueHeapStart = this.valueHeapPos = Unsafe.malloc(this.valueHeapSize, 59);
            this.valueHeapLimit = this.valueHeapStart + this.valueHeapSize;
            this.maxValueHeapSize = Math.min(valuePageSize * (long)valueMaxPages, MAX_VALUE_HEAP_SIZE_LIMIT);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.valueHeapPos = this.valueHeapStart;
    }

    @Override
    public void close() {
        super.close();
        this.cursor.clear();
        if (this.valueHeapStart != 0L) {
            this.valueHeapStart = Unsafe.free(this.valueHeapStart, this.valueHeapSize, 59);
            this.valueHeapPos = 0L;
            this.valueHeapLimit = 0L;
            this.valueHeapSize = 0L;
        }
    }

    public TreeCursor getCursor() {
        this.cursor.toTop();
        return this.cursor;
    }

    public void put(Record leftRecord, RecordCursor sourceCursor, Record rightRecord, RecordComparator comparator) {
        int cmp;
        int parent;
        if (this.root == -1) {
            this.putParent(leftRecord.getRowId());
            return;
        }
        comparator.setLeft(leftRecord);
        int offset = this.root;
        do {
            parent = offset;
            int ref = this.refOf(offset);
            sourceCursor.recordAt(rightRecord, this.rowId(ref));
            cmp = comparator.compare(rightRecord);
            if (cmp < 0) {
                offset = this.leftOf(offset);
                continue;
            }
            if (cmp > 0) {
                offset = this.rightOf(offset);
                continue;
            }
            int oldChainEnd = this.lastRefOf(offset);
            int newChainEnd = this.appendNewValue(leftRecord.getRowId());
            this.setNextValueOffset(oldChainEnd, newChainEnd);
            this.setLastRef(offset, newChainEnd);
            return;
        } while (offset > -1);
        offset = this.allocateBlock();
        this.setParent(offset, parent);
        int chainStart = this.appendNewValue(leftRecord.getRowId());
        this.setRef(offset, chainStart);
        this.setLastRef(offset, chainStart);
        if (cmp < 0) {
            this.setLeft(parent, offset);
        } else {
            this.setRight(parent, offset);
        }
        this.fixInsert(offset);
    }

    @Override
    public void reopen() {
        super.reopen();
        if (this.valueHeapStart == 0L) {
            this.valueHeapSize = this.initialValueHeapSize;
            this.valueHeapStart = this.valueHeapPos = Unsafe.malloc(this.valueHeapSize, 59);
            this.valueHeapLimit = this.valueHeapStart + this.valueHeapSize;
        }
    }

    private static int compressValueOffset(long rawOffset) {
        return (int)(rawOffset >> 2);
    }

    private static long uncompressValueOffset(int offset) {
        return (long)offset << 2;
    }

    private int appendNewValue(long rowId) {
        this.checkValueCapacity();
        int offset = LongTreeChain.compressValueOffset(this.valueHeapPos - this.valueHeapStart);
        Unsafe.getUnsafe().putLong(this.valueHeapPos, rowId);
        Unsafe.getUnsafe().putInt(this.valueHeapPos + 8L, -1);
        this.valueHeapPos += 12L;
        return offset;
    }

    private void checkValueCapacity() {
        if (this.valueHeapPos + 12L > this.valueHeapLimit) {
            long newHeapSize = this.valueHeapSize << 1;
            if (newHeapSize > this.maxValueHeapSize) {
                throw LimitOverflowException.instance().put("limit of ").put(this.maxValueHeapSize).put(" memory exceeded in LongTreeChain");
            }
            long newHeapPos = Unsafe.realloc(this.valueHeapStart, this.valueHeapSize, newHeapSize, 59);
            this.valueHeapSize = newHeapSize;
            long delta = newHeapPos - this.valueHeapStart;
            this.valueHeapPos += delta;
            this.valueHeapStart = newHeapPos;
            this.valueHeapLimit = newHeapPos + newHeapSize;
        }
    }

    private int nextValueOffset(int valueOffset) {
        return Unsafe.getUnsafe().getInt(this.valueHeapStart + LongTreeChain.uncompressValueOffset(valueOffset) + 8L);
    }

    private void putParent(long rowId) {
        this.root = this.allocateBlock();
        int chainStart = this.appendNewValue(rowId);
        this.setRef(this.root, chainStart);
        this.setLastRef(this.root, chainStart);
        this.setParent(this.root, -1);
    }

    private long rowId(int valueOffset) {
        return Unsafe.getUnsafe().getLong(this.valueHeapStart + LongTreeChain.uncompressValueOffset(valueOffset));
    }

    private void setNextValueOffset(int valueOffset, int nextValueOffset) {
        Unsafe.getUnsafe().putInt(this.valueHeapStart + LongTreeChain.uncompressValueOffset(valueOffset) + 8L, nextValueOffset);
    }

    public class TreeCursor {
        private int chainCurrent;
        private int treeCurrent;

        public void clear() {
            this.treeCurrent = -1;
            this.chainCurrent = -1;
        }

        public boolean hasNext() {
            if (this.chainCurrent != -1) {
                return true;
            }
            this.treeCurrent = LongTreeChain.this.successor(this.treeCurrent);
            if (this.treeCurrent == -1) {
                return false;
            }
            this.chainCurrent = LongTreeChain.this.refOf(this.treeCurrent);
            return true;
        }

        public long next() {
            int result = this.chainCurrent;
            this.chainCurrent = LongTreeChain.this.nextValueOffset(this.chainCurrent);
            return LongTreeChain.this.rowId(result);
        }

        public void toTop() {
            this.setup();
        }

        private void setup() {
            int p = LongTreeChain.this.root;
            if (p != -1) {
                while (LongTreeChain.this.leftOf(p) != -1) {
                    p = LongTreeChain.this.leftOf(p);
                }
            }
            this.treeCurrent = p;
            this.chainCurrent = LongTreeChain.this.refOf(this.treeCurrent);
        }
    }
}

