/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursor;
import io.questdb.griffin.engine.table.NoMoreFramesException;
import org.jetbrains.annotations.Nullable;

public class PageFrameRecordCursorImpl
extends AbstractPageFrameRecordCursor {
    private final boolean entityCursor;
    private final Function filter;
    private final RowCursorFactory rowCursorFactory;
    private boolean areCursorsPrepared;
    private boolean isSkipped;
    private RowCursor rowCursor;

    public PageFrameRecordCursorImpl(CairoConfiguration configuration, RecordMetadata metadata, RowCursorFactory rowCursorFactory, boolean entityCursor, @Nullable Function filter) {
        super(configuration, metadata);
        this.rowCursorFactory = rowCursorFactory;
        this.entityCursor = entityCursor;
        this.filter = filter;
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        this.prepareRowCursorFactory();
        if (!this.frameCursor.supportsSizeCalculation() || this.filter != null || this.rowCursorFactory.isUsingIndex()) {
            while (this.hasNext()) {
                counter.inc();
            }
            return;
        }
        if (this.rowCursor != null) {
            while (this.rowCursor.hasNext()) {
                this.rowCursor.next();
                counter.inc();
            }
            this.rowCursor = null;
        }
        this.frameCursor.calculateSize(counter);
    }

    public RowCursorFactory getRowCursorFactory() {
        return this.rowCursorFactory;
    }

    @Override
    public boolean hasNext() {
        this.prepareRowCursorFactory();
        try {
            PageFrame frame;
            if (this.rowCursor != null && this.rowCursor.hasNext()) {
                int frameIndex = this.frameCount - 1;
                long rowIndex = this.rowCursor.next();
                this.frameMemoryPool.navigateTo(frameIndex, this.recordA);
                this.recordA.setRowIndex(rowIndex);
                return true;
            }
            while ((frame = this.frameCursor.next()) != null) {
                this.frameAddressCache.add(this.frameCount, frame);
                PageFrameMemory frameMemory = this.frameMemoryPool.navigateTo(this.frameCount++);
                this.rowCursor = this.rowCursorFactory.getCursor(frame, frameMemory);
                if (!this.rowCursor.hasNext()) continue;
                this.recordA.init(frameMemory);
                this.recordA.setRowIndex(this.rowCursor.next());
                return true;
            }
        }
        catch (NoMoreFramesException ignore) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return this.rowCursorFactory.isUsingIndex();
    }

    @Override
    public void of(PageFrameCursor frameCursor, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (this.frameCursor != frameCursor) {
            this.close();
            this.frameCursor = frameCursor;
        }
        this.recordA.of(frameCursor);
        this.recordB.of(frameCursor);
        this.rowCursorFactory.init(frameCursor, sqlExecutionContext);
        this.areCursorsPrepared = false;
        this.rowCursor = null;
        this.isSkipped = false;
        super.init();
    }

    @Override
    public long preComputedStateSize() {
        return RecordCursor.fromBool(this.areCursorsPrepared);
    }

    @Override
    public long size() {
        return this.entityCursor ? this.frameCursor.size() : -1L;
    }

    @Override
    public void skipRows(RecordCursor.Counter rowCount) {
        PageFrame pageFrame;
        if (this.isSkipped) {
            return;
        }
        this.prepareRowCursorFactory();
        if (this.filter != null || this.rowCursorFactory.isUsingIndex()) {
            while (rowCount.get() > 0L && this.hasNext()) {
                rowCount.dec();
            }
            this.isSkipped = true;
            return;
        }
        long skipTarget = rowCount.get();
        while ((pageFrame = this.frameCursor.next(skipTarget)) != null) {
            this.frameAddressCache.add(this.frameCount++, pageFrame);
            long frameSize = pageFrame.getPartitionHi() - pageFrame.getPartitionLo();
            if (frameSize > skipTarget) {
                rowCount.dec(skipTarget);
                break;
            }
            rowCount.dec(frameSize);
            skipTarget -= frameSize;
        }
        int frameIndex = this.frameCount - 1;
        this.isSkipped = true;
        if (pageFrame != null) {
            PageFrameMemory frameMemory = this.frameMemoryPool.navigateTo(frameIndex);
            this.recordA.init(frameMemory);
            this.recordA.setRowIndex(0L);
            this.rowCursor = this.rowCursorFactory.getCursor(pageFrame, frameMemory);
            this.rowCursor.jumpTo(skipTarget);
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Page frame scan");
    }

    @Override
    public void toTop() {
        if (this.filter != null) {
            this.filter.toTop();
        }
        this.rowCursor = null;
        this.isSkipped = false;
        super.toTop();
    }

    private void prepareRowCursorFactory() {
        if (!this.areCursorsPrepared) {
            this.rowCursorFactory.prepareCursor(this.frameCursor);
            this.areCursorsPrepared = true;
        }
    }
}

