/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.RowCursor;

class SymbolIndexFilteredRowCursor
implements RowCursor {
    private final boolean cachedIndexReaderCursor;
    private final int columnIndex;
    private final Function filter;
    private final int indexDirection;
    private final PageFrameMemoryRecord record;
    private RowCursor rowCursor;
    private long rowIndex;
    private int symbolKey;

    public SymbolIndexFilteredRowCursor(int columnIndex, int symbolKey, Function filter, boolean cachedIndexReaderCursor, int indexDirection) {
        this(columnIndex, filter, cachedIndexReaderCursor, indexDirection);
        this.of(symbolKey);
    }

    public SymbolIndexFilteredRowCursor(int columnIndex, Function filter, boolean cachedIndexReaderCursor, int indexDirection) {
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
        this.indexDirection = indexDirection;
        this.record = new PageFrameMemoryRecord(0);
    }

    @Override
    public boolean hasNext() {
        while (this.rowCursor.hasNext()) {
            long rowIndex = this.rowCursor.next();
            this.record.setRowIndex(rowIndex);
            if (!this.filter.getBool(this.record)) continue;
            this.rowIndex = rowIndex;
            return true;
        }
        return false;
    }

    @Override
    public long next() {
        return this.rowIndex;
    }

    public void of(int symbolKey) {
        this.symbolKey = TableUtils.toIndexKey(symbolKey);
    }

    public SymbolIndexFilteredRowCursor of(PageFrame pageFrame, PageFrameMemory pageFrameMemory) {
        this.rowCursor = pageFrame.getBitmapIndexReader(this.columnIndex, this.indexDirection).getCursor(this.cachedIndexReaderCursor, this.symbolKey, pageFrame.getPartitionLo(), pageFrame.getPartitionHi() - 1L);
        this.record.init(pageFrameMemory);
        this.record.setRowIndex(0L);
        return this;
    }

    Function getFilter() {
        return this.filter;
    }

    int getIndexDirection() {
        return this.indexDirection;
    }

    int getSymbolKey() {
        return this.symbolKey;
    }

    void prepare(PageFrameCursor pageFrameCursor) {
        this.record.of(pageFrameCursor);
    }
}

