/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.Metrics;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableWriterMetrics;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.StringLongTuplesRecordCursor;

public final class TableWriterMetricsRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int COMMITTED_ROWS_COLUMN_INDEX = 3;
    private static final RecordMetadata METADATA;
    private static final long METRICS_DISABLED_VALUE = -1L;
    private static final int O3_COMMITS_COLUMN_INDEX = 1;
    private static final int PHYSICALLY_WRITTEN_ROWS_COLUMN_INDEX = 4;
    private static final int ROLLBACKS_COLUMN_INDEX = 2;
    private static final int TOTAL_COMMITS_COLUMN_INDEX = 0;
    private static final int TOTAL_NUMBER_OF_METRIC = 5;
    private static final String[] KEYS;
    private final StringLongTuplesRecordCursor cursor = new StringLongTuplesRecordCursor();
    private final long[] values = new long[5];

    public TableWriterMetricsRecordCursorFactory() {
        super(METADATA);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        Metrics metrics = executionContext.getCairoEngine().getMetrics();
        if (metrics.isEnabled()) {
            TableWriterMetrics tableWriterMetrics = metrics.tableWriterMetrics();
            this.values[0] = tableWriterMetrics.getCommitCount();
            this.values[1] = tableWriterMetrics.getO3CommitCount();
            this.values[2] = tableWriterMetrics.getRollbackCount();
            this.values[3] = tableWriterMetrics.getCommittedRows();
            this.values[4] = tableWriterMetrics.getPhysicallyWrittenRows();
        } else {
            this.values[0] = -1L;
            this.values[1] = -1L;
            this.values[2] = -1L;
            this.values[3] = -1L;
            this.values[4] = -1L;
        }
        this.cursor.of(KEYS, this.values);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("table_writer_metrics");
    }

    static {
        KEYS = new String[5];
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("name", 11));
        metadata.add(1, new TableColumnMetadata("value", 6));
        METADATA = metadata;
        TableWriterMetricsRecordCursorFactory.KEYS[0] = "total_commits";
        TableWriterMetricsRecordCursorFactory.KEYS[1] = "o3commits";
        TableWriterMetricsRecordCursorFactory.KEYS[2] = "rollbacks";
        TableWriterMetricsRecordCursorFactory.KEYS[3] = "committed_rows";
        TableWriterMetricsRecordCursorFactory.KEYS[4] = "physically_written_rows";
    }
}

