/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.union.AbstractSetRecordCursor;
import io.questdb.griffin.engine.union.UnionCastRecord;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

class ExceptAllCastRecordCursor
extends AbstractSetRecordCursor {
    private final UnionCastRecord castRecord;
    private final Map map;
    private final RecordSink recordSink;
    private boolean isCursorBHashed;
    private boolean isOpen;
    private UnionCastRecord recordB;

    public ExceptAllCastRecordCursor(Map map, RecordSink recordSink, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB) {
        this.map = map;
        this.isOpen = true;
        this.recordSink = recordSink;
        this.castRecord = new UnionCastRecord(castFunctionsA, castFunctionsB);
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.map.close();
            super.close();
        }
    }

    @Override
    public Record getRecord() {
        return this.castRecord;
    }

    @Override
    public Record getRecordB() {
        if (this.recordB == null) {
            this.recordB = new UnionCastRecord(this.castRecord.getCastFunctionsA(), this.castRecord.getCastFunctionsB());
            this.recordB.setAb(true);
            this.recordB.of(this.cursorA.getRecordB(), null);
        }
        return this.recordB;
    }

    @Override
    public boolean hasNext() {
        if (!this.isCursorBHashed) {
            this.hashCursorB();
            this.castRecord.setAb(true);
            this.toTop();
            this.isCursorBHashed = true;
        }
        while (this.cursorA.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(this.castRecord, this.recordSink);
            if (key.notFound()) {
                return true;
            }
            this.circuitBreaker.statefulThrowExceptionIfTripped();
        }
        return false;
    }

    @Override
    public long preComputedStateSize() {
        return this.isCursorBHashed ? 1L : 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.cursorA.recordAt(((UnionCastRecord)record).getRecordA(), atRowId);
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        this.cursorA.toTop();
    }

    private void hashCursorB() {
        while (this.cursorB.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(this.castRecord, this.recordSink);
            key.createValue();
            this.circuitBreaker.statefulThrowExceptionIfTripped();
        }
        this.cursorB = Misc.free(this.cursorB);
    }

    @Override
    void of(RecordCursor cursorA, RecordCursor cursorB, SqlExecutionCircuitBreaker circuitBreaker) throws SqlException {
        if (!this.isOpen) {
            this.isOpen = true;
            this.map.reopen();
        }
        super.of(cursorA, cursorB, circuitBreaker);
        this.castRecord.of(cursorA.getRecord(), cursorB.getRecord());
        this.castRecord.setAb(false);
        this.isCursorBHashed = false;
    }
}

