/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8String;

public final class Hash {
    private static final long M2 = 5871781006564002453L;
    private static final int MURMUR3_SEED = 95967;
    private static final long MURMUR3_X64_128_C1 = -8663945395140668459L;
    private static final long MURMUR3_X64_128_C2 = 5545529020109919103L;
    private static final int SPREAD_HASH_BITS = Integer.MAX_VALUE;

    private Hash() {
    }

    public static int boundedHash(CharSequence seq, int max) {
        return seq == null ? -1 : Chars.hashCode(seq) & 0xFFFFFFF & max;
    }

    public static long hashInt64(int k) {
        return Hash.fmix64(Integer.toUnsignedLong(k));
    }

    public static int hashLong128_32(long key1, long key2) {
        return (int)Hash.hashLong128_64(key1, key2);
    }

    public static long hashLong128_64(long key1, long key2) {
        return Hash.fmix64(key1 * 5871781006564002453L + key2);
    }

    public static long hashLong256_64(long key1, long key2, long key3, long key4) {
        return Hash.fmix64(key1 * 5871781006564002453L * 5871781006564002453L * 5871781006564002453L + key2 * 5871781006564002453L * 5871781006564002453L + key3 * 5871781006564002453L + key4);
    }

    public static int hashLong32(long k) {
        return (int)Hash.hashLong64(k);
    }

    public static long hashLong64(long k) {
        return Hash.fmix64(k);
    }

    public static long hashMem64(long p, long len) {
        long h = 0L;
        long i = 0L;
        while (i + 7L < len) {
            h = h * 5871781006564002453L + Unsafe.getUnsafe().getLong(p + i);
            i += 8L;
        }
        if (i + 3L < len) {
            h = h * 5871781006564002453L + (long)Unsafe.getUnsafe().getInt(p + i);
            i += 4L;
        }
        while (i < len) {
            h = h * 5871781006564002453L + (long)Unsafe.getUnsafe().getByte(p + i);
            ++i;
        }
        return Hash.fmix64(h);
    }

    public static int hashUtf8(DirectUtf8Sequence seq) {
        return (int)Hash.hashMem64(seq.lo(), seq.size());
    }

    public static int hashUtf8(Utf8String us) {
        int len = us.size();
        long h = 0L;
        int i = 0;
        while (i + 7 < len) {
            h = h * 5871781006564002453L + us.longAt(i);
            i += 8;
        }
        if (i + 3 < len) {
            h = h * 5871781006564002453L + (long)us.intAt(i);
            i += 4;
        }
        while (i < len) {
            h = h * 5871781006564002453L + (long)us.byteAt(i);
            ++i;
        }
        return (int)Hash.fmix64(h);
    }

    public static long murmur3ToLong(long key) {
        return Hash.murmur3ToLong(key, 8);
    }

    public static long murmur3ToLong(int key) {
        return Hash.murmur3ToLong((long)key & 0xFFFFFFFFL, 4);
    }

    public static int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    private static long fmix64(long h) {
        h = (h ^ h >>> 33) * -49064778989728563L;
        h = (h ^ h >>> 33) * -4265267296055464877L;
        return h ^ h >>> 33;
    }

    private static long murmur3ToLong(long key, int keySizeInBytes) {
        long k1 = key;
        long h1 = 95967L;
        long h2 = 95967L;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        h1 ^= (k1 *= 5545529020109919103L);
        h1 ^= (long)keySizeInBytes;
        h1 += (h2 ^= (long)keySizeInBytes);
        h2 += h1;
        h1 = Hash.fmix64(h1);
        h2 = Hash.fmix64(h2);
        return h1 += h2;
    }
}

