/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert_define_monitor_bind", indexes={@Index(name="idx_alert_define_id", columnList="alert_define_id"), @Index(name="idx_monitor_id", columnList="monitor_id")})
@Schema(description="Alarm Threshold Relate Monitor Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class AlertDefineMonitorBind {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="id", example="74384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Alarm Define Id", example="87432674384", accessMode=Schema.AccessMode.READ_WRITE)
    private Long alertDefineId;
    @Schema(title="Monitor Id", example="87432674336", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(name="monitor_id")
    private Long monitorId;
    @Schema(title="Record create time", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="monitor_id", referencedColumnName="id", foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT), insertable=false, updatable=false)
    private Monitor monitor;

    public static AlertDefineMonitorBindBuilder builder() {
        return new AlertDefineMonitorBindBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getAlertDefineId() {
        return this.alertDefineId;
    }

    public Long getMonitorId() {
        return this.monitorId;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAlertDefineId(Long alertDefineId) {
        this.alertDefineId = alertDefineId;
    }

    public void setMonitorId(Long monitorId) {
        this.monitorId = monitorId;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertDefineMonitorBind)) {
            return false;
        }
        AlertDefineMonitorBind other = (AlertDefineMonitorBind)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$alertDefineId = this.getAlertDefineId();
        Long other$alertDefineId = other.getAlertDefineId();
        if (this$alertDefineId == null ? other$alertDefineId != null : !((Object)this$alertDefineId).equals(other$alertDefineId)) {
            return false;
        }
        Long this$monitorId = this.getMonitorId();
        Long other$monitorId = other.getMonitorId();
        if (this$monitorId == null ? other$monitorId != null : !((Object)this$monitorId).equals(other$monitorId)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        if (this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate)) {
            return false;
        }
        Monitor this$monitor = this.getMonitor();
        Monitor other$monitor = other.getMonitor();
        return !(this$monitor == null ? other$monitor != null : !((Object)this$monitor).equals(other$monitor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertDefineMonitorBind;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $alertDefineId = this.getAlertDefineId();
        result = result * 59 + ($alertDefineId == null ? 43 : ((Object)$alertDefineId).hashCode());
        Long $monitorId = this.getMonitorId();
        result = result * 59 + ($monitorId == null ? 43 : ((Object)$monitorId).hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        Monitor $monitor = this.getMonitor();
        result = result * 59 + ($monitor == null ? 43 : ((Object)$monitor).hashCode());
        return result;
    }

    public String toString() {
        return "AlertDefineMonitorBind(id=" + this.getId() + ", alertDefineId=" + this.getAlertDefineId() + ", monitorId=" + this.getMonitorId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ", monitor=" + this.getMonitor() + ")";
    }

    public AlertDefineMonitorBind(Long id, Long alertDefineId, Long monitorId, LocalDateTime gmtCreate, LocalDateTime gmtUpdate, Monitor monitor) {
        this.id = id;
        this.alertDefineId = alertDefineId;
        this.monitorId = monitorId;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
        this.monitor = monitor;
    }

    public AlertDefineMonitorBind() {
    }

    public static class AlertDefineMonitorBindBuilder {
        private Long id;
        private Long alertDefineId;
        private Long monitorId;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;
        private Monitor monitor;

        AlertDefineMonitorBindBuilder() {
        }

        public AlertDefineMonitorBindBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AlertDefineMonitorBindBuilder alertDefineId(Long alertDefineId) {
            this.alertDefineId = alertDefineId;
            return this;
        }

        public AlertDefineMonitorBindBuilder monitorId(Long monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public AlertDefineMonitorBindBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AlertDefineMonitorBindBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public AlertDefineMonitorBindBuilder monitor(Monitor monitor) {
            this.monitor = monitor;
            return this;
        }

        public AlertDefineMonitorBind build() {
            return new AlertDefineMonitorBind(this.id, this.alertDefineId, this.monitorId, this.gmtCreate, this.gmtUpdate, this.monitor);
        }

        public String toString() {
            return "AlertDefineMonitorBind.AlertDefineMonitorBindBuilder(id=" + this.id + ", alertDefineId=" + this.alertDefineId + ", monitorId=" + this.monitorId + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ", monitor=" + this.monitor + ")";
        }
    }
}

