set hive.cli.print.header=true;
SET hive.vectorized.execution.enabled=true;
SET hive.vectorized.execution.reduce.enabled=true;
set hive.vectorized.execution.ptf.enabled=true;
set hive.fetch.task.conversion=none;

drop table over10k_n0;

create table over10k_n0(
           t tinyint,
           si smallint,
           i int,
           b bigint,
           f float,
           d double,
           bo boolean,
           s string,
	   ts timestamp, 
           `dec` decimal(4,2),  
           bin binary)
       row format delimited
       fields terminated by '|';

load data local inpath '../../data/files/over10k' into table over10k_n0;

explain vectorization detail
select s, rank() over (partition by f order by t) from over10k_n0 limit 100;
select s, rank() over (partition by f order by t) from over10k_n0 limit 100;

explain vectorization detail
select s, dense_rank() over (partition by ts order by i,s desc) from over10k_n0 limit 100;
select s, dense_rank() over (partition by ts order by i,s desc) from over10k_n0 limit 100;

explain vectorization detail
select s, cume_dist() over (partition by bo order by b,s) from over10k_n0 limit 100;
select s, cume_dist() over (partition by bo order by b,s) from over10k_n0 limit 100;

explain vectorization detail
select s, percent_rank() over (partition by `dec` order by f) from over10k_n0 limit 100;
select s, percent_rank() over (partition by `dec` order by f) from over10k_n0 limit 100;

-- If following tests fail, look for the comments in class PTFPPD::process()

explain vectorization detail
select ts, `dec`, rnk
from
  (select ts, `dec`,
          rank() over (partition by ts order by `dec`)  as rnk
          from
            (select other.ts, other.`dec`
             from over10k_n0 other
             join over10k_n0 on (other.b = over10k_n0.b)
            ) joined
  ) ranked
where rnk =  1 limit 10;
select ts, `dec`, rnk
from
  (select ts, `dec`,
          rank() over (partition by ts order by `dec`)  as rnk
          from
            (select other.ts, other.`dec`
             from over10k_n0 other
             join over10k_n0 on (other.b = over10k_n0.b)
            ) joined
  ) ranked
where rnk =  1 limit 10;

explain vectorization detail
select ts, `dec`, rnk
from
  (select ts, `dec`,
          rank() over (partition by ts)  as rnk
          from
            (select other.ts, other.`dec`
             from over10k_n0 other
             join over10k_n0 on (other.b = over10k_n0.b)
            ) joined
  ) ranked
where `dec` = 89.5 limit 10;
select ts, `dec`, rnk
from
  (select ts, `dec`,
          rank() over (partition by ts)  as rnk
          from
            (select other.ts, other.`dec`
             from over10k_n0 other
             join over10k_n0 on (other.b = over10k_n0.b)
            ) joined
  ) ranked
where `dec` = 89.5 limit 10;

explain vectorization detail
select ts, `dec`, rnk
from
  (select ts, `dec`,
          rank() over (partition by ts order by `dec`)  as rnk
          from
            (select other.ts, other.`dec`
             from over10k_n0 other
             join over10k_n0 on (other.b = over10k_n0.b)
             where other.t < 10
            ) joined
  ) ranked
where rnk = 1 limit 10;
select ts, `dec`, rnk
from
  (select ts, `dec`,
          rank() over (partition by ts order by `dec`)  as rnk
          from
            (select other.ts, other.`dec`
             from over10k_n0 other
             join over10k_n0 on (other.b = over10k_n0.b)
             where other.t < 10
            ) joined
  ) ranked
where rnk = 1 limit 10;

