/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hive.service.cli;

import org.apache.hadoop.hive.UtilsForTest;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;

/**
 * TestEmbeddedThriftBinaryCLIService.
 *
 */
public class TestEmbeddedThriftBinaryCLIService extends CLIServiceTest {
  protected static ThriftCLIService service;

  @BeforeClass
  public static void setUpBeforeClass() throws Exception {
    service = new EmbeddedThriftBinaryCLIService();
    HiveConf conf = new HiveConfForTest(TestEmbeddedThriftBinaryCLIService.class);
    conf.setBoolean("datanucleus.schema.autoCreateTables", true);
    conf.setVar(HiveConf.ConfVars.HIVE_MAPRED_MODE, "nonstrict");
    UtilsForTest.expandHiveConfParams(conf);
    service.init(conf);
    client = new ThriftCLIServiceClient(service);
  }

  /* (non-Javadoc)
   * @see org.apache.hive.service.cli.CLIServiceTest#setUp()
   */
  @Override
  @Before
  public void setUp() throws Exception {
    super.setUp();
  }

  /* (non-Javadoc)
   * @see org.apache.hive.service.cli.CLIServiceTest#tearDown()
   */
  @Override
  @After
  public void tearDown() throws Exception {
    super.tearDown();
  }

}
