/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlJdbcDataTypeName;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlJdbcFunctionCall
extends SqlFunction {
    private static final String NUMERIC_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "CBRT", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE");
    private static final String STRING_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("ASCII", "CHAR", "CONCAT", "DIFFERENCE", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTRING", "UCASE");
    private static final String TIME_DATE_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("CONVERT_TIMEZONE", "CURDATE", "CURTIME", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_DATE", "TO_TIMESTAMP", "WEEK", "YEAR");
    private static final String SYSTEM_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("CONVERT", "DATABASE", "IFNULL", "USER");
    private final String jdbcName;
    private final @Nullable MakeCall lookupMakeCallObj;
    private @Nullable SqlCall lookupCall;
    private @Nullable SqlNode @Nullable [] thisOperands;

    public SqlJdbcFunctionCall(String name) {
        super("{fn " + name + "}", SqlKind.JDBC_FN, null, null, OperandTypes.VARIADIC, SqlFunctionCategory.SYSTEM);
        this.jdbcName = name;
        this.lookupMakeCallObj = JdbcToInternalLookupTable.INSTANCE.lookup(name);
        this.lookupCall = null;
    }

    private static String constructFuncList(String ... functionNames) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        for (String funcName : functionNames) {
            if (JdbcToInternalLookupTable.INSTANCE.lookup(funcName) == null) continue;
            if (n++ > 0) {
                sb.append(",");
            }
            sb.append(funcName);
        }
        return sb.toString();
    }

    @Override
    public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        this.thisOperands = operands;
        return super.createCall(functionQualifier, pos, operands);
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        if (null == this.lookupMakeCallObj) {
            throw validator.newValidationError(call, Static.RESOURCE.functionUndefined(this.getName()));
        }
        return this.lookupMakeCallObj.getOperator().rewriteCall(validator, call);
    }

    public SqlCall getLookupCall() {
        if (null == this.lookupCall) {
            this.lookupCall = Objects.requireNonNull(this.lookupMakeCallObj, "lookupMakeCallObj").createCall(SqlParserPos.ZERO, Objects.requireNonNull(this.thisOperands, "thisOperands"));
        }
        return this.lookupCall;
    }

    @Override
    public String getAllowedSignatures(String name) {
        return Objects.requireNonNull(this.lookupMakeCallObj, "lookupMakeCallObj").getOperator().getAllowedSignatures(name);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            validator.setValidatedNodeType(operand, nodeType);
        }
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        SqlCallBinding callBinding = (SqlCallBinding)opBinding;
        if (null == this.lookupMakeCallObj) {
            throw callBinding.newValidationError(Static.RESOURCE.functionUndefined(this.getName()));
        }
        String message = this.lookupMakeCallObj.isValidArgCount(callBinding);
        if (message != null) {
            throw callBinding.newValidationError(Static.RESOURCE.wrongNumberOfParam(this.getName(), Objects.requireNonNull(this.thisOperands, "thisOperands").length, message));
        }
        SqlCall newCall = this.getLookupCall();
        SqlCallBinding newBinding = new SqlCallBinding(callBinding.getValidator(), callBinding.getScope(), newCall);
        SqlOperator operator = this.lookupMakeCallObj.getOperator();
        if (!operator.checkOperandTypes(newBinding, false)) {
            throw callBinding.newValidationSignatureError();
        }
        return operator.validateOperands(callBinding.getValidator(), callBinding.getScope(), newCall);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.print("{fn ");
        writer.print(this.jdbcName);
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
        writer.print("}");
    }

    public static String getNumericFunctions() {
        return NUMERIC_FUNCTIONS;
    }

    public static String getStringFunctions() {
        return STRING_FUNCTIONS;
    }

    public static String getTimeDateFunctions() {
        return TIME_DATE_FUNCTIONS;
    }

    public static String getSystemFunctions() {
        return SYSTEM_FUNCTIONS;
    }

    private static class JdbcToInternalLookupTable {
        static final JdbcToInternalLookupTable INSTANCE = new JdbcToInternalLookupTable();
        private final Map<String, MakeCall> map;

        private JdbcToInternalLookupTable() {
            ImmutableMap.Builder map = ImmutableMap.builder();
            map.put((Object)"ABS", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.ABS));
            map.put((Object)"ACOS", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.ACOS));
            map.put((Object)"ASIN", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.ASIN));
            map.put((Object)"ATAN", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.ATAN));
            map.put((Object)"ATAN2", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.ATAN2));
            map.put((Object)"CBRT", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.CBRT));
            map.put((Object)"CEILING", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.CEIL));
            map.put((Object)"COS", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.COS));
            map.put((Object)"COT", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.COT));
            map.put((Object)"DEGREES", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.DEGREES));
            map.put((Object)"EXP", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.EXP));
            map.put((Object)"FLOOR", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.FLOOR));
            map.put((Object)"LOG", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.LN));
            map.put((Object)"LOG10", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.LOG10));
            map.put((Object)"MOD", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.MOD));
            map.put((Object)"PI", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.PI));
            map.put((Object)"POWER", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.POWER));
            map.put((Object)"RADIANS", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.RADIANS));
            map.put((Object)"RAND", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.RAND));
            map.put((Object)"ROUND", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.ROUND));
            map.put((Object)"SIGN", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.SIGN));
            map.put((Object)"SIN", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.SIN));
            map.put((Object)"SQRT", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.SQRT));
            map.put((Object)"TAN", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.TAN));
            map.put((Object)"TRUNCATE", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.TRUNCATE));
            map.put((Object)"ASCII", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.ASCII));
            map.put((Object)"CHAR", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.CHAR));
            map.put((Object)"CONCAT", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.CONCAT));
            map.put((Object)"DIFFERENCE", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.DIFFERENCE));
            map.put((Object)"INSERT", (Object)new PermutingMakeCall(SqlStdOperatorTable.OVERLAY, new int[]{0, 2, 3, 1}));
            map.put((Object)"LCASE", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.LOWER));
            map.put((Object)"LENGTH", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.CHARACTER_LENGTH));
            map.put((Object)"LOCATE", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.POSITION));
            map.put((Object)"LEFT", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.LEFT));
            map.put((Object)"LTRIM", (Object)JdbcToInternalLookupTable.trim(SqlTrimFunction.Flag.LEADING));
            map.put((Object)"REPEAT", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.REPEAT));
            map.put((Object)"REPLACE", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.REPLACE));
            map.put((Object)"REVERSE", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.REVERSE));
            map.put((Object)"RIGHT", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.RIGHT));
            map.put((Object)"RTRIM", (Object)JdbcToInternalLookupTable.trim(SqlTrimFunction.Flag.TRAILING));
            map.put((Object)"SOUNDEX", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.SOUNDEX));
            map.put((Object)"SPACE", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.SPACE));
            map.put((Object)"SUBSTRING", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.SUBSTRING));
            map.put((Object)"UCASE", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.UPPER));
            map.put((Object)"YEAR", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.YEAR));
            map.put((Object)"QUARTER", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.QUARTER));
            map.put((Object)"MONTH", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.MONTH));
            map.put((Object)"WEEK", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.WEEK));
            map.put((Object)"DAYOFYEAR", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.DAYOFYEAR));
            map.put((Object)"DAYOFMONTH", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.DAYOFMONTH));
            map.put((Object)"DAYOFWEEK", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.DAYOFWEEK));
            map.put((Object)"DAYNAME", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.DAYNAME));
            map.put((Object)"HOUR", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.HOUR));
            map.put((Object)"MINUTE", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.MINUTE));
            map.put((Object)"MONTHNAME", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.MONTHNAME));
            map.put((Object)"SECOND", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.SECOND));
            map.put((Object)"CONVERT_TIMEZONE", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.CONVERT_TIMEZONE));
            map.put((Object)"CURDATE", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.CURRENT_DATE));
            map.put((Object)"CURTIME", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.LOCALTIME));
            map.put((Object)"NOW", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.CURRENT_TIMESTAMP));
            map.put((Object)"TIMESTAMPADD", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.TIMESTAMP_ADD));
            map.put((Object)"TIMESTAMPDIFF", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.TIMESTAMP_DIFF));
            map.put((Object)"TO_DATE", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.TO_DATE));
            map.put((Object)"TO_TIMESTAMP", (Object)JdbcToInternalLookupTable.simple(SqlLibraryOperators.TO_TIMESTAMP));
            map.put((Object)"DATABASE", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.CURRENT_CATALOG));
            map.put((Object)"IFNULL", (Object)new SimpleMakeCall(SqlStdOperatorTable.COALESCE){

                @Override
                public SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
                    assert (2 == operands.length);
                    return super.createCall(pos, operands);
                }
            });
            map.put((Object)"USER", (Object)JdbcToInternalLookupTable.simple(SqlStdOperatorTable.CURRENT_USER));
            map.put((Object)"CONVERT", (Object)new SimpleMakeCall(SqlStdOperatorTable.CAST){

                @Override
                public SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
                    assert (2 == operands.length);
                    SqlNode typeOperand = operands[1];
                    assert (typeOperand != null && typeOperand.getKind() == SqlKind.LITERAL) : "literal expected, got " + typeOperand;
                    SqlJdbcDataTypeName jdbcType = ((SqlLiteral)typeOperand).getValueAs(SqlJdbcDataTypeName.class);
                    return super.createCall(pos, operands[0], jdbcType.createDataType(typeOperand.pos));
                }
            });
            this.map = map.build();
        }

        private static MakeCall trim(final SqlTrimFunction.Flag flag) {
            return new SimpleMakeCall(SqlStdOperatorTable.TRIM){

                @Override
                public SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
                    assert (1 == operands.length);
                    return super.createCall(pos, flag.symbol(pos), SqlLiteral.createCharString(" ", SqlParserPos.ZERO), operands[0]);
                }
            };
        }

        private static MakeCall simple(SqlOperator operator) {
            return new SimpleMakeCall(operator);
        }

        public @Nullable MakeCall lookup(String name) {
            return this.map.get(name);
        }
    }

    private static class PermutingMakeCall
    extends SimpleMakeCall {
        final int[] order;

        PermutingMakeCall(SqlOperator operator, int[] order) {
            super(operator);
            this.order = Objects.requireNonNull(order, "order");
        }

        @Override
        public SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
            return super.createCall(pos, this.reorder(operands));
        }

        @Override
        public @Nullable String isValidArgCount(SqlCallBinding binding) {
            if (this.order.length == binding.getOperandCount()) {
                return null;
            }
            return PermutingMakeCall.getArgCountMismatchMsg(this.order.length);
        }

        private static String getArgCountMismatchMsg(int ... possible) {
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < possible.length; ++i) {
                if (i > 0) {
                    ret.append(" or ");
                }
                ret.append(possible[i]);
            }
            ret.append(" parameter(s)");
            return ret.toString();
        }

        protected @Nullable SqlNode[] reorder(@Nullable SqlNode[] operands) {
            assert (operands.length == this.order.length);
            @Nullable SqlNode[] newOrder = new SqlNode[operands.length];
            for (int i = 0; i < operands.length; ++i) {
                assert (operands[i] != null);
                int joyDivision = this.order[i];
                assert (newOrder[joyDivision] == null) : "mapping is not 1:1";
                newOrder[joyDivision] = operands[i];
            }
            return newOrder;
        }
    }

    public static class SimpleMakeCall
    implements MakeCall {
        final SqlOperator operator;

        public SimpleMakeCall(SqlOperator operator) {
            this.operator = operator;
        }

        @Override
        public SqlOperator getOperator() {
            return this.operator;
        }

        @Override
        public SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
            return this.operator.createCall(pos, operands);
        }

        @Override
        public @Nullable String isValidArgCount(SqlCallBinding binding) {
            return null;
        }
    }

    private static interface MakeCall {
        public SqlCall createCall(SqlParserPos var1, SqlNode ... var2);

        public SqlOperator getOperator();

        public @Nullable String isValidArgCount(SqlCallBinding var1);
    }
}

