/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.orc.EncryptionAlgorithm;
import org.apache.orc.impl.CryptoUtils;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.KeyProvider;

public class KeyTool {
    private final OutputStreamWriter writer;
    private final Configuration conf;

    static void printKey(JsonWriter writer, KeyProvider provider, String keyName) throws IOException {
        HadoopShims.KeyMetadata meta = provider.getCurrentKeyVersion(keyName);
        writer.beginObject();
        writer.name("name");
        writer.value(keyName);
        EncryptionAlgorithm algorithm = meta.getAlgorithm();
        writer.name("algorithm");
        writer.value(algorithm.getAlgorithm());
        writer.name("keyLength");
        writer.value((long)algorithm.keyLength());
        writer.name("version");
        writer.value((long)meta.getVersion());
        byte[] iv = new byte[algorithm.getIvLength()];
        byte[] key = provider.decryptLocalKey(meta, iv).getEncoded();
        writer.name("key 0");
        writer.value(new BytesWritable(key).toString());
        writer.endObject();
    }

    public KeyTool(Configuration conf, String[] args) throws IOException, ParseException {
        CommandLine opts = KeyTool.parseOptions(args);
        PrintStream stream = opts.hasOption('o') ? new PrintStream(opts.getOptionValue('o'), "UTF-8") : System.out;
        this.writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
        this.conf = conf;
    }

    void run() throws IOException {
        KeyProvider provider = CryptoUtils.getKeyProvider((Configuration)this.conf, (Random)new SecureRandom());
        if (provider == null) {
            System.err.println("No key provider available.");
            System.exit(1);
        }
        for (String keyName : provider.getKeyNames()) {
            JsonWriter writer = new JsonWriter((Writer)this.writer);
            KeyTool.printKey(writer, provider, keyName);
            this.writer.write(10);
        }
        this.writer.close();
    }

    private static CommandLine parseOptions(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt("help").desc("Provide help").build());
        options.addOption(Option.builder((String)"o").longOpt("output").desc("Output filename").hasArg().build());
        CommandLine cli = new DefaultParser().parse(options, args);
        if (cli.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("key", options);
            System.exit(1);
        }
        return cli;
    }

    public static void main(Configuration conf, String[] args) throws IOException, ParseException {
        KeyTool tool = new KeyTool(conf, args);
        tool.run();
    }
}

