/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.protobuf.BlockingService;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LlapUtil.class);
    private static final Pattern hostsRe = Pattern.compile("[^A-Za-z0-9_-]");
    private static final String BASE_PREFIX = "base_";
    private static final String DELTA_PREFIX = "delta_";
    private static final String DELETE_DELTA_PREFIX = "delete_delta_";
    private static final String BUCKET_PREFIX = "bucket_";
    private static final String DATABASE_PATH_SUFFIX = ".db";
    private static final String UNION_SUDBIR_PREFIX = "HIVE_UNION_SUBDIR_";

    public static String getDaemonLocalDirString(Configuration conf, String workDirsEnvString) {
        String localDirList = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WORK_DIRS);
        if (localDirList != null && !localDirList.isEmpty()) {
            LOG.info("Local dirs from Configuration: {}", (Object)localDirList);
            if (!localDirList.equalsIgnoreCase("useYarnEnvDirs") && !StringUtils.isBlank((CharSequence)localDirList)) {
                LOG.info("Using local dirs from Configuration");
                return localDirList;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)workDirsEnvString)) {
            LOG.info("Using local dirs from environment: {}", (Object)workDirsEnvString);
            return workDirsEnvString;
        }
        throw new RuntimeException("Cannot determined local dirs from specified configuration and env. ValueFromConf=" + localDirList + ", ValueFromEnv=" + workDirsEnvString);
    }

    public static UserGroupInformation loginWithKerberos(String principal, String keytabFile) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return null;
        }
        if (principal == null || principal.isEmpty() || keytabFile == null || keytabFile.isEmpty()) {
            throw new RuntimeException("Kerberos principal and/or keytab are null or empty");
        }
        String serverPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        LOG.info("Logging in as " + serverPrincipal + " via " + keytabFile);
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)serverPrincipal, (String)keytabFile);
    }

    public static void loginWithKerberosAndUpdateCurrentUser(String principal, String keytabFile) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (principal == null || principal.isEmpty() || keytabFile == null || keytabFile.isEmpty()) {
            throw new RuntimeException("Kerberos principal and/or keytab is null or empty");
        }
        String serverPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        LOG.info("Logging in as " + serverPrincipal + " via " + keytabFile + " and updating current logged in user");
        UserGroupInformation.loginUserFromKeytab((String)serverPrincipal, (String)keytabFile);
    }

    public static String generateClusterName(Configuration conf) {
        String hosts = HiveConf.getTrimmedVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        return hostsRe.matcher(hosts.startsWith("@") ? hosts.substring(1) : hosts).replaceAll("_");
    }

    public static String getUserNameFromPrincipal(String principal) {
        if (principal == null) {
            return null;
        }
        String[] components = principal.split("[/@]");
        return components == null || components.length != 3 ? principal : components[0];
    }

    public static String getAmHostNameFromAddress(InetSocketAddress address, Configuration conf) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_AM_USE_FQDN)) {
            return address.getHostName();
        }
        InetAddress ia = address.getAddress();
        return ia == null ? address.getHostName() : ia.getCanonicalHostName();
    }

    public static String humanReadableByteCount(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String suffix = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.2f%sB", (double)bytes / Math.pow(unit, exp), suffix);
    }

    public static RPC.Server createRpcServer(Class<?> pbProtocol, InetSocketAddress addr, Configuration conf, int numHandlers, BlockingService blockingService, SecretManager<?> secretManager, PolicyProvider provider, HiveConf.ConfVars ... aclVars) throws IOException {
        Configuration serverConf = conf;
        boolean isSecurityEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (isSecurityEnabled) {
            for (HiveConf.ConfVars acl : aclVars) {
                if (conf.get(acl.varname) != null) continue;
                if (serverConf == conf) {
                    serverConf = new Configuration(conf);
                }
                serverConf.set(acl.varname, HiveConf.getVar((Configuration)serverConf, (HiveConf.ConfVars)acl));
            }
        }
        RPC.setProtocolEngine((Configuration)serverConf, pbProtocol, ProtobufRpcEngine.class);
        RPC.Builder builder = new RPC.Builder(serverConf).setProtocol(pbProtocol).setInstance((Object)blockingService).setBindAddress(addr.getHostName()).setPort(addr.getPort()).setNumHandlers(numHandlers);
        if (secretManager != null) {
            builder = builder.setSecretManager(secretManager);
        }
        RPC.Server server = builder.build();
        if (isSecurityEnabled) {
            server.refreshServiceAcl(serverConf, provider);
        }
        return server;
    }

    public static RPC.Server startProtocolServer(int srvPort, int numHandlers, AtomicReference<InetSocketAddress> bindAddress, Configuration conf, BlockingService impl, Class<?> protocolClass, SecretManager<?> secretManager, PolicyProvider provider, HiveConf.ConfVars ... aclVars) {
        RPC.Server server;
        InetSocketAddress addr = new InetSocketAddress(srvPort);
        try {
            server = LlapUtil.createRpcServer(protocolClass, addr, conf, numHandlers, impl, secretManager, provider, aclVars);
            server.start();
        }
        catch (IOException e) {
            LOG.error("Failed to run RPC Server on port: " + srvPort, (Throwable)e);
            throw new RuntimeException(e);
        }
        InetSocketAddress serverBindAddress = NetUtils.getConnectAddress((Server)server);
        InetSocketAddress bindAddressVal = NetUtils.createSocketAddrForHost((String)serverBindAddress.getAddress().getCanonicalHostName(), (int)serverBindAddress.getPort());
        if (bindAddress != null) {
            bindAddress.set(bindAddressVal);
        }
        LOG.info("Instantiated " + protocolClass.getSimpleName() + " at " + bindAddressVal);
        return server;
    }

    @Deprecated
    public static String getDbAndTableNameForMetrics(Path path, boolean includeParts) {
        String[] parts = path.toUri().getPath().toString().split("/");
        int dbIx = -1;
        for (int i = 0; i < parts.length - 2; ++i) {
            if (!parts[i].endsWith(DATABASE_PATH_SUFFIX)) continue;
            if (dbIx >= 0) {
                dbIx = -1;
                break;
            }
            dbIx = i;
        }
        if (dbIx >= 0) {
            String dbAndTable = parts[dbIx].substring(0, parts[dbIx].length() - 3) + "." + parts[dbIx + 1];
            if (!includeParts) {
                return dbAndTable;
            }
            for (int i = dbIx + 2; i < parts.length && parts[i].contains("="); ++i) {
                dbAndTable = dbAndTable + "/" + parts[i];
            }
            return dbAndTable;
        }
        boolean isInPartFields = false;
        for (int i = parts.length - 2; i >= 0; --i) {
            String p = parts[i];
            boolean isPartField = p.contains("=");
            if (isInPartFields && !isPartField || !isPartField && !LlapUtil.isSomeHiveDir(p)) {
                dbIx = i - 1;
                break;
            }
            isInPartFields = isPartField;
        }
        if (dbIx >= 0) {
            String dbName = parts[dbIx];
            if (dbName.endsWith(DATABASE_PATH_SUFFIX)) {
                dbName = dbName.substring(0, dbName.length() - 3);
            }
            String dbAndTable = dbName + "." + parts[dbIx + 1];
            if (!includeParts) {
                return dbAndTable;
            }
            for (int i = dbIx + 2; i < parts.length && parts[i].contains("="); ++i) {
                dbAndTable = dbAndTable + "/" + parts[i];
            }
            return dbAndTable;
        }
        return "unknown";
    }

    private static boolean isSomeHiveDir(String p) {
        return p.startsWith(BASE_PREFIX) || p.startsWith(DELTA_PREFIX) || p.startsWith(BUCKET_PREFIX) || p.startsWith(UNION_SUDBIR_PREFIX) || p.startsWith(DELETE_DELTA_PREFIX);
    }

    @Nullable
    public static ThreadMXBean initThreadMxBean() {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        if (mxBean != null) {
            if (!mxBean.isCurrentThreadCpuTimeSupported()) {
                LOG.warn("Thread CPU monitoring is not supported");
                return null;
            }
            if (!mxBean.isThreadCpuTimeEnabled()) {
                LOG.warn("Thread CPU monitoring is not enabled");
                return null;
            }
        }
        return mxBean;
    }

    public static Credentials credentialsFromByteArray(byte[] binaryCredentials) throws IOException {
        Credentials credentials = new Credentials();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(binaryCredentials, binaryCredentials.length);
        credentials.readTokenStorageStream((DataInputStream)dib);
        return credentials;
    }

    public static boolean isCloudDeployment(Configuration conf) {
        return HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_EXTERNAL_CLIENT_CLOUD_DEPLOYMENT_SETUP_ENABLED, (boolean)false);
    }

    public static String getPublicHostname() {
        String publicHostname = System.getenv("PUBLIC_HOSTNAME");
        if (publicHostname == null) {
            publicHostname = System.getProperty("PUBLIC_HOSTNAME");
        }
        return publicHostname;
    }
}

