/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.lang.annotation.Annotation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.protocol.LlapManagementProtocolPB;
import org.apache.hadoop.hive.llap.protocol.LlapProtocolBlockingPB;
import org.apache.hadoop.hive.llap.security.LlapTokenSelector;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenInfo;
import org.apache.hadoop.security.token.TokenSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapServerSecurityInfo
extends SecurityInfo {
    private static final Logger LOG = LoggerFactory.getLogger(LlapServerSecurityInfo.class);

    public KerberosInfo getKerberosInfo(Class<?> protocol, Configuration conf) {
        LOG.debug("Trying to get KerberosInfo for " + protocol);
        if (!LlapProtocolBlockingPB.class.isAssignableFrom(protocol) && !LlapManagementProtocolPB.class.isAssignableFrom(protocol)) {
            return null;
        }
        return new KerberosInfo(){

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public String serverPrincipal() {
                return HiveConf.ConfVars.LLAP_KERBEROS_PRINCIPAL.varname;
            }

            public String clientPrincipal() {
                return null;
            }
        };
    }

    public TokenInfo getTokenInfo(Class<?> protocol, Configuration conf) {
        LOG.debug("Trying to get TokenInfo for {}", protocol);
        if (!LlapProtocolBlockingPB.class.isAssignableFrom(protocol) && !LlapManagementProtocolPB.class.isAssignableFrom(protocol)) {
            return null;
        }
        return new TokenInfo(){

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public Class<? extends TokenSelector<? extends TokenIdentifier>> value() {
                return LlapTokenSelector.class;
            }
        };
    }
}

