/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Function;
import com.google.uzaygezen.core.BitSetBackedBitVector;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.LongArrayBitVector;
import com.google.uzaygezen.core.LongBitVector;

public enum BitVectorFactories implements Function<Integer, BitVector>
{
    OPTIMAL{

        public BitVector apply(Integer from) {
            int size = from;
            if (size <= 64) {
                return new LongBitVector(size);
            }
            return new BitSetBackedBitVector(size);
        }
    }
    ,
    SLOW{

        public BitSetBackedBitVector apply(Integer from) {
            return new BitSetBackedBitVector(from);
        }
    }
    ,
    LONG_ARRAY{

        public LongArrayBitVector apply(Integer from) {
            return new LongArrayBitVector(from);
        }
    };

}

