/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public enum PuffinCompressionCodec {
    NONE(null),
    LZ4("lz4"),
    ZSTD("zstd");

    private static final Map<String, PuffinCompressionCodec> BY_NAME;
    private final String codecName;

    private PuffinCompressionCodec(String codecName) {
        this.codecName = codecName;
    }

    @Nullable
    public String codecName() {
        return this.codecName;
    }

    public static PuffinCompressionCodec forName(@Nullable String codecName) {
        PuffinCompressionCodec codec = BY_NAME.get(codecName);
        Preconditions.checkArgument(codec != null, "Unknown codec name: %s", (Object)codecName);
        return codec;
    }

    static {
        BY_NAME = Stream.of(PuffinCompressionCodec.values()).collect(Collectors.toMap(PuffinCompressionCodec::codecName, Function.identity(), (a, b) -> {
            throw new UnsupportedOperationException("Two enum instances with same name");
        }, Maps::newHashMap));
    }
}

