/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.cleanup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.cleanup.CleanupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventualCleanupService
implements CleanupService {
    private final int threadCount;
    private final int queueSize;
    private final ThreadFactory factory;
    private final Logger LOG = LoggerFactory.getLogger((String)EventualCleanupService.class.getName());
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final BlockingQueue<AsyncDeleteAction> deleteActions;
    private ExecutorService cleanerExecutorService;

    public EventualCleanupService(int threadCount, int queueSize) {
        if (queueSize < threadCount) {
            throw new IllegalArgumentException("Queue size should be greater or equal to thread count. Queue size: " + queueSize + ", thread count: " + threadCount);
        }
        this.factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EventualCleanupService thread %d").build();
        this.threadCount = threadCount;
        this.queueSize = queueSize;
        this.deleteActions = new LinkedBlockingQueue<AsyncDeleteAction>(queueSize);
    }

    @Override
    public synchronized void start() {
        if (this.cleanerExecutorService != null) {
            this.LOG.debug("EventualCleanupService is already running.");
            return;
        }
        this.cleanerExecutorService = Executors.newFixedThreadPool(this.threadCount, this.factory);
        for (int i = 0; i < this.threadCount; ++i) {
            this.cleanerExecutorService.submit(new CleanupRunnable());
        }
        this.LOG.info("EventualCleanupService started with {} threads and queue of size {}", (Object)this.threadCount, (Object)this.queueSize);
    }

    @Override
    public boolean deleteRecursive(Path path, FileSystem fileSystem) {
        if (this.isRunning.get()) {
            if (this.deleteActions.offer(new AsyncDeleteAction(path, fileSystem))) {
                this.LOG.info("Delete {} operation was queued", (Object)path);
            } else {
                try {
                    fileSystem.cancelDeleteOnExit(path);
                    fileSystem.delete(path, true);
                    this.LOG.info("Deleted {} synchronously as the async queue was full", (Object)path);
                }
                catch (IOException e) {
                    this.LOG.warn("Error removing path {}: {}", (Object)path, (Object)e);
                }
            }
            return true;
        }
        this.LOG.warn("Delete request {} was ignored as cleanup service is shutting down", (Object)path);
        return false;
    }

    @Override
    public void shutdown() {
        this.isRunning.set(false);
        this.cleanerExecutorService.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.isRunning.set(false);
        this.cleanerExecutorService.shutdownNow();
    }

    @VisibleForTesting
    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.cleanerExecutorService.awaitTermination(timeout, timeUnit);
    }

    private class CleanupRunnable
    implements Runnable {
        private CleanupRunnable() {
        }

        @Override
        public void run() {
            while (EventualCleanupService.this.isRunning.get() || EventualCleanupService.this.deleteActions.size() > 0) {
                try {
                    AsyncDeleteAction deleteAction = EventualCleanupService.this.deleteActions.poll(1L, TimeUnit.MINUTES);
                    if (deleteAction == null) continue;
                    Path path = null;
                    try {
                        FileSystem fs = deleteAction.fileSystem;
                        path = deleteAction.path;
                        fs.delete(path, true);
                        fs.cancelDeleteOnExit(path);
                        EventualCleanupService.this.LOG.info("Deleted {}", (Object)path);
                    }
                    catch (IOException e) {
                        EventualCleanupService.this.LOG.warn("Error removing path {}: {}", (Object)path, (Object)e);
                    }
                }
                catch (InterruptedException e) {
                    EventualCleanupService.this.LOG.debug("PathCleaner was interrupted");
                }
            }
            EventualCleanupService.this.LOG.info("Cleanup thread shutdown shutdown");
        }
    }

    private static class AsyncDeleteAction {
        Path path;
        FileSystem fileSystem;

        public AsyncDeleteAction(Path path, FileSystem fileSystem) {
            this.path = path;
            this.fileSystem = fileSystem;
        }
    }
}

