/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.create;

import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.catalog.create.CreateCatalogDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class CreateCatalogOperation
extends DDLOperation<CreateCatalogDesc> {
    public CreateCatalogOperation(DDLOperationContext context, CreateCatalogDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        Catalog catalog = new Catalog(((CreateCatalogDesc)this.desc).getName(), ((CreateCatalogDesc)this.desc).getLocationUri());
        catalog.setDescription(((CreateCatalogDesc)this.desc).getComment());
        try {
            this.context.getDb().createCatalog(catalog, ((CreateCatalogDesc)this.desc).isIfNotExists());
        }
        catch (AlreadyExistsException e) {
            throw new HiveException((Throwable)e, ErrorMsg.CATALOG_ALREADY_EXISTS, new String[]{((CreateCatalogDesc)this.desc).getName()});
        }
        return 0;
    }
}

