/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.drop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.drop.DropTableDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1006})
public class DropTableAnalyzer
extends BaseSemanticAnalyzer {
    public DropTableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        Table table;
        TableName qualTabName = DropTableAnalyzer.getQualifiedTableName((ASTNode)root.getChild(0));
        String tableName = qualTabName.getNotEmptyDbTable();
        boolean ifExists = root.getFirstChildWithType(1050) != null;
        boolean throwException = !ifExists && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DROP_IGNORES_NON_EXISTENT);
        Database database = this.getDatabase(qualTabName.getDb(), false);
        if (database != null) {
            this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_SHARED));
        }
        if ((table = this.getTable(tableName, throwException)) != null) {
            this.inputs.add(new ReadEntity(table));
            boolean tableWithSuffix = AcidUtils.isTableSoftDeleteEnabled(table, this.conf);
            this.outputs.add(new WriteEntity(table, tableWithSuffix ? WriteEntity.WriteType.DDL_EXCL_WRITE : WriteEntity.WriteType.DDL_EXCLUSIVE));
        }
        boolean purge = root.getFirstChildWithType(274) != null;
        ReplicationSpec replicationSpec = new ReplicationSpec(root);
        DropTableDesc desc = new DropTableDesc(tableName, ifExists, purge, replicationSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

