/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.tables;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.show.tables.ShowTablesDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.show.tables.ShowTablesFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFLike;

public class ShowTablesOperation
extends DDLOperation<ShowTablesDesc> {
    public ShowTablesOperation(DDLOperationContext context, ShowTablesDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (!this.context.getDb().databaseExists(((ShowTablesDesc)this.desc).getDbName())) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, new String[]{((ShowTablesDesc)this.desc).getDbName()});
        }
        if (!((ShowTablesDesc)this.desc).isExtended()) {
            this.showTables();
        } else {
            this.showTablesExtended();
        }
        return 0;
    }

    private void showTables() throws HiveException {
        String pattern = UDFLike.likePatternToRegExp(((ShowTablesDesc)this.desc).getPattern(), false, true);
        ArrayList<String> tableNames = new ArrayList<String>(this.context.getDb().getTablesByType(((ShowTablesDesc)this.desc).getDbName(), pattern, ((ShowTablesDesc)this.desc).getTypeFilter()));
        Collections.sort(tableNames);
        LOG.debug("Found {} table(s) matching the SHOW TABLES statement.", (Object)tableNames.size());
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowTablesDesc)this.desc).getResFile()), this.context);){
            ShowTablesFormatter formatter = ShowTablesFormatter.getFormatter(this.context.getConf());
            formatter.showTables(os, tableNames);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"in database " + ((ShowTablesDesc)this.desc).getDbName()});
        }
    }

    private void showTablesExtended() throws HiveException {
        TableType[] tableTypes;
        TableType[] tableTypeArray;
        TreeMap<String, String> tableNameToType = new TreeMap<String, String>();
        String pattern = UDFLike.likePatternToRegExp(((ShowTablesDesc)this.desc).getPattern(), false, true);
        TableType typeFilter = ((ShowTablesDesc)this.desc).getTypeFilter();
        if (typeFilter == null) {
            tableTypeArray = TableType.values();
        } else {
            TableType[] tableTypeArray2 = new TableType[1];
            tableTypeArray = tableTypeArray2;
            tableTypeArray2[0] = typeFilter;
        }
        for (TableType tableType : tableTypes = tableTypeArray) {
            List<String> tables = this.context.getDb().getTablesByType(((ShowTablesDesc)this.desc).getDbName(), pattern, tableType);
            tables.forEach(name -> tableNameToType.put((String)name, tableType.toString()));
        }
        LOG.debug("Found {} table(s) matching the SHOW EXTENDED TABLES statement.", (Object)tableNameToType.size());
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowTablesDesc)this.desc).getResFile()), this.context);){
            ShowTablesFormatter formatter = ShowTablesFormatter.getFormatter(this.context.getConf());
            formatter.showTablesExtended(os, tableNameToType);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"in database " + ((ShowTablesDesc)this.desc).getDbName()});
        }
    }
}

