/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.cluster.AlterTableClusteredByDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.cluster.AlterTableNotClusteredDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.cluster.AlterTableNotSortedDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={863})
public class AlterTableClusterSortAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableClusterSortAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        AbstractAlterTableDesc desc = switch (command.getChild(0).getType()) {
            case 1096 -> new AlterTableNotClusteredDesc(tableName, partitionSpec);
            case 1099 -> new AlterTableNotSortedDesc(tableName, partitionSpec);
            case 861 -> {
                ASTNode buckets = (ASTNode)command.getChild(0);
                List<String> bucketCols = AlterTableClusterSortAnalyzer.getColumnNames((ASTNode)buckets.getChild(0));
                ArrayList<Order> sortCols = new ArrayList();
                int numBuckets = -1;
                if (buckets.getChildCount() == 2) {
                    numBuckets = Integer.parseInt(buckets.getChild(1).getText());
                } else {
                    sortCols = this.getColumnNamesOrder((ASTNode)buckets.getChild(1));
                    numBuckets = Integer.parseInt(buckets.getChild(2).getText());
                }
                if (numBuckets <= 0) {
                    throw new SemanticException(ErrorMsg.INVALID_BUCKET_NUMBER.getMsg());
                }
                yield new AlterTableClusteredByDesc(tableName, partitionSpec, numBuckets, bucketCols, sortCols);
            }
            default -> throw new SemanticException("Invalid operation " + command.getChild(0).getType());
        };
        this.addInputsOutputsAlterTable(tableName, partitionSpec, desc, desc.getType(), false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.setAcidDdlDesc(this.getTable(tableName), desc);
    }
}

